/*
NaturalScience v1.2.1 by Sheldor.  05/07/2024  Code size:  249 bytes
a nano melee bot based on Quantum and DustBunny
v1.2.1 -- energy management

Credits:
	d414.nano.Quantum 0.2.2, mld.DustBunny 3.8
Also, a general thanks to all open source bot authors and contributors to the RoboWiki.

NaturalScience is open source and released under the terms of the RoboWiki Public Code License (RWPCL) - Version 1.1.
see license here:  https://robowiki.net/wiki/RWPCL
*/

package sheldor.melee.nano;

import robocode.*;
import robocode.util.Utils;

import java.awt.Color;

public class NaturalScience extends AdvancedRobot {
    // ---------------------------------------------------------------------------------------------
    // Tuning Knobs
    // ---------------------------------------------------------------------------------------------
    static final double WALL_FORCE = 1;
    static final double AGRAV_DECAY = 0.9;
    static final double AHEAD_AMOUNT = 120;

    static final double AIM_START = 10;
    static final double AIM_FACTOR = 1.008;
    static final double RADAR_LOCK_THRESHOLD = 0.8;
    static final int    POWER_FACTOR = 2;

    // ---------------------------------------------------------------------------------------------
    // Globals
    // ---------------------------------------------------------------------------------------------
    static String targetName;
    static int targetDistance;
    static double xForce;
    static double yForce;

    public void run() {
        setAdjustGunForRobotTurn(true);
        setTurnRadarRight(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        int intDistance;
        double aimAngle;
        double absoluteBearing;

        setTurnRightRadians(Utils.normalRelativeAngle(
                    Math.atan2(
                        (xForce = xForce * AGRAV_DECAY
                         - Math.sin(
                             aimAngle = (absoluteBearing = e.getBearingRadians() + getHeadingRadians())
                             + (e.getVelocity()
                                 / (AIM_START + Math.pow(AIM_FACTOR, intDistance = (int)(e.getDistance())))
                               )
                             * Math.sin(e.getHeadingRadians() - absoluteBearing)
                             ) / intDistance
                        )
                        + calcWallForce(getX())
                        , 
                        (yForce = yForce * AGRAV_DECAY - Math.cos(aimAngle) / intDistance)
                        + calcWallForce(getY())
                        )
                    - getHeadingRadians()
                    ));
        setAhead(AHEAD_AMOUNT - Math.abs(getTurnRemaining()));        
		
        if (intDistance < (targetDistance += 25)) {

            if (getGunHeat() <= RADAR_LOCK_THRESHOLD) {
                setTurnRadarLeft(getRadarTurnRemaining());
            }	
		
		setFire(((640 / (targetDistance = intDistance)) * BULLET_POWER_TABLE.charAt(((((int)getEnergy()) >> 2) * 127) + ((int)e.getEnergy()))) / 100.01);
     		 setTurnGunRightRadians(Utils.normalRelativeAngle(aimAngle - getGunHeadingRadians()));		
        }
    }

    public static double calcWallForce(double d) {
        return (WALL_FORCE / d) - (WALL_FORCE / (1000 - d));
    }
	
	static final String BP300 = ""
	+ (char)300 + (char)300 + (char)300 + (char)300
	+ (char)300 + (char)300 + (char)300 + (char)300
	+ (char)300 + (char)300 + (char)300 + (char)300
	+ (char)300 + (char)300 + (char)300 + (char)300
	+ (char)300 + (char)300 + (char)300 + (char)300;	
	
	static final String BP250 = ""	
	+ (char)250 + (char)250 + (char)250 + (char)250
	+ (char)250 + (char)250 + (char)250 + (char)250
	+ (char)250 + (char)250 + (char)250 + (char)250
	+ (char)250 + (char)250 + (char)250 + (char)250
	+ (char)250 + (char)250 + (char)250 + (char)250;
	
	static final String BP200 = ""	
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200;
		
	static final String BP150 = ""	
	+ (char)150 + (char)150 + (char)150 + (char)150
	+ (char)150 + (char)150 + (char)150 + (char)150
	+ (char)150 + (char)150 + (char)150 + (char)150
	+ (char)150 + (char)150 + (char)150 + (char)150
	+ (char)150 + (char)150 + (char)150 + (char)150;
	
	static final String BP100 = ""	
	+ (char)100 + (char)100 + (char)100 + (char)100
	+ (char)100 + (char)100 + (char)100 + (char)100
	+ (char)100 + (char)100 + (char)100 + (char)100
	+ (char)100 + (char)100 + (char)100 + (char)100
	+ (char)100 + (char)100 + (char)100 + (char)100;
		
	static final String BP50 = ""	
	+ (char)50 + (char)50 + (char)50 + (char)50
	+ (char)50 + (char)50 + (char)50 + (char)50
	+ (char)50 + (char)50 + (char)50 + (char)50
	+ (char)50 + (char)50 + (char)50 + (char)50
	+ (char)50 + (char)50 + (char)50 + (char)50;
	
	static final String BP5 = ""	
	+ (char)5 + (char)5 + (char)5 + (char)5
	+ (char)5 + (char)5 + (char)5 + (char)5
	+ (char)5 + (char)5 + (char)5 + (char)5
	+ (char)5 + (char)5 + (char)5 + (char)5
	+ (char)5 + (char)5 + (char)5 + (char)5;	
	
	static final String HIGH_ENERGY = ""	
	+ (char)25 + (char)50 + (char)75 + (char)100
	+ (char)117 + (char)134 + (char)150 + (char)167
	+ (char)184 + (char)200 + (char)217 + (char)234	
	+ (char)250 + (char)267 + (char)284 + (char)300	
	
	+ BP250	+ BP250	+ BP250	+ BP250	+ BP250
	
	+ (char)250 + (char)250 + (char)250 + (char)250
	+ (char)250 + (char)250 + (char)250 + (char)250
	+ (char)250 + (char)250 + (char)250;
	
	static final String MID_ENERGY = ""	
	+ (char)25 + (char)50 + (char)75 + (char)100
	+ (char)117 + (char)134 + (char)150 + (char)167
	+ (char)184 + (char)200 + (char)217 + (char)234	
	
	+ (char)250 + (char)250 + (char)250 + (char)250	
	+ (char)250 + (char)250 + (char)250 + (char)250	
	
	+ BP250	+ BP250	+ BP250	+ BP250	+ BP250
	
	+ (char)250 + (char)250 + (char)250 + (char)250
	+ (char)250 + (char)250 + (char)250;	

	public static final String BULLET_POWER_TABLE = ""
	//0 * 127
	+ BP5 + BP5 + BP5	+ BP5 + BP5 + BP5
	
	+ (char)5 + (char)5 + (char)5 + (char)5
	+ (char)5 + (char)5 + (char)5
	
	//1 * 127
	+ (char)25 + (char)50 
	
	+ BP50 + BP50 + BP50	+ BP50 + BP50 + BP50
	
	+ (char)50 + (char)50 + (char)50 + (char)50
	+ (char)50
	
	//2 * 127		
	+ (char)25 + (char)50 
	
	+ BP50 + BP50 + BP50	+ BP50 + BP50 + BP50
	
	+ (char)50 + (char)50 + (char)50 + (char)50
	+ (char)50
	
	//3 * 127	
	+ (char)25 + (char)50 + (char)75 + (char)100
	
	+ BP100 + BP100 + BP100 + BP100 + BP100 + BP100
	
	+ (char)100 + (char)100 + (char)100
	
	//4 * 127	
	+ (char)25 + (char)50 + (char)75 + (char)100
	
	+ BP100 + BP100 + BP100 + BP100 + BP100 + BP100
	
	+ (char)100 + (char)100 + (char)100
	
	//5 * 127	
	+ (char)25 + (char)50 + (char)75 + (char)100
	+ (char)117 + (char)134 + (char)150
	
	+ BP150 + BP150 + BP150 + BP150 + BP150 + BP150
		
	//6 * 127
	+ (char)25 + (char)50 + (char)75 + (char)100
	+ (char)117 + (char)134 + (char)150
	
	+ BP150 + BP150 + BP150 + BP150 + BP150 + BP150
	
	//7 * 127	
	+ (char)25 + (char)50 + (char)75 + (char)100
	+ (char)117 + (char)134 + (char)150 + (char)167
	+ (char)184 + (char)200 + (char)217 + (char)234		
	+ (char)250
	
	+ BP200	 + BP200 + BP200 + BP200 + BP200
	
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200
	
	//8 * 127	
	+ (char)25 + (char)50 + (char)75 + (char)100
	+ (char)117 + (char)134 + (char)150 + (char)167
	+ (char)184 + (char)200 + (char)217 + (char)234		
	+ (char)250
	
	+ BP200	 + BP200 + BP200 + BP200 + BP200
	
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200
		
	//9 * 127	
	+ (char)25 + (char)50 + (char)75 + (char)100
	+ (char)117 + (char)134 + (char)150 + (char)167
	+ (char)184 + (char)200 + (char)217 + (char)234		
	+ (char)250
	
	+ BP200	 + BP200 + BP200 + BP200 + BP200
	
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200 + (char)200 + (char)200
	+ (char)200 + (char)200
	
	//10 * 127	
	+ MID_ENERGY
	
	//11 * 127	
	+ MID_ENERGY
	
	//12 * 127
	+ MID_ENERGY
	
	//13 * 127
	+ MID_ENERGY
	
	//14 * 127
	+ MID_ENERGY
	
	//15 * 127
	+ MID_ENERGY
	
	//16 * 127
	+ MID_ENERGY
	
	//17 * 127
	+ HIGH_ENERGY
	
	//18 * 127
	+ HIGH_ENERGY
	
	//19 * 127
	+ HIGH_ENERGY
	
	//20 * 127
	+ HIGH_ENERGY
	
	//21 * 127
	+ HIGH_ENERGY
	
	//22 * 127
	+ HIGH_ENERGY
	
	//23 * 127
	+ HIGH_ENERGY
	
	//24 * 127
	+ HIGH_ENERGY
	
	//25 * 127
	+ HIGH_ENERGY
	
	//26 * 127
	+ HIGH_ENERGY
	
	//27 * 127
	+ HIGH_ENERGY
	
	//28 * 127
	+ HIGH_ENERGY
	
	//29 * 127
	+ HIGH_ENERGY
	
	//30 * 127
	+ HIGH_ENERGY
	
	//31 * 127
	+ HIGH_ENERGY
	
	//32 * 127
	+ HIGH_ENERGY
	
	+ BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300
	+ BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300
	+ BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300
	+ BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300 + BP300;
}
