package tm;
import robocode.*;
import java.math.*;
import java.util.*;

/********************************************************************
* MyRobot.java
*
* Date:		2002/Oct/18
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.

********************************************************************/
public class MyRobot extends AdvancedRobot {
	double EPSILON = 50;			//ړIW̌덷
	static final int NORTH = 1;
	static final int EAST = 2;
	static final int SOUTH = 4;
	static final int WEST = 8;
	static final int NW = 0;
	static final int NE = 1;
	static final int SE = 2;
	static final int SW = 3;
	boolean isAhead = false;			//true = OiCfalse = 
	final int NEAR_WALL_DISTANCE_FOR_RADAR = 100;		//ǂɋ߂Ɣ肳鋗
		
	Result result = new Result();
	static int rounds = 0;
	
	public double fW, fH;				//field size
	double robotSize;
	public FieldMap map = new FieldMap();
	
	public int nearWallIndex = 0;				//Klȉ̕
	public int lastNearWallIndex = 0;			//ȑOnearWallIndex
	
	Random rand = new Random(System.currentTimeMillis());
	
	MyRobot1on1 robotKKZ;				// for 1 on 1
	Enemy target = new Enemy();
	
	EnemyHistory3 ehis;
	static EnemyHistory3B ehis3B = new EnemyHistory3B(500);
	static EnemyHistory4 ehis4 = new EnemyHistory4(500);
	EnemyHistory6 ehis6;
	static EnemyHistory3Melee ehism = new EnemyHistory3Melee();
	static EnemyHistory4Melee ehism4 = new EnemyHistory4Melee();
	static EnemyHistory4Melee ehism4Few = new EnemyHistory4Melee();
	static EnemyHistory3BMelee ehism3B = new EnemyHistory3BMelee();

	SelecterYK selecter = new SelecterYK(this);
	
	Radar radar;
	Move move;
	Gun gun;
	
	//------------------------------------------------------------------
	// init()
	//
	//------------------------------------------------------------------
	void init() {
		rounds++;
		
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		
		fW = getBattleFieldWidth();
		fH = getBattleFieldHeight();
		robotSize = getWidth() * 1.5;
		
		result.setTotalRobots(getOthers() + 1);
		result.setNumRounds(getNumRounds());
	}
	
	
	//------------------------------------------------------------------
	// r2d() -- radian degree ϊ
	//
	//------------------------------------------------------------------
	double r2d(double rad) {
		return (rad * 180 / Math.PI);
	}
	
	void print(String str) {
		System.out.println(str);	
	}


	//---------------------------------------------------------------
	// angleUnder180() -- }180xȉ̊pxɒ
	//
	//---------------------------------------------------------------
	double angleUnder180(double deg) {
		return M.angleUnder180(deg);
	
	/*
		if (deg > -180 && deg <= 180) return deg;
		
		if (deg > 180) return (deg - 360);
		else           return (360 + deg);
	*/
	}
	
	//------------------------------------------------------------------
	// isArrived() -- dstX, dstY ̓BH
	//
	//
	//------------------------------------------------------------------
	boolean isArrived(double dstX, double dstY) {
		//if (Math.abs(getX() - dstX) < Epsiron && Math.abs(getY() - dstY) < Epsiron) return true;
		double dx = dstX - getX();
		double dy = dstY - getY();
		
		return (Math.sqrt(dx * dx + dy * dy) < EPSILON);
	}

	//------------------------------------------
	// goPos() -- dstX, dstY ɍs
	//            ubLO\bh
	//------------------------------------------
	public void goPos(double dstX, double dstY) {
		double x = getX();
		double y = getY();
		double dx = dstX - x;
		double dy = dstY - y;
		double angle;
		
		//turnLeft(getHeading());		//turn North
		angle = r2d(Math.atan2(dy, dx));
		angle = 90 - angle;
		angle = angle - getHeading();
		angle = angleUnder180(angle);
		turnRight(angle);
		ahead(Math.sqrt(dx * dx + dy * dy));
	}
	
	//----------------------------------------------------
	// setGoPos() -- dstX, dstY ɍs
	//               ubLO\bh
	//
	//----------------------------------------------------
	void setGoPos(double dstX, double dstY) {
		double x = getX();
		double y = getY();
		double dx = dstX - x;
		double dy = dstY - y;
		double angle;
		
		angle = r2d(Math.atan2(dy, dx));
		angle = 90 - angle;
		angle = angle - getHeading();
		//]180xȓ
		if (angle > 180) angle = angle - 360;
		else if (angle < -180) angle = angle + 360;
		//]90xȓ
		if (Math.abs(angle) <= 90) {
			//Oi
			isAhead = true;
			setTurnRight(angle);
			//setTurnRight(angle + rand.nextInt(19) - 9);
			setAhead(Math.sqrt(dx * dx + dy * dy));
		} else {
			//
			isAhead = false;
			if (angle > 0) angle -= 180;
			else           angle += 180;
			setTurnRight(angle);
//			setTurnRight(angle + rand.nextInt(19) - 9);
			setBack(Math.sqrt(dx * dx + dy * dy));
		}
	}

	//--------------------------------------------------------------
	// getNearWallIndex() -- Klȉ̋߂ǂԂ
	//                       R[i[͕ǃCfbNX̘aőΉ
	//
	//-------------------------------------------------------------
	public int getNearWallIndex() {
		int index = 0;
		
		if (fH - getY() < NEAR_WALL_DISTANCE_FOR_RADAR) index += NORTH;
		if (fW - getX() < NEAR_WALL_DISTANCE_FOR_RADAR) index += EAST;
		if (getY() < NEAR_WALL_DISTANCE_FOR_RADAR) index += SOUTH;
		if (getX() < NEAR_WALL_DISTANCE_FOR_RADAR) index += WEST;
		
		return index;
	}
	
	//---------------------------------------------------------
	// getTarget() -- 1 on 1 robot ̃^[Qbg̃CX^XԂ
	//
	//
	//---------------------------------------------------------
	public Enemy getTarget() {
		return target;
	}
	
	
	//--------------------------
	//
	//-------------------------
	void printResult() {
		result.setRemainRobots(getOthers());
		result.setWorkingTime(getTime());
		result.printResult();
		
		if (getNumRounds() == rounds) {
			result.printTotalResult();	
		}
	}
	
	/*****************************************************
	 * Event
	 */
	public void onSkippedTurn(SkippedTurnEvent e) {
		result.skip();
	}
	
	/* death */
	public void onDeath(DeathEvent e) {
		print("I shall return.");
		printResult();
	}	

	/* win */
	public void onWin(WinEvent e) {
		print("I won!");
		printResult();
		
		winDance();
	}
	
	//-------------------------------------------
	// winDance()
	//-------------------------------------------
	void winDance() {
		goPos(fW / 2 + 100, fH / 2 + 100);
		
		setAdjustRadarForRobotTurn(false);
		setAdjustRadarForGunTurn(false);
		setAdjustGunForRobotTurn(false);
		
		turnLeft((getHeading()+ 230) % 360);
		turnGunLeft((getGunHeading()+230)%360);
		turnRadarLeft((getRadarHeading()+230)%360);
		

		setMaxVelocity(8);
		
		for (int i = 0; i < 45; i++) {
			setAhead(90);
			setTurnRight(100);
			execute();
		}
		setMaxVelocity(0);
		turnRight((360-getHeading())%360);
	}

	//-------------------------------------------
	// winDanceStar()
	//-------------------------------------------
	void winDanceStar() {
		int sx, sy;
		sx = 400;
		sy = 377;
		
		setAdjustRadarForRobotTurn(false);
		setAdjustRadarForGunTurn(false);
		setAdjustGunForRobotTurn(false);		

		
		goPos(sx, sy);
		turnLeft(getHeading());
		turnGunLeft(getGunHeading());
		turnRadarLeft(getRadarHeading());
		
		goPos(sx + 50, sy - 154);		//2
		goPos(sx - 81, sy - 59);		//4
		goPos(sx + 81, sy - 59);		//1
		goPos(sx - 50, sy - 154);		//3
		goPos(sx, sy);					//0						
	}
	
	/* hit by bullet */
	public void onHitByBullet(HitByBulletEvent e) {
		result.damage();
	}

	/* onBulletHit  */
	public void onBulletHit(BulletHitEvent e) {
		result.hitAnyone();
	}
	
	/*  onRobotDeath */
	public void onRobotDeath(RobotDeathEvent e) {
		//M.print("----- Robot Death!! -- " + e.getName());
	}	
}