package adt;
import robocode.*;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.awt.geom.Point2D;

/**
 * Ar2 - a robot by Al
 */
public class Ar2 extends AdvancedRobot
{
	boolean aiming = false;
	String lastTarget = null;
	long lastSighting=0;
	int shotsAtTrarget=0;
	double lastTargetEnergy=500;
	double lastRange=100000;
	Context my;// = new Context();
	RobotTracker tracker;// = new PredictiveRobotTracker(this,my);
	static int bumpCount = 0;
	static int skipCount = 0;
	boolean leftScan=true;
	double scanDrift=0;
	double scanSize=22.5;

	
	/**
	 * run: Ar1's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		addCustomEvent( new MoveCompleteCondition(this) );
		addCustomEvent( new RadarTurnCompleteCondition(this) );
		addCustomEvent( new GunTurnCompleteCondition(this) );
		addCustomEvent( new TurnCompleteCondition(this) );
								
		setColors(new Color(100,128,96),Color.green,new Color(200,210,215));
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setTurnRadarLeft(360);

		my = new Context();
		tracker = new PredictiveRobotTracker(this,my);
			
		while(true) {
						
			my.x = getX();
			my.y = getY();
			my.vx = getVelocity()*Math.sin( getHeadingRadians() );
			my.vy = getVelocity()*Math.cos( getHeadingRadians() );
			my.gh = getGunHeading();
			
			if ( !aiming )
			{
				aiming=true;
				aimAt( tracker.getAimPoint(lastTarget) );
			}
				
			execute();
		}
	}

	public void onEndOfRound()
	{
		out.println( bumpCount+" wall bumps.");
		out.println( skipCount+" skipped turns.");
	}
	
	public void onDeath(DeathEvent event) 
	{
		onEndOfRound();
	}
	
	public void onWin(WinEvent event) 
	{
		setMaxVelocity(3);		
		driveAt( new Point2D.Double( getBattleFieldWidth()/2, getBattleFieldHeight()/2 ),0 );
		onEndOfRound();
	}
	
	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
				
		tracker.updateBot( e );
		
		if ( (lastTarget==null) || (e.getName().equals(lastTarget)) )
		{
			//if ( (getOthers()<2) || Math.random()<=(0.5/(getOthers()+1)) )
			//{
				leftScan = !leftScan; //setTurnRadarLeft(45);
				scanDrift = (scanSize/2 - getRadarTurnRemaining()*1.1);
			//}
		}
		
		if ( (lastTarget!=null) && (!e.getName().equals(lastTarget)) )
		{
			// not our last target - do we want to switch ?
			if (
				( lastSighting < (getTime()-30) )
			||	( e.getDistance() < (lastRange*0.5) && Math.random()>0.3 )
			||	( e.getEnergy() < 32 && e.getEnergy()<lastTargetEnergy )
			||	( shotsAtTrarget==0 && e.getDistance() < lastRange*0.9 )
			)
			{
				lastTarget = e.getName();
				lastRange = e.getDistance();
				shotsAtTrarget=0;
				lastTargetEnergy=e.getEnergy();
			}
			
		}
		else if (lastTarget==null)
		{
			lastTarget = e.getName();
			lastRange = e.getDistance();
			shotsAtTrarget=0;
			lastTargetEnergy=e.getEnergy();
		}

		if ( e.getName().equals(lastTarget) )
		{
			lastSighting = getTime();
			lastTargetEnergy=e.getEnergy();
		}
	}

	public void aimAt( Point2D.Double aimPoint )
	{
		//out.println( "aimAt( "+ aimPoint +" )" );
		
		if ( aimPoint != null )
		{
			double dx = aimPoint.getX() - getX();
			double dy = aimPoint.getY() - getY();
			double t  = Math.atan2( dx,dy );
			double gunTurn = t - getGunHeadingRadians() ;
			if ( Math.abs(gunTurn)>Math.PI )
			{
				gunTurn = (gunTurn<0?1:-1)*( Math.PI*2 - Math.abs(gunTurn) );
			}
			if ( Math.abs(gunTurn) > (Math.PI/2) )
			{
				out.println( "*** Big gun turn: "+gunTurn*180/Math.PI+" , th: "+t*180/Math.PI+" , gh: "+getGunHeadingRadians()*180/Math.PI);
			}
			if ( gunTurn > 0 )
			{
				setTurnGunRightRadians( gunTurn );
			}
			else
			{
				setTurnGunLeftRadians( -gunTurn );
			}
		}							
	}
	
	public void driveAt( Point2D.Double aimPoint, double offset )
	{
		if ( aimPoint != null )
		{
			double dx = aimPoint.getX() - getX();
			double dy = aimPoint.getY() - getY();
			double t  = Math.atan2( dx,dy );
			double turn = t - getHeadingRadians() ;
			if ( Math.abs(turn)>Math.PI )
			{
				turn = (turn<0?1:-1)*( Math.PI*2 - Math.abs(turn) );
			}
			if ( turn > 0 )
			{
				setTurnRightRadians( turn%(Math.PI*2)+offset );
			}
			else
			{
				setTurnLeftRadians( -turn%(Math.PI*2)-offset );
			}
		}							
	}
	
	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		setTurnLeft( (90 - e.getBearing())*0.75);
		if ( !e.getName().equals(lastTarget) && Math.random()<0.05 )
		{
			lastTarget = e.getName();
			shotsAtTrarget=0;
		}
	}

	public void onHitWall(HitWallEvent event) {
		if ( Math.abs(event.getBearing()) < 90 )
		{
			// its in front of us
			setBack(25);
		}
		else
		{
			setAhead(25);
		}			
		setTurnLeft( 0.51*(180.0-event.getBearing()));
		bumpCount++;
   }

	public void onRobotDeath(RobotDeathEvent event) {
		if ( event.getName().equals(lastTarget) ) {
			lastTarget=null;
			aiming=false;
			shotsAtTrarget=0;
		}
	}
	
	public void onHitRobot(HitRobotEvent event)
	{
		if (event.getBearing() > -90 && event.getBearing() <= 90)
		{
			setBack(40);
			if (event.getBearing() > 0)
			{
				setTurnLeft( 90-event.getBearing() );
			}
			else
			{
				setTurnRight( 90+event.getBearing() );
			}
		}
		else
		{
			setAhead(40);
			setTurnRight( 90+event.getBearing() );
		}
                if (lastTarget==null || lastRange>100)
		{
                    lastTarget=event.getName();
                    lastRange=80;
					shotsAtTrarget=0;
                }
	}
	
	public void onCustomEvent(CustomEvent event) {
		if ( event.getCondition() instanceof GunTurnCompleteCondition )
		{
			onGunTurnComplete();
		}
		else if ( event.getCondition() instanceof MoveCompleteCondition )
		{
			onMoveComplete();
		}
		else if ( event.getCondition() instanceof RadarTurnCompleteCondition )
		{
			onRadarTurnComplete();
		}
		else if ( event.getCondition() instanceof TurnCompleteCondition )
		{
			onTurnComplete();
		}
	}
	 
	public void onMoveComplete() {
            if ( Math.random() > 0.4 )
            {
		setAhead( 100*(1+Math.random()) );
            }
            else
            {
                setBack( 100*(1+Math.random()) );
            }
	}	

	public void onRadarTurnComplete() {
		
		if (leftScan) {
			setTurnRadarLeft(scanSize+scanDrift);
		}
		else {
			setTurnRadarRight(scanSize+scanDrift);
		}
		scanDrift=0;
	}	

	public void onGunTurnComplete() {
		if ( aiming && lastTarget!=null )
		{
			aiming = false;
			if ( getEnergy() > 10 )
			{
				setFire(getKillPower(lastTarget,3));
			}
			else
			{
				setFire( getKillPower(lastTarget,getEnergy()/10.0) );
			}
			shotsAtTrarget++;
		}
	}
	
	public double getKillPower( String target, double limit )
	{
		double enemyEnergy = tracker.getEnergy( target );
		double killEnergy = 0.0;
		
		//out.println( target+" has "+enemyEnergy );
		if (enemyEnergy>4)
		{
			killEnergy = (enemyEnergy+2.0)/6.0;
		}
		else
		{
			killEnergy = enemyEnergy/4.0;
		}
		if ( killEnergy > limit )
		{
			killEnergy = limit;
		}
		else
		{
			//out.println( "we only need "+killEnergy+" to kill "+target );
		}
		return killEnergy;
	}
	
	public void onTurnComplete()
	{
		double x=getX();
		double y=getY();
		double w=getBattleFieldWidth();
		double h=getBattleFieldHeight();
		final int wall=200;
		final double wallTurnSp=8.0;
		final int wallTurn=90;
				
		setMaxVelocity(8-2*Math.random()*Math.random());		
		if (x < wall || y < wall || x > (w-wall) || y > (h-wall) )
		{
			if ( x < wall && getHeading() > 180 )
			{
				if ( getHeading() < 270 )
				{
					setTurnLeft( wallTurn );
				}
				else
				{
					setTurnRight( wallTurn );
				}
				setMaxVelocity(wallTurnSp);		
			}
			else if ( y < wall && getHeading() > 90 && getHeading() < 270 )
			{
				if ( getHeading() < 180 )
				{
					setTurnLeft( wallTurn );
				}
				else
				{
					setTurnRight( wallTurn );
				}
				setMaxVelocity(wallTurnSp);		
			}
			// ---
			if ( (y > (h-wall)) && (getHeading() > 270 || getHeading() < 90) )
			{
				if ( getHeading() > 270 )
				{
					setTurnLeft( wallTurn );
				}
				else
				{
					setTurnRight( wallTurn );
				}
				setMaxVelocity(wallTurnSp);		
			}
			else if ( x > (w-wall) && getHeading() < 180 )
			{
				if ( getHeading() < 90 )
				{
					setTurnLeft( wallTurn );
				}
				else
				{
					setTurnRight( wallTurn );
				}
				setMaxVelocity(wallTurnSp);		
			}
		}
		else if ( lastRange>200 && Math.random()<0.8 )
		{
			driveAt( tracker.getAimPoint(lastTarget),1 );
		}
		else if ( lastRange<150  && Math.random()<0.6 )
		{
			driveAt( tracker.getAimPoint(lastTarget),-2 );
		}
		else					
		{
			setTurnLeft(3*(Math.random()-Math.random()*0.999));
		}
	}
	
	public void onSkippedTurn(SkippedTurnEvent event)
	{
		skipCount++;
	}
}
