package djc.movement;

import djc.*;
import djc.util.*;

import java.awt.*;
import java.awt.geom.*;
import robocode.*;

/**
 * BaseMovement class - this guy is a sitting duck...
 */
public class BaseMovement
{
	AbstractDynaBot myrobot;
		
	public String name;
	protected int movementID;
	
	public BaseMovement(AbstractDynaBot themyrobot) {
		myrobot = themyrobot;
	
		name = "SITTINGDUCK";
		movementID = DynaBotConstants.SITTINGDUCK;
	}

	/**
	 * Returns this gun's fitness for the current target
	 * or if not enough data are available, its global fitness
	 */
	public double movementFitness() {
		int i = MyUtils.getGameStage(myrobot.getOthers());
		if(myrobot.theMoveManager.totalTicksUsed[movementID][i] == 0) {
			if(myrobot.theMoveManager.totalTicksUsed[movementID][DynaBotConstants.GAMESTAGE_ALLSTAGES] == 0) {
				return myrobot.theMoveManager.priorityModifier[movementID][i];
			} else {
				// we have beeen used enough in other stages to guess
				return (myrobot.theMoveManager.totalDamageTaken[movementID][DynaBotConstants.GAMESTAGE_ALLSTAGES] / myrobot.theMoveManager.totalTicksUsed[movementID][DynaBotConstants.GAMESTAGE_ALLSTAGES]) + myrobot.theMoveManager.priorityModifier[movementID][i];
			}
		} else {
			// we have beeen used enough in this stages to guess
			return (myrobot.theMoveManager.totalDamageTaken[movementID][i] / myrobot.theMoveManager.totalTicksUsed[movementID][i]) + myrobot.theMoveManager.priorityModifier[movementID][i];
		}
	}

	/**
	 * what to do before each battle
	 */
	public void reset() {
	}

	/**
	 * what to do each tick
	 */
	public void doWork() {
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
	}

	public void onDeath(DeathEvent e) {
	}

	public void onHitRobot(HitRobotEvent e) {
	}

	public void onHitWall(HitWallEvent e) {
	}

	public void onPaint(Graphics2D g) {
	}

	public void onRobotDeath(RobotDeathEvent e) {
	}

	public void onWin(WinEvent e) {
	}

	public void enemyFired(double shotPower, String enemyName, Point2D.Double enemyShotFromLoc) {
	}
}
