package ph;
import ph.intelligence.*;
import robocode.*;
import java.awt.geom.*;
import java.util.*;

public abstract class ModularRobot extends TeamRobot {
    
    public static double battlefieldHeight;
    public static double battlefieldWidth;
    
    public Vector otherRobotsNames=new Vector();
    public Vector otherRobotsInfo=new Vector();
    
    public static Vector persistentRobotNames;
    public static Vector persistentRobotInfo;
    
    public Vector movementHistory=new Vector();
    public long movementHistorySize=100;
    public Vector hitHistory=new Vector();
    public long hitHistorySize=100;
    private Vector modules=new Vector();
    
    public Vector enemyBullets=new Vector();
    
    public static int fullLeadHits;
    public double timeSinceReverse = 0;
    
    public void run() {
        if(persistentRobotNames==null) {
            persistentRobotNames=new Vector();
            persistentRobotInfo=new Vector();
            fullLeadHits = 0;
        }
        setInterruptible(false);
        addCustomEvent(new Condition("movementHistory") {
            public boolean test() {
                movementHistory.insertElementAt(new Point2D.Double(getX(),getY()),0);
                while(movementHistory.size()>movementHistorySize)
                    movementHistory.removeElement(movementHistory.lastElement());
                return false;
            }
        }
        );
        battlefieldWidth=getBattleFieldWidth();
        battlefieldHeight=getBattleFieldHeight();
    }
    
    public void addModule(RobotModule m) {
        modules.addElement(m);
    }
    
    public void addModuleAt(RobotModule m, int index) {
        modules.insertElementAt(m,index);
    }
    
    public void removeModule(RobotModule m) {
        modules.removeElement(m);
    }
    
    public void removeModuleAt(int index) {
        modules.removeElementAt(index);
    }
    
    public int modulesCount() {
        return modules.size();
    }
    
    public RobotModule moduleAt(int index) {
        return (RobotModule)modules.elementAt(index);
    }
    
    public void executeModuleAt(int index) {
        RobotModule rm=moduleAt(index);
        rm.execute();
    }
    
    public void executeAllModules() {
        for(int i=0; i<modules.size(); i++) executeModuleAt(i);
    }
    
    public void onScannedRobot(ScannedRobotEvent evt) {
        setInterruptible(false);
        int robotIndex=persistentRobotNames.indexOf(evt.getName());
        if(robotIndex==-1) {
            persistentRobotNames.addElement(evt.getName());
            persistentRobotInfo.addElement(new probotInfo(this,evt.getName()));
            robotIndex=persistentRobotNames.indexOf(evt.getName());
        }
        probotInfo pri=(probotInfo)persistentRobotInfo.elementAt(robotIndex);
        //calculate coordinates
        double scannedBearing = this.getHeading() + evt.getBearing();
        double scannedX = getX() + evt.getDistance() * Math.sin(Math.toRadians(scannedBearing));
        double scannedY = getY() + evt.getDistance() * Math.cos(Math.toRadians(scannedBearing));
        pri.checkHit(scannedX, scannedY, evt.getEnergy(), evt.getTime());
        robotIndex=otherRobotsNames.indexOf(evt.getName());
        if(robotIndex==-1) {
            otherRobotsNames.addElement(evt.getName());
            robotIndex=otherRobotsNames.indexOf(evt.getName());
            robotInfo ri=new robotInfo(evt, scannedX, scannedY);
            ri.setRobot(this);
            otherRobotsInfo.addElement(ri);
        } else {
            robotInfo ri=(robotInfo)otherRobotsInfo.elementAt(robotIndex);
            ri.update(evt,scannedX,scannedY);
        }
    }
    
    public synchronized void onRobotDeath(RobotDeathEvent evt) {
        int robotIndex=otherRobotsNames.indexOf(evt.getName());
        otherRobotsNames.removeElementAt(robotIndex);
        otherRobotsInfo.removeElementAt(robotIndex);
    }
    
    public synchronized void onHitByBullet(HitByBulletEvent evt) {
        if(otherRobotsInfo.size()>0) {
            robotInfo ri=(robotInfo)otherRobotsInfo.firstElement();
            double distance=utils.dist(getX(),getY(),ri.x(),ri.y());
            if (distance > 150) {
                // Adapted from Axe's Musashi: http://robowiki.net/?Musashi
                if (timeSinceReverse > distance / evt.getVelocity()) {
                    fullLeadHits++;
                }
            }
        }
        hitHistory.insertElementAt(new hitInfo(evt,getX(),getY()),0);
        while(hitHistory.size()>hitHistorySize)
            hitHistory.removeElement(hitHistory.lastElement());
    }
    
}
