package alpha;
import robocode.*;
import robocode.util.*;
import java.awt.*;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * BlackIce - a robot by Alpha
 */
public class BlackIce extends AdvancedRobot
{

	private double oldEnemyHeading;
	private double scannedEnergy;
	private boolean enemyDodges;
	private double maxPower;
	private double hitCount;
	private double missCount;
	private int dodging;
	
	private double oldGunHeat;
	private ScannedRobotEvent target;
	private double averageEnemyVelocity;
	private double samples;
	
	private boolean won;
	
	/**
	 * run: BlackIce's default behavior
	 */
	public void run()
	{
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);

		if(getNumRounds() - 1 == getRoundNum())
		{
			setAllColors(Color.WHITE);
		}
		else
		{
			setAllColors(Color.BLACK);
		}
		enemyDodges = false;
		maxPower = 3;
		dodging = 0;
		
		addCustomEvent(new Condition("notHitting")
		{
			public boolean test()
			{
				return (getOthers() == 1 &&
						getEnergy() < 80 &&
						hitCount / (hitCount + missCount) < .1);
			}
		});
		addCustomEvent(new Condition("dodging")
		{
			public boolean test()
			{
				return dodging > 0;
			}
		});
		addCustomEvent(new Condition("true")
		{
			public boolean test()
			{
				return true;
			}
		});

		// Robot main loop
		while(true)
		{
			turnRadarRight(45);
		}
	}

	/**
	 * moveDir: drive a distance at an angle (in radians)
	 */
	public void moveDir(double dist, double ang)
	{
		moveTo(getX() + dist * Math.sin(ang), getY() + dist * Math.cos(ang));
	}

	/**
	 * moveTo: drive to a certain point (within bounds)
	 */
	public void moveTo(double x, double y)
	{
		double buffer = 1.3;
		if(x < getWidth() * buffer)
		{
			x = getWidth() * buffer;
		}
		if(x > getBattleFieldWidth() - getWidth() * buffer)
		{
			x = getBattleFieldWidth() - getWidth() * buffer;
		}
		if(y < getHeight() * buffer)
		{
			y = getHeight() * buffer;
		}
		if(y > getBattleFieldHeight() - getHeight() * buffer)
		{
			y = getBattleFieldHeight() - getHeight() * buffer;
		}
		double targAng = Utils.normalAbsoluteAngle(Math.atan2(x - getX(), y - getY()));
		double dist = Math.sqrt(Math.pow(x - getX(), 2) + Math.pow(y - getY(), 2));
		if(Math.abs(Utils.normalRelativeAngle(targAng - getHeadingRadians())) < Math.PI / 2)
		{
			setTurnRightRadians(Utils.normalRelativeAngle(targAng - getHeadingRadians()));
			setAhead(dist);
		}
		else
		{
			setTurnRightRadians(Utils.normalRelativeAngle(targAng - getHeadingRadians() + Math.PI));
			setBack(dist);
		}

		Graphics2D g = getGraphics();
		g.setColor(Color.CYAN);
		g.drawLine((int)x, (int)y, (int)getX(), (int)getY());
	}

	/**
	 * dodge: Dodge!
	 */
	public void dodge(double dangerDir)
	{
		if(scannedEnergy < 4 && getEnergy() > 32)
		{
			return; // Charge!
		}
		dodging = 9;
		
		double x = Math.sin(dangerDir + Math.PI / 2) * 70;
		double y = Math.cos(dangerDir + Math.PI / 2) * 70;
		boolean right = (getX() + x < 0 || getX() + x > getBattleFieldWidth() ||
						 getY() + y < 0 || getY() + y > getBattleFieldHeight());
		boolean left = !right;
		if(left)
		{
			left = (getX() - x < 0 || getX() - x > getBattleFieldWidth() ||
					getY() - y < 0 || getY() - y > getBattleFieldHeight());
		}
		
		if((Math.random() < .5 || left) && !right)
		{
			moveDir(70 + Math.random() * 15, dangerDir + Math.PI / 2);
		}
		else
		{
			moveDir(70 + Math.random() * 15, dangerDir - Math.PI / 2);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e)
	{
		target = e;
		oldGunHeat = getGunHeat();
		
		double power = Math.min(e.getEnergy() / 4,
						Math.min(e.getDistance() < 250 ? maxPower + .4 : maxPower,
						Math.min(Math.abs(e.getVelocity()) < 1 || e.getDistance() < 250 ? 3 : 2,
								getEnergy()/2)));
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyHeadingChange = enemyHeading - oldEnemyHeading;
		double enemyVelocity = e.getVelocity(); // switched
		oldEnemyHeading = enemyHeading;
		double time = 0;
		double battleFieldHeight = getBattleFieldHeight();
		double battleFieldWidth = getBattleFieldWidth();
		double predX = enemyX;
		double predY = enemyY;
		
		/*if(e.getEnergy() > 0 && movesOnShot && Math.abs(enemyVelocity) < 1)
		{
			enemyVelocity = (Math.random() - .5) * 3;
		}*/
		
		
		enemyVelocity = averageEnemyVelocity;
		
		/*if(enemyDodges)
		{
			if(Math.abs(enemyVelocity) < .5)
			{
				enemyVelocity = (Math.random() - .5) * 11.2;
			}
			else
			{
				enemyVelocity *= 1.35 * (Math.random() - .2);
			}
		}*/
		while((++time) * (20.0 - 3.0 * power) < 
			  Math.sqrt(Math.pow(myX - predX, 2) + Math.pow(myY - predY, 2)))
		{		
			predX += Math.sin(enemyHeading) * enemyVelocity;
			predY += Math.cos(enemyHeading) * enemyVelocity;
			enemyHeading += enemyHeadingChange;
			if(predX < 17.0 || predY < 17.0 ||
			   predX > battleFieldWidth - 17.0 || predY > battleFieldHeight - 17.0)
			{
				predX = Math.min(Math.max(17.0, predX), battleFieldWidth - 17.0);	
				predY = Math.min(Math.max(17.0, predY), battleFieldHeight - 17.0);
				break; // bots can't escape the field!
			}
		}
	
		/*if(e.getEnergy() > 0 && enemyDodges)
		{
			double dist = 40 + Math.random() * 30;
			if(Math.random() < .5)
			{
				predX = enemyX + Math.sin(absoluteBearing + Math.PI / 2) * dist;
				predY = enemyY + Math.cos(absoluteBearing + Math.PI / 2) * dist;
			}
			else
			{
				predX = enemyX - Math.sin(absoluteBearing + Math.PI / 2) * dist;
				predY = enemyY - Math.cos(absoluteBearing + Math.PI / 2) * dist;
			}
		}*/
	
		double predAngle = Utils.normalAbsoluteAngle(Math.atan2(predX - getX(), predY - getY()));
		setTurnGunRightRadians(Utils.normalRelativeAngle(predAngle - getGunHeadingRadians()));
		Graphics2D g = getGraphics();
		if(getGunHeat() == 0 && getEnergy() > 1)
		{
			if(enemyDodges)
			{
				setBulletColor(Color.GREEN);
			}
			else
			{
				setBulletColor(Color.RED);
			}
			fire(power);
			if(getOthers() < 3 && maxPower == 3)
			{
				maxPower = 2.5;
			}
			else
			{
				maxPower = 3;
			}
			//setBulletColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
			g.setColor(Color.RED);
			g.fillOval((int)(predX - 10), (int)(predY - 10), 20, 20);
			g.drawLine((int)predX, (int)predY, (int)myX, (int)myY);
		}
		g.setColor(Color.GREEN);
		g.drawOval((int) (predX - 10), (int) (predY - 10), 20, 20);
		double ang = Math.atan2(predX - enemyX, predY - enemyY);
		double dist = Math.max(0, Math.sqrt(Math.pow(predX - enemyX, 2) + Math.pow(predY - enemyY, 2)) - 10);
		g.drawLine((int)(dist * Math.sin(ang) + enemyX), (int)(dist * Math.cos(ang) + enemyY), (int)enemyX, (int)enemyY);
	
		if(e.getDistance() < 185)
		{
			if(e.getEnergy() < 5)
			{
				g.setColor(new Color(0, 255, 0, 30)); // green
			}
			else
			{
				g.setColor(new Color(255, 0, 0, 30)); // red
			}
			g.fillOval((int)(enemyX - 135), (int)(enemyY - 135), 270, 270);
			if(e.getDistance() < 100)
			{
				g.fillOval((int)(enemyX - 70), (int)(enemyY - 70), 140, 140);
			}
		}

		double bearingFromRadar = Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians());
		setTurnRadarRightRadians(bearingFromRadar * 1.3);
		
		if(dodging < 1 && e.getDistance() < 200)
		{
			dodge(absoluteBearing);
		}
		
		if(scannedEnergy - e.getEnergy() <= 3 && scannedEnergy - e.getEnergy() >= .1)
		{
			g.setColor(Color.YELLOW);
			g.drawOval((int)(enemyX - 50), (int)(enemyY - 50), 100, 100);
			g.drawLine((int)(50 * Math.sin(absoluteBearing + Math.PI) + enemyX), (int)(50 * Math.cos(absoluteBearing + Math.PI) + enemyY), (int)enemyX, (int)enemyY);
			dodge(absoluteBearing);
		}
		scannedEnergy = e.getEnergy();
		
		if(dodging < 1 && e.getDistance() > ((scannedEnergy < 5 && getEnergy() > 32) ? 0 : 250) && getEnergy() > 20)
		{
			moveTo(enemyX, enemyY);
		}
	}

	/**
	 * onHitRobot: What to do when you hit a robot
	 */
	public void onHitRobot(HitRobotEvent e)
	{
		dodge(e.getBearingRadians() + getHeadingRadians());
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e)
	{
		dodge(e.getBearingRadians() + getHeadingRadians());
	}

	/**
	 * onBulletHit: What to do when you hit someone
	 */
	public void onBulletHit(BulletHitEvent e)
	{
		if(hitCount + missCount > 20)
		{
			missCount--;
			missCount = Math.max(0, missCount);
		}
		else
		{
			hitCount++;
		}
	}

	/**
	 * onBulletMissed: What to do when you hit someone
	 */
	public void onBulletMissed(BulletMissedEvent e)
	{
		if(hitCount + missCount > 20)
		{
			hitCount--;
			hitCount = Math.max(0, hitCount);
		}
		else
		{
			missCount++;
		}
	}

	/**
	 * onCustomEvent: targeting type; dodge counter
	 */
	public void onCustomEvent(CustomEvent e)
	{
		if(e.getCondition().getName().equals("notHitting"))
		{
			enemyDodges = true;
		}
		if(e.getCondition().getName().equals("dodging"))
		{
			dodging--;
		}
		if(e.getCondition().getName().equals("true"))
		{
			if(won && getGunHeat() == 0)
			{
				fire(.3);
			}
			if(enemyDodges)
			{
				setGunColor(new Color(0, (int)(255 * getGunHeat() / 1.6), 0));
			}
			else
			{
				setGunColor(new Color((int)(255 * getGunHeat() / 1.6) % 256, 0, 0));
			}
			
			if(oldGunHeat > .1 || samples > 0)
			{
				samples++;
				averageEnemyVelocity = averageEnemyVelocity * (samples - 1) / samples + target.getVelocity() / samples;
				if(samples > 250 && enemyDodges)
				{
					samples -= 50;
				}
				else if(samples > 14 && !enemyDodges)
				{
					samples -= 2;
				}
			}
		}
	}

	public void onRobotDeath(RobotDeathEvent e)
	{
		if(getOthers() == 1)
		{
			setRadarColor(Color.GREEN);
		}
	}

	public void onWin(WinEvent e)
	{
		won = true;
		moveTo(getBattleFieldWidth() / 2, getBattleFieldHeight() / 2);
		setBulletColor(Color.CYAN);
		setRadarColor(Color.CYAN);
		setTurnGunLeft(1000);
	}

}
