package vuen.cfCake;
import vuen.Cake;
import robocode.*;

public class cRadWide {
	private Cake oRobot = null;
	private cRadControl oRadControl = null;
	private cComControl oComControl = null;
	
	private int mScannedBots = 0;
	
	double mDirection = 1;
	
	public cRadWide(Cake pRobot, cRadControl pRadControl, cComControl pComControl) {
		oRobot = pRobot;
		oRadControl = pRadControl;
		oComControl = pComControl;
	}
	
	public void doInit() {
		oRobot.setTurnRadarRight(10000);
	}
	
	public void doUnInit() {
	}
	
	public void doTurn() {
		oRobot.setTurnRadarRight(mDirection * 100000);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		mScannedBots++;
		if (oRobot.isTeammate(e.getName())) return;
		oComControl.doComScannedRobot(e, true);
		//if (oComControl.mComEnemy.mTotalNames < oRobot.getOthers()) return;
		if (mScannedBots < oRobot.getOthers()) return;
		int i = 0;
		for (i = 0; i < oComControl.mComEnemy.mTotalNames; i++) {
			if (oComControl.isEnemyValid(i) && oRobot.normalRelativeAngle(oComControl.mComEnemy.mEnemyDirection[i] - oRobot.getRadarHeading()) * mDirection > 0) i = oComControl.mComEnemy.mTotalNames + 1;
		}
		if (i == oComControl.mComEnemy.mTotalNames) {
			mDirection *= -1;
			oRobot.setTurnRadarRight(mDirection * 100000);
			mScannedBots = 0;
		}
	}
}