package shinh;

import robocode.*;

import java.util.Vector;
import java.awt.geom.Point2D;

public class MoveRevolver {
	private Entangled ent;
	private Vector movesOne_;
	private Vector movesMelee_;
	public Move move = null;

	private MoveJigglingEdge jigglingEdge_;
	private int notJiggle_ = 0;

	private Move ram_ = new MoveRam();

	private int revolveTurn_;
	private double lastEnergy_;

	public void addOne(Move p) {
		movesOne_.add(p);
	}
	public void addMelee(Move p) {
		movesMelee_.add(p);
	}
	public void addAll(Move p) {
		addOne(p);
		addMelee(p);
	}

	public void init() {
		ent = Entangled.me;

		for (int i = 0; i < movesOne_.size(); i++) {
			((Move)movesOne_.get(i)).init();
		}
		for (int i = 0; i < movesMelee_.size(); i++) {
			((Move)movesMelee_.get(i)).init();
		}

		ram_.init();
		jigglingEdge_.init();

		revolveTurn_ = 0;
		lastEnergy_ = ent.getEnergy();

		revolve();
	}

	public MoveRevolver() {
		ent = Entangled.me;

		jigglingEdge_ = new MoveJigglingEdge();

		movesOne_ = new Vector();
		movesMelee_ = new Vector();

		//addOne(new MoveSpin());
		addOne(new MoveAntiGrav3());
		addOne(new MoveReflection());
		addOne(new MoveRollReflection());
		addMelee(new MoveAntiGrav4());

		init();

		if (ent.getOthers() == 1) setMove((Move)movesOne_.get(0));
	}

	public void setMove(Move m) {
		if (move != null) move.unuse();
		move = m;
		move.use();
		revolveTurn_ = 0;
		ent.out.println(move.name() + ": " + move.evaluation);
	}

	public Vector moves() {
		if (Entangled.me.getOthers() <= 1) return movesOne_;
		else return movesMelee_;
	}

	public void revolve() {
		if (move != null) {
			move.evaluation += ent.getEnergy() - lastEnergy_;
			move.damages += ent.getEnergy() - lastEnergy_;
		}
		lastEnergy_ = ent.getEnergy();

		int all = 0;
		int normalAll = 100 * getValidSize();
		for (int i = 0; i < moves().size(); i++) {
			Move m = (Move)moves().get(i);
			if (!m.isValid()) continue;
			if (m.evaluation < 10) m.evaluation = 10;
			all += m.evaluation;
		}
		for (int i = 0; i < moves().size(); i++) {
			Move m = (Move)moves().get(i);
			if (!m.isValid()) continue;
			m.evaluation = m.evaluation * normalAll / all;
		}
		int rand = Util.rnd(normalAll);
		for (int i = 0; i < moves().size(); i++) {
			Move m = (Move)moves().get(i);
			if (!m.isValid()) continue;
			rand -= m.evaluation;
			if (rand <= 0) {
				setMove(m);
				break;
			}
		}

		revolveTurn_ = 0;
	}

	public void revolveAnother() {
		move.evaluation += ent.getEnergy() - lastEnergy_;
		move.damages += ent.getEnergy() - lastEnergy_;
		lastEnergy_ = ent.getEnergy();

		int all = 0;
		for (int i = 0; i < moves().size(); i++) {
			Move m = (Move)moves().get(i);

			if (!m.isValid()) continue;

			if (m == move) continue;

			if (m.evaluation < 1) m.evaluation = 1;
			all += m.evaluation;
		}
		if (all == 0) return;
		int rand = Util.rnd(all);
		for (int i = 0; i < moves().size(); i++) {
			Move m = (Move)moves().get(i);

			if (!m.isValid()) continue;

			if (m == move) continue;

			rand -= m.evaluation;
			if (rand <= 0) {
				setMove(m);
				break;
			}
		}

		revolveTurn_ = 0;
	}

	private void changeJiggleEdge() {
		if (notJiggle_ <= 0 &&
			move != jigglingEdge_ && jigglingEdge_.isValid())
		{
			setMove(jigglingEdge_);
		}
	}

	public int getValidSize() {
		int s = 0;
		for (int i = 0; i < moves().size(); i++) {
			if (((Move)moves().get(i)).isValid()) s++;
		}
		return s;
	}

	public void update() {
		notJiggle_--;

		if (ent.target != null && ent.bmgr.isEmpty() &&
			ent.target.energy <= 0.3)
		{
			ent.fire.goTease();
			ram_.go();
			return;
		}

		revolveTurn_++;

		if (revolveTurn_ > Const.MOVE_REVOLVER_TURN) {
			revolve();
		}

		else if (!move.isValid()) {
			revolveAnother();
		}

		else if (move != jigglingEdge_) {
			if (ent.getEnergy() - lastEnergy_ < -50) {
				revolveAnother();
			}

			else if (ent.getEnergy() < 19 && move.evaluation < 50) {
				revolveAnother();
			}
		}

		if (ent.getOthers() > 1) {
			changeJiggleEdge();
		}

		move.go();
	}

	public String getStateString() {
		String ret = "one: ";
		for (int i = 0; i < movesOne_.size(); i++) {
			Move m = (Move)movesOne_.get(i);
			ret +=
				m.name() + ":" +
				(int)m.evaluation+
				"("+m.damages+"/"+m.usedTime+"="+m.getAverageDamage()+")" +
				", \n";
		}
		ret += "melee: ";
		for (int i = 0; i < movesMelee_.size(); i++) {
			Move m = (Move)movesMelee_.get(i);
			ret +=
				m.name() + ":" +
				(int)m.evaluation+"("+m.getAverageDamage()+")" + ", ";
		}

		return ret;
	}

	public void notJiggle() {
		notJiggle_ = 30;
	}

	public void noticeHitRobot() {
/*
		if (move == jigglingEdge_) {
			notJiggle();
			revolveAnother();
		}
*/
	}
	public void noticeHitWall() {
		if (move == jigglingEdge_) {
			notJiggle();
		}
		revolveAnother();
	}

}
