package d414.nano;

import robocode.*;
import robocode.util.Utils;

import java.awt.Color;

public class Quantum extends AdvancedRobot {
    // ---------------------------------------------------------------------------------------------
    // Tuning Knobs
    // ---------------------------------------------------------------------------------------------
    static final double WALL_FORCE = 1.0;
    static final double AGRAV_DECAY = 0.9;
    static final double AHEAD_AMOUNT = 120.0;

    static final double AIM_START = 10.0;
    static final double AIM_FACTOR = 1.008;
    static final double AIM_TOLERANCE = 18.0;
    static final double BULLET_POWER = 2.49999;
    static final double ENERGY_FACTOR = 7.0;
    static final double RADAR_LOCK_THRESHOLD = 1.0;

    // ---------------------------------------------------------------------------------------------
    // Constants
    // ---------------------------------------------------------------------------------------------
    static final double BATTLEFIELD_SIZE = 1000.0;

    // ---------------------------------------------------------------------------------------------
    // Globals
    // ---------------------------------------------------------------------------------------------
    static String targetName;
    static double targetDistance;
    static double xForce;
    static double yForce;

    @Override
    public void run() {
        //setAllColors(Color.cyan);
        setTurnRadarRight(targetDistance = Double.POSITIVE_INFINITY);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent r1e) {
        targetDistance = Double.POSITIVE_INFINITY;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent r1e) {
        double r1d;
        double r3d;

        setAdjustGunForRobotTurn(true);
        setTurnLeftRadians(Utils.normalRelativeAngle(
                    (r3d = getHeadingRadians())
                    - Math.atan2(
                        (xForce = xForce * AGRAV_DECAY
                         - Math.sin(r3d = (r3d += r1e.getBearingRadians())
                             + (Math.sin(r1e.getHeadingRadians() - r3d)
                                 * r1e.getVelocity()
                                 / (AIM_START + Math.pow(AIM_FACTOR, r1d = r1e.getDistance()))
                               )
                             ) / r1d
                        )
                        + calcWallForce(getX())
                        , 
                        (yForce = yForce * AGRAV_DECAY - Math.cos(r3d) / r1d)
                        + calcWallForce(getY())
                        )
                    ));
        setBack(Math.abs(getTurnRemaining()) - AHEAD_AMOUNT);

        if (r1e.getName() == targetName || r1d < targetDistance) {
            targetName = r1e.getName();
            targetDistance = r1d;

            setTurnRadarRight((getGunHeat() - RADAR_LOCK_THRESHOLD) * getRadarTurnRemaining());
            setTurnGunLeftRadians(Utils.normalRelativeAngle(getGunHeadingRadians() - r3d));

            if (Math.abs(getGunTurnRemainingRadians()) < (AIM_TOLERANCE / r1d)) {
                setFire(Math.min(getEnergy() / ENERGY_FACTOR, BULLET_POWER));
            }
        }
    }

    public static double calcWallForce(double r0d) {
        return (WALL_FORCE / r0d) - (WALL_FORCE / (BATTLEFIELD_SIZE - r0d));
    }
}
