package kawigi.sbf.utils;
import robocode.*;
/**
 * MovementSimulation
 */
public class MovementSimulation implements Moveable
{
	double distanceRemaining, acceleration, moveDirection, angleToTurn, lastHeading, heading, x, y;
	double turnRate, velocity, lastX, lastY, maxVelocity;
	boolean slowingDown;
	
	public MovementSimulation(TeamRobot robot)
	{
		distanceRemaining = robot.getDistanceRemaining();
		angleToTurn = robot.getTurnRemainingRadians();
		heading = robot.getHeadingRadians();
		x = robot.getX();
		y = robot.getY();
		velocity = robot.getVelocity();
		maxVelocity = 8;
	}
	
	public void setAhead(double distance)
	{
		distanceRemaining = distance;
		acceleration = 0;
		if (distance == 0)
			moveDirection = 0;
		else if (distance > 0)
			moveDirection = 1;
		else
			moveDirection = -1;
		slowingDown = false;
	}
	
	public void setTurnRightRadians(double radians)
	{
		angleToTurn = 1.0 * radians;
	}

	public void execute()
	{
		lastHeading = heading;
		
		boolean normalizeHeading = true;
		turnRate = Math.min(Math.toRadians(10.0), (.4 + .6 * (1 - (Math.abs(velocity) / 8))) * 8);
		
		if (angleToTurn > 0)
		{
			if (angleToTurn < turnRate)
			{
				heading += angleToTurn;
				angleToTurn = 0;
			}
			else
			{
				heading += turnRate;
				angleToTurn -= turnRate;
			}
		}
		else if (angleToTurn < 0)
		{
			if (angleToTurn > -turnRate)
			{
				heading += angleToTurn;
				angleToTurn = 0;
			}
			else
			{
		    	heading -= turnRate;
				angleToTurn += turnRate;
			}
		}
		else
			normalizeHeading = false;
		
		if (normalizeHeading)
		{
			if (angleToTurn == 0)
			{
				heading = normalNearAbsoluteAngle(heading);
			}
			else
				heading = robocode.util.Utils.normalAbsoluteAngle(heading);
		}
		
		if (distanceRemaining == 0 && velocity == 0)
			return;
		
		lastX = x;
		lastY = y;
		
		if (!slowingDown)
		{
			if (moveDirection == 0)
			{
				slowingDown = true;
				
				if (velocity > 0)
					moveDirection = 1;
				else if (velocity < 0)
					moveDirection = -1;
				else
					moveDirection = 0;
			}
		}
		
		double desiredDistanceRemaining = distanceRemaining;
		if (slowingDown)
		{
			if (moveDirection == 1 && distanceRemaining < 0)
				desiredDistanceRemaining = 0;
			else if (moveDirection == -1 && distanceRemaining > 1)
				desiredDistanceRemaining = 0;
		}
		double slowDownVelocity = (int)(1 * (Math.sqrt(4 * Math.abs(desiredDistanceRemaining) + 1) - 1));
		if (moveDirection == -1)
			slowDownVelocity = -slowDownVelocity;
		
		if (!slowingDown)
		{
			if (moveDirection == 1)
			{
				if (velocity < 0)
					acceleration = 2;
				else
					acceleration = 1;
				
				if (velocity + acceleration > slowDownVelocity)
				{
					slowingDown = true;
				}
			}
			else if (moveDirection == -1)
			{
				if (velocity > 0)
					acceleration = -2;
				else
					acceleration = -1;
				
				if (velocity + acceleration < slowDownVelocity)
				{
					slowingDown = true;
				}
			}
		}
		
		if (slowingDown)
		{
			if (distanceRemaining != 0 && Math.abs(velocity) <= 2 && Math.abs(distanceRemaining) <= 2)
			{
				slowDownVelocity = distanceRemaining;
			}
			
			double perfectAccel = slowDownVelocity - velocity;
			if (perfectAccel > 2)
				perfectAccel = 2;
			else if (perfectAccel < -2)
				perfectAccel = -2;
			
			acceleration = perfectAccel;
		}
		
		if (velocity > maxVelocity || velocity < -maxVelocity)
			acceleration = 0;
		
		velocity += acceleration;
		if (velocity > maxVelocity)
			velocity -= Math.min(2,velocity-maxVelocity);
		if (velocity < -maxVelocity)
			velocity += Math.min(2,-velocity-maxVelocity);
		double dx = velocity * Math.sin(heading);
		double dy = velocity * Math.cos(heading);
		x += dx;
		y += dy;
		
		boolean updateBounds = false;
		if (dx != 0 || dy != 0)
			updateBounds = true;
		
		if (slowingDown && velocity == 0)
		{
			distanceRemaining = 0;
			moveDirection = 0;
			slowingDown = false;
			acceleration = 0;
		}
		
		distanceRemaining -= velocity;
	}

	public void setMaxVelocity(double newMaxVelocity)
	{
		maxVelocity = Math.min(Math.abs(newMaxVelocity),8);
	}

	public double getX()
	{
		return x;
	}

	public double getY()
	{
		return y;
	}

	public double getHeadingRadians()
	{
		return heading;
	}

	private static double twoPi = 2 * Math.PI;
	private static double threePiOverTwo = 3 * Math.PI / 2;
	private static double piOverTwo = Math.PI / 2;
		
	public static double normalNearAbsoluteAngle(double angle)
	{
		double fixedAngle = robocode.util.Utils.normalAbsoluteAngle(angle);
		if (isNear(fixedAngle,0))
			fixedAngle = 0;
		else if (isNear(fixedAngle,piOverTwo))
			fixedAngle = piOverTwo;
		else if (isNear(fixedAngle,Math.PI))
			fixedAngle = Math.PI;
		else if (isNear(fixedAngle,threePiOverTwo))
			fixedAngle = threePiOverTwo;
		else if (isNear(fixedAngle,twoPi))
			fixedAngle = 0;
		
		return fixedAngle;
	}
	
	private static boolean isNear(double angle1, double angle2)
	{
		if (Math.abs(angle1 - angle2) < .00001)
			return true;
		return false;
	}
}
