/*
 * Decompiled with CFR 0.152.
 */
package pkbots;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class BoyTDSurfer
extends AdvancedRobot {
    public static double alpha = 0.99;
    public static double gamma = 0.9;
    public static int BINS = 151;
    public static double[] _surfStats = new double[BINS];
    public static double[] _prev_surfStats = new double[BINS];
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    public Point2D.Double _lastGoToPoint;
    public double direction = 1.0;
    public double prev_surfStat = 0.0;
    public double prev_guessfactor = 0.0;
    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
    public static double _oppEnergy = 100.0;
    public static Rectangle2D.Double _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    public static double WALL_STICK = 160.0;
    static final double BEST_DISTANCE = 525.0;
    static boolean flat = false;
    static double circleDir = 1.0;
    static double enemyFirePower;
    static double enemyEnergy;
    static double enemyDistance;
    static double lastVChangeTime;
    static int enemyVelocity;
    static Point2D.Double enemyLocation;
    static final int GF_ZERO = 15;
    static final int GF_ONE = 30;
    static double[][][][][] guessFactors;
    static double[] prev_guessFactors;
    static String name;
    double count_enemy_wave = 0.0;
    double dodge_unsuccessful = 0.0;
    double count_shots = 0.0;
    double shot_successful = 0.0;
    static String shot_stat;
    static String dodge_stat;

    static {
        guessFactors = new double[6][3][2][8][31];
        prev_guessFactors = new double[31];
        shot_stat = "";
        dodge_stat = "";
    }

    public void run() {
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
        this.setBodyColor(Color.red);
        this.setGunColor(Color.black);
        this.setRadarColor(Color.yellow);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        double d2;
        if (name == null) {
            name = e.getName();
            try {
                ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(this.getDataFile(name))));
                _surfStats = (double[])in.readObject();
                guessFactors = (double[][][][][])in.readObject();
                in.close();
            }
            catch (Exception exception) {
                _surfStats = new double[BINS];
                guessFactors = new double[6][3][2][8][31];
            }
        }
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        this._surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = BoyTDSurfer.bulletVelocity(bulletPower);
            ew.distanceTraveled = BoyTDSurfer.bulletVelocity(bulletPower);
            ew.direction = (Integer)this._surfDirections.get(2);
            ew.directAngle = (Double)this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            this._enemyWaves.add(ew);
            this.count_enemy_wave += 1.0;
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = BoyTDSurfer.project(this._myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        Point2D.Double robotLocation = new Point2D.Double(this.getX(), this.getY());
        double enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyDistance = e.getDistance();
        enemyLocation = BoyTDSurfer.projectMotion(robotLocation, enemyAbsoluteBearing, enemyDistance);
        enemyEnergy -= e.getEnergy();
        if (d2 >= 0.1 && enemyEnergy <= 3.0) {
            enemyFirePower = enemyEnergy;
        }
        enemyEnergy = e.getEnergy();
        MicroWave w = new MicroWave();
        this.addCustomEvent(w);
        double theta = e.getVelocity();
        w.bearingDirection = d * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing) > 0.0 ? 0.04666666666666666 : -0.04666666666666666;
        Rectangle2D.Double BF = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        double d3 = lastVChangeTime;
        lastVChangeTime = d3 + 1.0;
        int bestGF = Math.min(4, (int)Math.sqrt(224.0 * d3 / enemyDistance)) + 1;
        int n = enemyVelocity;
        enemyVelocity = (int)Math.abs(theta);
        if (n > enemyVelocity) {
            lastVChangeTime = 0.0;
            bestGF = 0;
        }
        w.firePosition = robotLocation;
        w.enemyAbsBearing = enemyAbsoluteBearing;
        w.waveGuessFactors = guessFactors[bestGF][enemyVelocity / 3][BF.contains(BoyTDSurfer.projectMotion(robotLocation, enemyAbsoluteBearing + w.bearingDirection * 15.0, enemyDistance)) ? 0 : 1][(int)enemyDistance / 140];
        bestGF = 15;
        int gf = 30;
        while (gf >= 0 && e.getEnergy() > 0.0) {
            if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF]) {
                bestGF = gf;
            }
            --gf;
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + w.bearingDirection * (double)(bestGF - 15))));
        double power = 2.0 - Math.max(0.0, (30.0 - this.getEnergy()) / 16.0);
        this.setFire(power);
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getRadarHeadingRadians())) * 2.0);
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = BoyTDSurfer.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / BoyTDSurfer.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)BoyTDSurfer.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = BoyTDSurfer.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            _surfStats[n] = _surfStats[n] + 0.9 * (1.0 / (Math.pow(index - x, 2.0) + 1.0) - _surfStats[x]);
            ++x;
        }
        this.prev_surfStat = _surfStats[index];
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.abs(BoyTDSurfer.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
            this.dodge_unsuccessful += 1.0;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this.shot_successful += 1.0;
        this.count_shots += 1.0;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.count_shots += 1.0;
    }

    public ArrayList predictPositions(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        ArrayList<Point2D.Double> traveledPoints = new ArrayList<Point2D.Double>();
        int counter = 0;
        boolean intercepted = false;
        do {
            double distance = predictedPosition.distance(surfWave.fireLocation);
            double offset = 0.5707963267948966 + distance / 400.0;
            double moveAngle = this.wallSmoothing(predictedPosition, BoyTDSurfer.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * offset, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + BoyTDSurfer.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = BoyTDSurfer.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = BoyTDSurfer.project(predictedPosition, predictedHeading, predictedVelocity);
            traveledPoints.add(predictedPosition);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) - 20.0 < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        if (traveledPoints.size() > 1) {
            traveledPoints.remove(traveledPoints.size() - 1);
        }
        return traveledPoints;
    }

    public double checkDanger(EnemyWave surfWave, Point2D.Double position) {
        int index = BoyTDSurfer.getFactorIndex(surfWave, position);
        double distance = position.distance(surfWave.fireLocation);
        return _surfStats[index] / distance;
    }

    public Point2D.Double getBestPoint(EnemyWave surfWave) {
        if (surfWave.safePoints == null) {
            int minDangerIndex;
            ArrayList bestPoints;
            double thisDanger;
            ArrayList forwardPoints = this.predictPositions(surfWave, 1);
            ArrayList reversePoints = this.predictPositions(surfWave, -1);
            int FminDangerIndex = 0;
            int RminDangerIndex = 0;
            double FminDanger = Double.POSITIVE_INFINITY;
            double RminDanger = Double.POSITIVE_INFINITY;
            int i = 0;
            int k = forwardPoints.size();
            while (i < k) {
                thisDanger = this.checkDanger(surfWave, (Point2D.Double)forwardPoints.get(i));
                if (thisDanger <= FminDanger) {
                    FminDangerIndex = i;
                    FminDanger = thisDanger;
                }
                ++i;
            }
            i = 0;
            k = reversePoints.size();
            while (i < k) {
                thisDanger = this.checkDanger(surfWave, (Point2D.Double)reversePoints.get(i));
                if (thisDanger <= RminDanger) {
                    RminDangerIndex = i;
                    RminDanger = thisDanger;
                }
                ++i;
            }
            if (FminDanger < RminDanger) {
                bestPoints = forwardPoints;
                minDangerIndex = FminDangerIndex;
            } else {
                bestPoints = reversePoints;
                minDangerIndex = RminDangerIndex;
            }
            Point2D.Double bestPoint = (Point2D.Double)bestPoints.get(minDangerIndex);
            while (bestPoints.indexOf(bestPoint) != -1) {
                bestPoints.remove(bestPoints.size() - 1);
            }
            bestPoints.add(bestPoint);
            surfWave.safePoints = bestPoints;
            bestPoints.add(0, new Point2D.Double(this.getX(), this.getY()));
        } else if (surfWave.safePoints.size() > 1) {
            surfWave.safePoints.remove(0);
        }
        if (surfWave.safePoints.size() >= 1) {
            int i = 0;
            int k = surfWave.safePoints.size();
            while (i < k) {
                Point2D.Double goToPoint = (Point2D.Double)surfWave.safePoints.get(i);
                if (goToPoint.distanceSq(this._myLocation) > 440.00000000000006) {
                    return goToPoint;
                }
                ++i;
            }
            return (Point2D.Double)surfWave.safePoints.get(surfWave.safePoints.size() - 1);
        }
        return null;
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        double distance = this._enemyLocation.distance(this._myLocation);
        if (surfWave == null || distance < 50.0) {
            double v2;
            double absBearing = BoyTDSurfer.absoluteBearing(this._myLocation, this._enemyLocation);
            double headingRadians = this.getHeadingRadians();
            double stick = 160.0;
            double offset = 2.5707963267948966 - distance / 400.0;
            while (!_fieldRect.contains(BoyTDSurfer.project(this._myLocation, v2 = absBearing + this.direction * (offset -= 0.02), stick))) {
            }
            if (offset < 1.0471975511965976) {
                this.direction = -this.direction;
            }
            this.setAhead(50.0 * Math.cos(v2 - headingRadians));
            this.setTurnRightRadians(Math.tan(v2 - headingRadians));
        } else {
            this.goTo(this.getBestPoint(surfWave));
        }
    }

    private void goTo(Point2D.Double destination) {
        if (destination == null) {
            if (this._lastGoToPoint != null) {
                destination = this._lastGoToPoint;
            } else {
                return;
            }
        }
        this._lastGoToPoint = destination;
        Point2D.Double location = new Point2D.Double(this.getX(), this.getY());
        double distance = location.distance(destination);
        double angle = Utils.normalRelativeAngle((double)(BoyTDSurfer.absoluteBearing(location, destination) - this.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            distance = -distance;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.setTurnRightRadians(angle * (double)Math.signum(Math.abs((int)distance)));
        this.setAhead(distance);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(BoyTDSurfer.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.red);
        int i = 0;
        while (i < this._enemyWaves.size()) {
            EnemyWave w = (EnemyWave)this._enemyWaves.get(i);
            int radius = (int)(w.distanceTraveled + w.bulletVelocity);
            Point2D.Double center = w.fireLocation;
            if ((double)(radius - 40) < center.distance(this._myLocation)) {
                g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
            }
            ++i;
        }
    }

    private static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance) {
        return new Point2D.Double(loc.x + distance * Math.sin(heading), loc.y + distance * Math.cos(heading));
    }

    public void onDeath(DeathEvent e) {
        flat = flat || this.getRoundNum() < 5;
    }

    public void onWin(WinEvent e) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(name))));
            out.writeObject(_surfStats);
            out.writeObject(guessFactors);
            out.close();
        }
        catch (IOException iOException) {}
    }

    public void onBattleEnded(BattleEndedEvent e) {
    }

    public void onRoundEnded(RoundEndedEvent e) {
        if ((this.getRoundNum() + 1) % 2 == 0) {
            PrintStream w;
            block18: {
                double shot_rate = this.shot_successful / this.count_shots;
                double dodge_rate = 1.0 - this.dodge_unsuccessful / this.count_enemy_wave;
                shot_stat = this.getRoundNum() + 1 + ";" + shot_rate + ";";
                dodge_stat = this.getRoundNum() + 1 + ";" + dodge_rate + ";";
                this.shot_successful = 0.0;
                this.count_shots = 0.0;
                this.dodge_unsuccessful = 0.0;
                this.count_enemy_wave = 0.0;
                w = null;
                try {
                    try {
                        w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile("shot_stat.dat").getPath(), true));
                        w.println(shot_stat);
                        if (w.checkError()) {
                            this.out.println("I could not write the shot_stat!");
                        }
                    }
                    catch (IOException eIO) {
                        this.out.println("IOException trying to write: ");
                        eIO.printStackTrace(this.out);
                        if (w != null) {
                            w.close();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (w != null) {
                        w.close();
                    }
                    throw throwable;
                }
                if (w != null) {
                    w.close();
                }
            }
            try {
                try {
                    w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile("dodge_stat.dat").getPath(), true));
                    w.println(dodge_stat);
                    if (w.checkError()) {
                        this.out.println("I could not write the dodge_stat!");
                    }
                }
                catch (IOException eIO) {
                    this.out.println("IOException trying to write: ");
                    eIO.printStackTrace(this.out);
                    if (w != null) {
                        w.close();
                    }
                }
            }
            finally {
                if (w != null) {
                    w.close();
                }
            }
        }
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
        ArrayList safePoints;
    }

    class MicroWave
    extends Condition {
        Point2D.Double firePosition;
        double[] waveGuessFactors;
        double enemyAbsBearing;
        double distance;
        double bearingDirection;

        MicroWave() {
        }

        public boolean test() {
            double d;
            this.distance += 14.0;
            if (enemyLocation.distance(this.firePosition) <= d) {
                try {
                    int index = (int)Math.round(Utils.normalRelativeAngle((double)(BoyTDSurfer.absoluteBearing(this.firePosition, enemyLocation) - this.enemyAbsBearing)) / this.bearingDirection + 15.0);
                    int x = 0;
                    while (x < 31) {
                        int n = x;
                        this.waveGuessFactors[n] = this.waveGuessFactors[n] + alpha * (1.0 / (Math.pow(index - x, 2.0) + 1.0) - this.waveGuessFactors[x]);
                        ++x;
                    }
                    BoyTDSurfer.this.prev_guessfactor = this.waveGuessFactors[index];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                BoyTDSurfer.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

