/*
 * Decompiled with CFR 0.152.
 */
package ej;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class ChocolateBar
extends AdvancedRobot {
    static final double BEST_DISTANCE = 525.0;
    static boolean flat = true;
    static double bearingDirection = 1.0;
    static double lastLatVel;
    static double lastVelocity;
    static double lastReverseTime;
    static double circleDir;
    static double enemyFirePower;
    static double enemyEnergy;
    static double enemyDistance;
    static double lastVChangeTime;
    static double enemyLatVel;
    static double enemyVelocity;
    static double enemyFireTime;
    static double numBadHits;
    static Point2D.Double enemyLocation;
    static final int GF_ZERO = 15;
    static final int GF_ONE = 30;
    static String enemyName;
    static int[][][][][][] guessFactors;
    static double numWins;

    public void run() {
        this.setColors(Color.black, Color.white, Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Point2D.Double newDestination;
        double d;
        if (enemyName == null) {
            enemyName = e.getName();
            this.restoreData();
        }
        Point2D.Double robotLocation = new Point2D.Double(this.getX(), this.getY());
        double enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = ChocolateBar.projectMotion(robotLocation, enemyAbsoluteBearing, enemyDistance);
        enemyEnergy -= e.getEnergy();
        if (d >= 0.1 && enemyEnergy <= 3.0) {
            enemyFirePower = enemyEnergy;
            enemyFireTime = this.getTime();
        }
        enemyEnergy = e.getEnergy();
        Rectangle2D.Double BF = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        double distDelta = 1.5907963267948966 + (enemyDistance > 525.0 ? -0.1 : 0.5);
        while (!BF.contains(newDestination = ChocolateBar.projectMotion(robotLocation, enemyAbsoluteBearing + circleDir * (distDelta -= 0.02), 170.0))) {
        }
        double theta = 0.5952 * (20.0 - 3.0 * enemyFirePower) / enemyDistance;
        if (flat && Math.random() > Math.pow(theta, theta) || distDelta < 0.6283185307179586 || distDelta < 0.8975979010256552 && enemyDistance < 400.0) {
            circleDir = -circleDir;
            lastReverseTime = this.getTime();
        }
        theta = ChocolateBar.absoluteBearing(robotLocation, newDestination) - this.getHeadingRadians();
        this.setAhead(Math.cos(theta) * 100.0);
        this.setTurnRightRadians(Math.tan(theta));
        MicroWave w = new MicroWave();
        lastLatVel = enemyLatVel;
        lastVelocity = enemyVelocity;
        enemyVelocity = e.getVelocity();
        enemyLatVel = enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);
        int distanceIndex = (int)enemyDistance / 140;
        double bulletPower = distanceIndex == 0 ? 3.0 : 2.0;
        theta = Math.min(this.getEnergy() / 4.0, Math.min(enemyEnergy / 4.0, bulletPower));
        if (theta == bulletPower) {
            this.addCustomEvent(w);
        }
        bulletPower = theta;
        w.bulletVelocity = 20.0 - 3.0 * bulletPower;
        int accelIndex = (int)Math.round(Math.abs(enemyLatVel) - Math.abs(lastLatVel));
        if (enemyLatVel != 0.0) {
            bearingDirection = enemyLatVel > 0.0 ? 1.0 : -1.0;
        }
        w.bearingDirection = bearingDirection * Math.asin(8.0 / w.bulletVelocity) / 15.0;
        double d2 = lastVChangeTime;
        lastVChangeTime = d2 + 1.0;
        double moveTime = w.bulletVelocity * d2 / enemyDistance;
        int bestGF = moveTime < 0.1 ? 1 : (moveTime < 0.3 ? 2 : (moveTime < 1.0 ? 3 : 4));
        int vIndex = (int)Math.abs(enemyLatVel / 3.0);
        if (Math.abs(Math.abs(enemyVelocity) - Math.abs(lastVelocity)) > 0.6) {
            lastVChangeTime = 0.0;
            bestGF = 0;
            accelIndex = (int)Math.round(Math.abs(enemyVelocity) - Math.abs(lastVelocity));
            vIndex = (int)Math.abs(enemyVelocity / 3.0);
        }
        if (accelIndex != 0) {
            accelIndex = accelIndex > 0 ? 1 : 2;
        }
        w.firePosition = robotLocation;
        w.enemyAbsBearing = enemyAbsoluteBearing;
        w.waveGuessFactors = guessFactors[accelIndex][bestGF][vIndex][BF.contains(ChocolateBar.projectMotion(robotLocation, enemyAbsoluteBearing + w.bearingDirection * 15.0, enemyDistance)) ? 0 : (BF.contains(ChocolateBar.projectMotion(robotLocation, enemyAbsoluteBearing + 0.5 * w.bearingDirection * 15.0, enemyDistance)) ? 1 : 2)][distanceIndex];
        bestGF = 15;
        for (int gf = 30; gf >= 0 && enemyEnergy > 0.0; --gf) {
            if (w.waveGuessFactors[gf] <= w.waveGuessFactors[bestGF]) continue;
            bestGF = gf;
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + w.bearingDirection * (double)(bestGF - 15))));
        if (this.getEnergy() > 1.0 || distanceIndex == 0) {
            this.setFire(bulletPower);
        }
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getRadarHeadingRadians())) * 2.0);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if ((double)this.getTime() - lastReverseTime > enemyDistance / e.getVelocity() && enemyDistance > 200.0 && !flat) {
            double d;
            numBadHits += 1.0;
            flat = d / (double)(this.getRoundNum() + 1) > 1.1;
        }
    }

    private static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance) {
        return new Point2D.Double(loc.x + distance * Math.sin(heading), loc.y + distance * Math.cos(heading));
    }

    private static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public void onWin(WinEvent e) {
        numWins += 1.0;
        this.saveData();
        this.turnLeftRadians(Math.PI);
        this.turnLeftRadians(Math.PI);
    }

    public void onDeath(DeathEvent e) {
        this.saveData();
    }

    private void restoreData() {
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(this.getDataFile(enemyName))));
            guessFactors = (int[][][][][][])in.readObject();
            in.close();
        }
        catch (Exception ex) {
            flat = false;
        }
    }

    private void saveData() {
        if (flat && numWins / (double)(this.getRoundNum() + 1) < 0.7 && this.getNumRounds() == this.getRoundNum() + 1) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(enemyName))));
                out.writeObject(guessFactors);
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        circleDir = 1.0;
        guessFactors = new int[3][5][3][3][8][31];
    }

    class MicroWave
    extends Condition {
        Point2D.Double firePosition;
        int[] waveGuessFactors;
        double enemyAbsBearing;
        double distance;
        double bearingDirection;
        double bulletVelocity;

        MicroWave() {
        }

        public boolean test() {
            double d;
            this.distance += this.bulletVelocity;
            if (enemyLocation.distance(this.firePosition) <= d + this.bulletVelocity) {
                try {
                    int n = (int)Math.round(Utils.normalRelativeAngle((double)(ChocolateBar.absoluteBearing(this.firePosition, enemyLocation) - this.enemyAbsBearing)) / this.bearingDirection + 15.0);
                    this.waveGuessFactors[n] = this.waveGuessFactors[n] + 1;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                ChocolateBar.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

