/*
 * Decompiled with CFR 0.152.
 */
package gwah;

import java.awt.Color;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class GerryBotMkII
extends Robot {
    double lastBearing = 0.0;
    boolean haveLock = false;

    public void run() {
        this.setColors(Color.blue, Color.black, Color.gray);
        this.setScanColor(Color.ORANGE);
        this.setBulletColor(Color.RED);
        this.turnRadarRight(Double.POSITIVE_INFINITY);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            if (this.haveLock) {
                this.haveLock = false;
                this.scan();
                continue;
            }
            this.turnRadarRight(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.haveLock = true;
        double bearingDelta = e.getBearing() - this.lastBearing;
        double absoluteBearing = this.getHeading() + e.getBearing() - this.getRadarHeading();
        double absoluteBodyBearing = this.getHeading() + e.getBearing() - this.getRadarHeading();
        double absoluteGunBearing = this.getTime() % 2L == 0L ? this.getHeading() + e.getBearing() + bearingDelta - this.getGunHeading() : this.getHeading() + e.getBearing() - bearingDelta - this.getGunHeading();
        this.turnRadarRight(Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(absoluteBearing))));
        this.turnGunRight(Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(absoluteGunBearing))));
        this.lastBearing = e.getBearing();
        this.fire(2.0);
    }

    public void onHitWall(HitWallEvent e) {
        this.turnRight(e.getBearing());
        this.ahead(150.0);
        this.haveLock = false;
    }

    public void onHitRobot(HitRobotEvent e) {
        double absoluteBearing = this.getHeading() + e.getBearing();
        this.turnGunRight(Math.toDegrees(Utils.normalRelativeAngle((double)(Math.toRadians(absoluteBearing) - Math.toRadians(this.getGunHeading())))));
        this.fire(3.0);
        this.haveLock = false;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.turnRight(e.getBearing());
        this.ahead(100.0);
        this.haveLock = false;
    }
}

