/*
 * Decompiled with CFR 0.152.
 */
package amk.guns;

import amk.util.Gun;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Aristocles
extends Gun {
    static final double WALL_MARGIN = 18.0;
    static final double MAX_DISTANCE = 1000.0;
    static final double MAX_BULLET_POWER = 3.0;
    static final double BULLET_POWER = 2.4;
    static final int DISTANCE_INDEXES = 7;
    static final int VELOCITY_INDEXES = 3;
    static final int LAST_VELOCITY_INDEXES = 3;
    static final int WALL_INDEXES = 2;
    static final int AIM_FACTORS = 25;
    static final int MIDDLE_FACTOR = 12;
    static Point2D enemyLocation;
    static double enemyVelocity;
    static double bearingDirection;
    static int[][][][][] aimFactors;

    public Aristocles(AdvancedRobot bot) {
        master = bot;
    }

    public void prepare(ScannedRobotEvent e) {
        Wave wave = new Wave();
        wave.robot = master;
        wave.wGunLocation = new Point2D.Double(master.getX(), master.getY());
        double enemyAbsoluteBearing = master.getHeadingRadians() + e.getBearingRadians();
        double enemyDistance = e.getDistance();
        enemyLocation = Aristocles.project(wave.wGunLocation, enemyAbsoluteBearing, enemyDistance);
        Rectangle2D.Double fieldRectangle = new Rectangle2D.Double(18.0, 18.0, master.getBattleFieldWidth() - 36.0, master.getBattleFieldHeight() - 36.0);
        int lastVelocityIndex = (int)Math.abs(enemyVelocity / 3.0);
        bearingDirection = 1.0;
        enemyVelocity = e.getVelocity();
        if (enemyVelocity != 0.0 && enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing) < 0.0) {
            bearingDirection = -1.0;
        }
        int distanceIndex = (int)(enemyDistance / 142.85714285714286);
        wave.wBulletPower = Math.min(e.getEnergy() / 4.0, distanceIndex > 1 ? 2.4 : 3.0);
        wave.wBearingDirection = bearingDirection * 0.8 / 12.0;
        wave.wAimFactors = aimFactors[distanceIndex][(int)Math.abs(enemyVelocity / 3.0)][lastVelocityIndex][fieldRectangle.contains(Aristocles.project(wave.wGunLocation, enemyAbsoluteBearing + bearingDirection * 13.0, enemyDistance)) ? 0 : 1];
        wave.wBearing = enemyAbsoluteBearing;
        int mostVisited = 24;
        for (int i = 0; i < 25; ++i) {
            if (wave.wAimFactors[i] <= wave.wAimFactors[mostVisited]) continue;
            mostVisited = i;
        }
        master.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - master.getGunHeadingRadians() + wave.wBearingDirection * (double)(mostVisited - 12))));
        if (wave.wBulletPower >= 2.4) {
            master.addCustomEvent((Condition)wave);
        }
    }

    static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    static {
        bearingDirection = 1.0;
        aimFactors = new int[7][3][3][2][25];
    }

    class Wave
    extends Condition {
        double wBulletPower;
        Point2D wGunLocation;
        double wBearing;
        double wBearingDirection;
        int[] wAimFactors;
        double wDistance;
        AdvancedRobot robot;

        Wave() {
        }

        public boolean test() {
            double d;
            this.wDistance += Aristocles.bulletVelocity(this.wBulletPower);
            if (d > this.wGunLocation.distance(enemyLocation)) {
                try {
                    int n = (int)Math.round(Utils.normalRelativeAngle((double)(Aristocles.absoluteBearing(this.wGunLocation, enemyLocation) - this.wBearing)) / this.wBearingDirection + 12.0);
                    this.wAimFactors[n] = this.wAimFactors[n] + 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Gun.master.removeCustomEvent((Condition)this);
            }
            return false;
        }
    }
}

