/*
 * Decompiled with CFR 0.152.
 */
package mue;

import mue.Util;

class HitStatistic {
    protected int shotsTotal;
    protected int hitsTotal;
    protected float damageTotal;
    protected float energyTotal;
    protected int[] shots;
    protected int[] hits;
    protected int[] buckets;

    public HitStatistic(int[] nArray) {
        this.buckets = nArray;
        this.shotsTotal = 0;
        this.hitsTotal = 0;
        this.energyTotal = 0.0f;
        this.damageTotal = 0.0f;
        this.shots = new int[this.buckets.length + 1];
        this.hits = new int[this.buckets.length + 1];
    }

    protected void addHit(int n, double d) {
        int n2 = Util.findSegmentationIndex(this.buckets, n);
        this.hits[n2] = this.hits[n2] + 1;
        ++this.hitsTotal;
        this.damageTotal = (float)((double)this.damageTotal + (d > 1.0 ? 6.0 * d - 2.0 : 4.0 * d));
    }

    protected void addShot(int n, double d) {
        int n2 = Util.findSegmentationIndex(this.buckets, n);
        this.shots[n2] = this.shots[n2] + 1;
        ++this.shotsTotal;
        this.energyTotal = (float)((double)this.energyTotal + d);
    }

    public final float hitRatio(int n) {
        int n2 = Util.findSegmentationIndex(this.buckets, n);
        if (this.shots[n2] == 0) {
            return 0.0f;
        }
        return (float)this.hits[n2] / (float)this.shots[n2];
    }

    public final float hitRatio() {
        if (this.shotsTotal == 0) {
            return 0.0f;
        }
        return (float)this.hitsTotal / (float)this.shotsTotal;
    }

    public final int shots() {
        return this.shotsTotal;
    }

    public final int hits() {
        return this.hitsTotal;
    }

    public final float energy() {
        return this.energyTotal;
    }

    public final float damage() {
        return this.damageTotal;
    }

    public String evaluate() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.hitRatio()).append(" (").append(this.hitsTotal).append("/").append(this.shotsTotal).append(")").append(" (").append(Math.round(this.damageTotal)).append(" damage / ").append(Math.round(this.energyTotal)).append(" energy)\n");
        for (int i = 0; i <= this.buckets.length; ++i) {
            stringBuffer.append("  ").append(i == 0 ? 0 : this.buckets[i - 1]).append("-").append(i == this.buckets.length ? "oo" : Integer.toString(this.buckets[i])).append(": ").append(this.shots[i] == 0 ? 0.0f : (float)this.hits[i] / (float)this.shots[i]).append(" (").append(this.hits[i]).append("/").append(this.shots[i]).append(")\n");
        }
        return stringBuffer.toString();
    }
}

