/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mue.BulletData;
import mue.BulletDetectionListener;
import mue.RobotData;
import mue.Util;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;

class Knowledge {
    protected static final int INACTIVITY_TIME = 200;
    private Map robots = new HashMap(20);
    private TeamRobot owner;
    private List bullets;
    private BulletData lastBullet;
    private long maxBulletTime;
    private long lastEnergyChange;
    private double lastHeading;
    private int lastVelocity;
    private double lastX;
    private double lastY;
    private double oldHeading;
    private int oldVelocity;
    private double oldX;
    private double oldY;
    private int oldAcceleration;
    private double lastEnergy;
    private List bulletDetectionListeners = new ArrayList();

    public Knowledge(TeamRobot teamRobot) {
        this.owner = teamRobot;
        this.lastEnergyChange = 0L;
        this.bullets = new LinkedList();
        this.lastBullet = null;
        this.maxBulletTime = (long)Math.ceil(Math.sqrt(this.owner.getBattleFieldWidth() * this.owner.getBattleFieldWidth() + this.owner.getBattleFieldHeight() * this.owner.getBattleFieldHeight()) / 11.0);
        this.oldVelocity = 0;
        this.lastVelocity = 0;
        this.oldAcceleration = 0;
        this.lastX = this.owner.getX();
        this.lastY = this.owner.getY();
        this.lastHeading = this.owner.getHeading();
        this.lastVelocity = (int)Math.round(this.owner.getVelocity());
        this.lastEnergy = this.owner.getEnergy();
    }

    public void startTick() {
        Iterator iterator = this.robots.values().iterator();
        while (iterator.hasNext()) {
            RobotData robotData = (RobotData)iterator.next();
            BulletData bulletData = robotData.startTick();
            if (bulletData == null || this.owner.isTeammate(robotData.getName())) continue;
            this.bulletDetected(bulletData);
        }
    }

    public void execute() {
        this.oldAcceleration = Math.abs(this.oldVelocity) < Math.abs(this.lastVelocity) ? 1 : (Math.abs(this.oldVelocity) > Math.abs(this.lastVelocity) ? -1 : 0);
        this.oldX = this.lastX;
        this.oldY = this.lastY;
        this.oldHeading = this.lastHeading;
        this.oldVelocity = this.lastVelocity;
        this.lastX = this.owner.getX();
        this.lastY = this.owner.getY();
        this.lastHeading = this.owner.getHeading();
        this.lastVelocity = (int)Math.round(this.owner.getVelocity());
        double d = this.lastEnergy - this.owner.getEnergy();
        if (Math.abs(d) > 1.0E-4 && (!this.inactivityTimerExpired() || Math.abs(d - 0.1) > 1.0E-4)) {
            this.updateEnergyChange(this.owner.getTime());
        }
        this.lastEnergy = this.owner.getEnergy();
    }

    public void addBulletDetectionListener(BulletDetectionListener bulletDetectionListener) {
        this.bulletDetectionListeners.add(bulletDetectionListener);
    }

    public void removeBulletDetectionListener(BulletDetectionListener bulletDetectionListener) {
        this.bulletDetectionListeners.remove(bulletDetectionListener);
    }

    private void bulletDetected(BulletData bulletData) {
        this.bullets.add(0, bulletData);
        this.lastBullet = bulletData;
        Iterator iterator = this.bulletDetectionListeners.iterator();
        while (iterator.hasNext()) {
            ((BulletDetectionListener)iterator.next()).onBulletDetected(bulletData);
        }
    }

    public void update(ScannedRobotEvent scannedRobotEvent) {
        RobotData robotData = (RobotData)this.robots.get(scannedRobotEvent.getName());
        if (robotData == null) {
            robotData = new RobotData(this, scannedRobotEvent.getName(), 18.0, 18.0, this.owner.getBattleFieldWidth() - 18.0, this.owner.getBattleFieldHeight() - 18.0, this.owner.getGunCoolingRate());
            this.robots.put(scannedRobotEvent.getName(), robotData);
        }
        robotData.update(scannedRobotEvent, this.owner.getX(), this.owner.getY(), this.owner.getHeading());
    }

    public void update(RobotDeathEvent robotDeathEvent) {
        RobotData robotData = (RobotData)this.robots.get(robotDeathEvent.getName());
        if (robotData != null) {
            robotData.update(robotDeathEvent);
        }
    }

    public void update(BulletHitEvent bulletHitEvent) {
        RobotData robotData = (RobotData)this.robots.get(bulletHitEvent.getName());
        if (robotData != null) {
            robotData.update(bulletHitEvent);
        }
    }

    public void update(HitByBulletEvent hitByBulletEvent) {
        RobotData robotData = (RobotData)this.robots.get(hitByBulletEvent.getName());
        if (robotData != null) {
            BulletData bulletData = this.getBullet(hitByBulletEvent.getBullet(), hitByBulletEvent.getTime());
            if (bulletData != null) {
                bulletData.deactivate();
            }
            robotData.update(hitByBulletEvent);
        }
    }

    public void update(BulletHitBulletEvent bulletHitBulletEvent) {
        BulletData bulletData;
        if (!this.owner.getName().equals(bulletHitBulletEvent.getBullet().getName()) && (bulletData = this.getBullet(bulletHitBulletEvent.getBullet(), bulletHitBulletEvent.getTime())) != null) {
            bulletData.deactivate();
        }
        if (!this.owner.getName().equals(bulletHitBulletEvent.getHitBullet().getName()) && (bulletData = this.getBullet(bulletHitBulletEvent.getHitBullet(), bulletHitBulletEvent.getTime())) != null) {
            bulletData.deactivate();
        }
    }

    public void update(HitRobotEvent hitRobotEvent) {
        RobotData robotData = (RobotData)this.robots.get(hitRobotEvent.getName());
        if (robotData != null) {
            robotData.update(hitRobotEvent);
        }
    }

    public void updateEnergyChange(long l) {
        this.lastEnergyChange = l;
    }

    public boolean inactivityTimerExpired() {
        return this.owner.getTime() - this.lastEnergyChange > 200L;
    }

    public Set getOpponentNames() {
        HashSet<String> hashSet = new HashSet<String>(this.robots.size() * 2);
        Iterator iterator = this.robots.keySet().iterator();
        while (iterator.hasNext()) {
            RobotData robotData = (RobotData)this.robots.get(iterator.next());
            if (this.owner.isTeammate(robotData.getName())) continue;
            hashSet.add(robotData.getName());
        }
        return hashSet;
    }

    public RobotData getRobotData(String string) {
        return (RobotData)this.robots.get(string);
    }

    public RobotData getNearestLivingOpponent() {
        Iterator iterator = this.robots.keySet().iterator();
        RobotData robotData = null;
        RobotData robotData2 = null;
        double d = 0.0;
        double d2 = this.owner.getX();
        double d3 = this.owner.getY();
        while (iterator.hasNext()) {
            robotData = (RobotData)this.robots.get(iterator.next());
            if (!robotData.isAlive() || this.owner.isTeammate(robotData.getName())) continue;
            double d4 = Util.squareDistance(d2, d3, robotData.getX(), robotData.getY());
            if (robotData2 != null && !(d4 < d)) continue;
            robotData2 = robotData;
            d = d4;
        }
        return robotData2;
    }

    public double getEnergyBalance() {
        Iterator iterator = this.robots.values().iterator();
        double d = this.owner.getEnergy();
        while (iterator.hasNext()) {
            RobotData robotData = (RobotData)iterator.next();
            d += this.owner.isTeammate(robotData.getName()) ? robotData.getEnergy() : -robotData.getEnergy();
        }
        return d;
    }

    public boolean isEmpty() {
        return this.robots.isEmpty();
    }

    public final int getOthers() {
        return this.owner.getOthers();
    }

    public int numberOfRobots() {
        return this.robots.size();
    }

    public int numberOfLivingOpponents() {
        Iterator iterator = this.robots.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RobotData robotData = (RobotData)this.robots.get(iterator.next());
            if (!robotData.isAlive() || this.owner.isTeammate(robotData.getName())) continue;
            ++n;
        }
        return n;
    }

    public BulletData lastBulletFired() {
        return this.lastBullet;
    }

    public BulletData nearestBullet() {
        if (this.bullets.isEmpty()) {
            return null;
        }
        Iterator iterator = this.bullets.iterator();
        BulletData bulletData = null;
        int n = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            int n2;
            BulletData bulletData2 = (BulletData)iterator.next();
            if (!bulletData2.isActive()) continue;
            if (this.owner.getTime() - bulletData2.getTime() > this.maxBulletTime) {
                iterator.remove();
                continue;
            }
            double d = Util.distance(this.owner.getX(), this.owner.getY(), bulletData2.getOriginX(), bulletData2.getOriginY());
            if (bulletData2.getSpeed() * (double)(this.owner.getTime() - bulletData2.getTime()) > d || (n2 = (int)Math.floor(d / bulletData2.getSpeed() - (double)(this.owner.getTime() - bulletData2.getTime() + 1L))) >= n) continue;
            n = n2;
            bulletData = bulletData2;
        }
        return bulletData;
    }

    public List activeBullets() {
        ArrayList<BulletData> arrayList = new ArrayList<BulletData>(this.bullets.size());
        Iterator iterator = this.bullets.iterator();
        while (iterator.hasNext()) {
            BulletData bulletData = (BulletData)iterator.next();
            if (this.owner.getTime() - bulletData.getTime() > this.maxBulletTime) {
                iterator.remove();
                continue;
            }
            if (!bulletData.isActive()) continue;
            arrayList.add(bulletData);
        }
        return arrayList;
    }

    public BulletData getBullet(Bullet bullet, long l) {
        Iterator iterator = this.bullets.iterator();
        BulletData bulletData = null;
        double d = Double.POSITIVE_INFINITY;
        while (iterator.hasNext()) {
            BulletData bulletData2 = (BulletData)iterator.next();
            if (this.owner.getTime() - bulletData2.getTime() > this.maxBulletTime) {
                iterator.remove();
                continue;
            }
            double d2 = Util.distance(bulletData2.getOriginX(), bulletData2.getOriginY(), bullet.getX(), bullet.getY());
            double d3 = Math.abs((double)(l - bulletData2.getTime()) * bullet.getVelocity() - d2);
            if (bulletData2.isPowerGuessed() && d3 < d) {
                bulletData = bulletData2;
                d = d3;
            }
            if (!(Math.abs(bulletData2.getPower() - bullet.getPower()) < 0.1) || !(d3 < 2.0 * bullet.getVelocity() + 1.0) && !(d3 < 0.18 * d2)) continue;
            return bulletData2;
        }
        if (bulletData != null) {
            bulletData.adapt(bullet.getPower());
        }
        return bulletData;
    }

    public final double getOldX() {
        return this.oldX;
    }

    public final double getOldY() {
        return this.oldY;
    }

    public final double getOldHeading() {
        return this.oldHeading;
    }

    public final int getOldVelocity() {
        return this.oldVelocity;
    }

    public final int getOldAcceleration() {
        return this.oldAcceleration;
    }

    public final long getTime() {
        return this.owner.getTime();
    }
}

