/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Utils;

public final class MathUtils {
    public static final int SIN_BITS;
    public static final int SIN_MASK;
    public static final int SIN_COUNT;
    public static final double radFull;
    public static final double radToIndex;
    public static final double degFull;
    public static final double degToIndex;
    public static final double[] sin;
    public static final double[] cos;
    private static final int CHAR_BIT = 4;
    private static final int INT_BIT = 8;
    private static final int SHIFT_BITS = 31;

    public static double GetAngle(double x1, double y1, double x2, double y2) {
        return Math.atan2(x2 - x1, y2 - y1);
    }

    public static double CalcRollingAverage(double currentRollingAverage, double newEntry, double history, double weighting) {
        return (currentRollingAverage * history + newEntry * weighting) / (history + weighting);
    }

    public static double PointOnSideOfLine(double lineX1, double lineY1, double lineX2, double lineY2, double pointX, double pointY) {
        return (pointX - lineX1) * (lineY2 - lineY1) - (pointY - lineY1) * (lineX2 - lineX1);
    }

    public static double FastSin(double rad) {
        return sin[(int)(rad * radToIndex) & SIN_MASK];
    }

    public static double FastCos(double rad) {
        return cos[(int)(rad * radToIndex) & SIN_MASK];
    }

    public static boolean IsPowerOfTwo(int number) {
        return number > 0 && (number & number - 1) == 0;
    }

    public static double FastMin(double a, double b) {
        return a <= b ? a : b;
    }

    public static double FastMax(double a, double b) {
        return a >= b ? a : b;
    }

    public static int FastMin(int a, int b) {
        return a <= b ? a : b;
    }

    public static int FastMax(int a, int b) {
        return a >= b ? a : b;
    }

    public static long FastMin(long a, long b) {
        return a <= b ? a : b;
    }

    public static long FastMax(long a, long b) {
        return a >= b ? a : b;
    }

    public static int FastMinBit(int x, int y) {
        int xMinusY = x - y;
        return y + (xMinusY & xMinusY >> 31);
    }

    public static double GuessFactorTo01(double gF) {
        double gF01 = (gF + 1.0) * 0.5;
        return Math.max(Math.min(gF01, 1.0), 0.0);
    }

    public static double Dot(double x1, double y1, double x2, double y2) {
        return x1 * x2 + y1 * y2;
    }

    static {
        int i;
        SIN_BITS = 12;
        SIN_MASK = ~(-1 << SIN_BITS);
        SIN_COUNT = SIN_MASK + 1;
        radFull = Math.PI * 2;
        degFull = 360.0;
        radToIndex = (double)SIN_COUNT / radFull;
        degToIndex = (double)SIN_COUNT / degFull;
        sin = new double[SIN_COUNT];
        cos = new double[SIN_COUNT];
        for (i = 0; i < SIN_COUNT; ++i) {
            MathUtils.sin[i] = Math.sin((double)(((float)i + 0.5f) / (float)SIN_COUNT) * radFull);
            MathUtils.cos[i] = Math.cos((double)(((float)i + 0.5f) / (float)SIN_COUNT) * radFull);
        }
        for (i = 0; i < 360; i += 90) {
            MathUtils.sin[(int)((double)i * MathUtils.degToIndex) & MathUtils.SIN_MASK] = Math.sin((double)i * Math.PI / 180.0);
            MathUtils.cos[(int)((double)i * MathUtils.degToIndex) & MathUtils.SIN_MASK] = Math.cos((double)i * Math.PI / 180.0);
        }
    }
}

