/*
 * Decompiled with CFR 0.152.
 */
package csm;

import csm.genetic_trainer.GameState;
import csm.genetic_trainer.GeneSerializer;
import csm.genetic_trainer.Population;
import csm.genetic_trainer.TrainableNumberCache;
import csm.util.EnemyBullet;
import csm.util.EnemyRobot;
import csm.util.Geometry;
import csm.util.GravityWell;
import csm.util.Score;
import csm.util.SpaceTime;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class NthGeneration
extends AdvancedRobot {
    private LinkedList lastCoordinates = null;
    Hashtable targets;
    Hashtable targettingStatistics;
    Hashtable myBullets;
    Vector enemyBullets;
    EnemyRobot target;
    final double PI = Math.PI;
    int direction = 1;
    double firePower;
    double midpointstrength = 0.0;
    int midpointcount = 0;
    private int radarDirection = 1;
    private int dodgeType = 1;
    private TrainableNumberCache trainedNumbers = null;
    private int numInitialOponents = 0;
    private double xforce = 0.0;
    private double yforce = 0.0;
    private static Score score = null;
    private static Population trainingPopulation = null;
    private static TrainableNumberCache numCache = null;
    private static boolean trainingMode = false;
    private int populationSize = 20;
    private int roundsPerTest = 10;
    private boolean fireThisRound = false;
    private int numCoordinatesHeld = 20;
    private int roundsOnTarget = 100;

    public void run() {
        this.lastCoordinates = new LinkedList();
        if (trainingMode && this.getRoundNum() > 1 && this.getRoundNum() % (this.populationSize * this.roundsPerTest) == 0) {
            GeneSerializer.writePopulation(this.getDataFile("trainingPopulation"), trainingPopulation);
            GeneSerializer.writeTrainableNumberCache(this.getDataFile("numCache"), trainingPopulation.getBestCache());
        }
        if (score == null) {
            score = new Score();
        }
        if (numCache == null && !this.readBestGene()) {
            if (trainingPopulation == null && !this.readPopulationGene()) {
                trainingPopulation = new Population(this.populationSize, this.roundsPerTest);
            }
            trainingMode = true;
        }
        this.setColors(Color.black, Color.black, Color.black);
        if (trainingMode) {
            numCache = trainingPopulation.getNextNumberCache();
        }
        if (numCache == null) {
            this.out.println("Null Trainable Number Cache ");
        } else {
            GameState.initialNumberCache(numCache);
            numCache.setTestingMode(true);
        }
        if (this.targettingStatistics == null) {
            this.targettingStatistics = new Hashtable();
        }
        this.targets = new Hashtable();
        this.myBullets = new Hashtable();
        this.enemyBullets = new Vector();
        this.target = new EnemyRobot();
        this.target.setDistance(2.0 * Math.max(this.getBattleFieldWidth(), this.getBattleFieldHeight()));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.numInitialOponents = this.getOthers();
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.updatePosition();
            this.processAllEvents();
            this.doMove();
            this.doFirePower();
            this.doScanner();
            this.doGun();
            this.doFire(this.firePower);
            this.execute();
        }
    }

    private void updatePosition() {
        SpaceTime spaceTime = new SpaceTime(this.getX(), this.getY(), this.getTime(), this.getHeading(), false);
        this.lastCoordinates.addLast(spaceTime);
        if (this.lastCoordinates.size() > this.numCoordinatesHeld) {
            this.lastCoordinates.removeFirst();
        }
    }

    private boolean readBestGene() {
        boolean readBest = true;
        numCache = GeneSerializer.readTrainableNumberCache(this.getDataFile("numCache"));
        readBest = numCache != null;
        return readBest;
    }

    private boolean readPopulationGene() {
        boolean readBest = true;
        trainingPopulation = GeneSerializer.readPopulation(this.getDataFile("trainingPopulation"));
        readBest = trainingPopulation != null;
        return readBest;
    }

    private void doMove() {
        this.antiGravMove();
    }

    public void processAllEvents() {
        Vector v = this.getAllEvents();
        int i = 0;
        while (i < v.size()) {
            Event e = (Event)v.elementAt(i);
            if (e instanceof BulletHitEvent) {
                this.onBulletHit((BulletHitEvent)e);
            } else if (e instanceof ScannedRobotEvent) {
                this.onScannedRobot((ScannedRobotEvent)e);
            } else if (e instanceof HitWallEvent) {
                this.onHitWall((HitWallEvent)e);
            } else if (e instanceof HitByBulletEvent) {
                this.onHitByBullet((HitByBulletEvent)e);
            } else if (e instanceof WinEvent) {
                this.onWin((WinEvent)e);
            } else if (e instanceof DeathEvent) {
                this.onDeath((DeathEvent)e);
            } else if (e instanceof BulletHitBulletEvent) {
                this.onBulletHitBullet((BulletHitBulletEvent)e);
            } else if (e instanceof BulletMissedEvent) {
                this.onBulletMissed((BulletMissedEvent)e);
            } else if (e instanceof HitRobotEvent) {
                this.onHitRobot((HitRobotEvent)e);
            } else if (e instanceof RobotDeathEvent) {
                this.onRobotDeath((RobotDeathEvent)e);
            }
            ++i;
        }
        this.clearAllEvents();
    }

    public void doFire(double firePower) {
        if (this.target != null && this.fireThisRound) {
            ++this.roundsOnTarget;
            this.setFire(firePower);
        }
    }

    void doFirePower() {
        double firePowerScalingFactor = numCache.getDouble("firePowerScalingFactor", 500.0, 100.0, 1000.0);
        this.firePower = firePowerScalingFactor / this.target.getDistance();
        if (this.firePower > 3.0) {
            this.firePower = 3.0;
        }
        if (this.firePower < 0.1) {
            this.firePower = 0.1;
        }
        if (this.target.getName().startsWith("redarmy") || this.target.getName().startsWith("sjl")) {
            this.firePower = 3.0;
        }
        if (this.getEnergy() <= 0.1) {
            this.firePower = 0.0;
        } else if (this.getEnergy() < 1.0) {
            this.firePower = 0.1;
        } else if (this.getEnergy() < 3.0 && this.firePower > 1.0) {
            this.firePower = 1.0;
        }
    }

    public void onHitWall(HitWallEvent e) {
        double damage = Math.abs(this.getVelocity()) * 0.5 - 1.0;
        numCache.setScore(numCache.getScore() - damage);
    }

    private void antiGravDueling() {
        if (this.getOthers() == 1) {
            double dodgeTime = 40.0;
            Random r = new Random(System.currentTimeMillis());
            if ((double)this.getTime() % dodgeTime == 0.0) {
                this.dodgeType = (this.dodgeType + 1) % 4;
            }
            if (this.target != null) {
                double bearing = Geometry.shortestBearingRadians(Geometry.absoluteBearingRadians(this.getX(), this.getY(), this.target.getX(), this.target.getY()));
                if (this.dodgeType == 0) {
                    bearing += 1.5707963267948966;
                } else if (this.dodgeType == 1) {
                    bearing -= 1.5707963267948966;
                } else if (this.dodgeType == 2) {
                    bearing += 0.7853981633974483;
                } else if (this.dodgeType == 3) {
                    bearing -= 0.7853981633974483;
                }
                double force = 20000.0;
                this.xforce += Math.sin(bearing) * force;
                this.yforce += Math.cos(bearing) * force;
            }
        }
    }

    private void antiGravRobots() {
        double myX = this.getX();
        double myY = this.getY();
        Enumeration e = this.targets.elements();
        while (e.hasMoreElements()) {
            EnemyRobot en = (EnemyRobot)e.nextElement();
            if (!en.isLive()) continue;
            double robotGravity = numCache.getDouble("robotGravity", -1000.0, -10000.0, 0.0);
            GravityWell p = new GravityWell(en.getX(), en.getY(), robotGravity);
            double force = p.power / Math.pow(Geometry.range(myX, myY, p.x, p.y), 2.0);
            double ang = Geometry.shortestBearingRadians(1.5707963267948966 - Math.atan2(myY - p.y, myX - p.x));
            this.xforce += Math.sin(ang) * force;
            this.yforce += Math.cos(ang) * force;
        }
    }

    private void doBasicAntiGravBullet(EnemyBullet eb, Point2D.Double ebPos) {
        double myX = this.getX();
        double myY = this.getY();
        double distance = Geometry.range(myX, myY, ebPos.getX(), ebPos.getY());
        double force = eb.power / Math.pow(distance, 2.0);
        double ang = Geometry.shortestBearingRadians(1.5707963267948966 - Math.atan2(myY - ebPos.getY(), myX - ebPos.getX()));
        this.xforce += Math.sin(ang) * force;
        this.yforce += Math.cos(ang) * force;
    }

    private void doTravellingAttractorAntiGravBullet(EnemyBullet eb, Point2D.Double ebPos) {
        double myX = this.getX();
        double myY = this.getY();
        double bulletHeading = eb.getHeading();
        double attractorDistance = Math.max(this.getHeight(), this.getWidth()) + 10.0;
        double a1_X = ebPos.getX() + attractorDistance * Math.sin(eb.getHeading() + 1.5707963267948966);
        double a2_X = ebPos.getX() + attractorDistance * Math.sin(eb.getHeading() - 1.5707963267948966);
        double a1_Y = ebPos.getY() + attractorDistance * Math.cos(eb.getHeading() + 1.5707963267948966);
        double a2_Y = ebPos.getY() + attractorDistance * Math.cos(eb.getHeading() - 1.5707963267948966);
        double distance = Geometry.range(myX, myY, a1_X, a1_Y);
        double force = eb.power / 4.0 / Math.pow(distance, 2.0);
        double ang = Geometry.shortestBearingRadians(1.5707963267948966 - Math.atan2(myY - a1_Y, myX - a1_X));
        this.xforce -= Math.sin(ang) * force;
        this.yforce -= Math.cos(ang) * force;
        distance = Geometry.range(myX, myY, a2_X, a2_Y);
        force = eb.power / 4.0 / Math.pow(distance, 2.0);
        ang = Geometry.shortestBearingRadians(1.5707963267948966 - Math.atan2(myY - a2_Y, myX - a2_X));
        this.xforce -= Math.sin(ang) * force;
        this.yforce -= Math.cos(ang) * force;
    }

    private void doPerpendicularForceAntiGravBullet(EnemyBullet eb, Point2D.Double ebPos) {
        double myX = this.getX();
        double myY = this.getY();
        double distance = Geometry.range(myX, myY, ebPos.getX(), ebPos.getY());
        double force = eb.power / Math.pow(Geometry.range(myX, myY, ebPos.getX(), ebPos.getY()), 2.0);
        double rise = ebPos.getY() - eb.y;
        double run = ebPos.getX() - eb.x;
        if (run == 0.0) {
            this.xforce = myX > eb.x ? (this.xforce += force) : (this.xforce -= force);
        } else if (rise == 0.0) {
            this.yforce = myY > eb.y ? (this.yforce += force) : (this.yforce -= force);
        } else {
            double m = rise / run;
            double c = eb.y - m * eb.x;
            force = eb.power * 30.0 / Math.pow(Geometry.range(myX, myY, ebPos.getX(), ebPos.getY()), 3.0);
            double perpX = Math.sin(eb.getHeading() + 1.5707963267948966) * force;
            double perpY = Math.cos(eb.getHeading() + 1.5707963267948966) * force;
            this.xforce = myX > (myY - c) / m ? (this.xforce += Math.abs(perpX)) : (this.xforce += -1.0 * Math.abs(perpX));
            this.yforce = myY > m * myX + c ? (this.yforce += Math.abs(perpY)) : (this.yforce += -1.0 * Math.abs(perpY));
        }
    }

    private void antiGravBullets() {
        Enumeration bullets = this.enemyBullets.elements();
        Vector<EnemyBullet> newBullets = new Vector<EnemyBullet>();
        while (bullets.hasMoreElements()) {
            EnemyBullet eb = (EnemyBullet)bullets.nextElement();
            Point2D.Double ebPos = eb.guessPosition(this.getTime());
            if (!(ebPos.getX() > 0.0) || !(ebPos.getX() < this.getBattleFieldWidth()) || !(ebPos.getY() > 0.0) || !(ebPos.getY() < this.getBattleFieldHeight())) continue;
            this.doBasicAntiGravBullet(eb, ebPos);
            newBullets.add(eb);
        }
        this.enemyBullets = newBullets;
    }

    private void antiGravMidpoint() {
        ++this.midpointcount;
        double midpointTurns = 5.0;
        double midpointStrength = 1000.0;
        if (this.midpointcount > 5) {
            this.midpointcount = 0;
            this.midpointstrength = Math.random() * 2.0 * midpointStrength - midpointStrength;
        }
        GravityWell p = new GravityWell(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0, this.midpointstrength);
        double force = p.power / Math.pow(Geometry.range(this.getX(), this.getY(), p.x, p.y), 1.5);
        double ang = Geometry.shortestBearingRadians(1.5707963267948966 - Math.atan2(this.getY() - p.y, this.getX() - p.x));
        this.xforce += Math.sin(ang) * force;
        this.yforce += Math.cos(ang) * force;
    }

    private void antiGravCorners() {
        double cornerTurns = 200.0;
        double cornerStrength = 1000.0;
        if ((double)this.getRoundNum() % cornerTurns == 0.0) {
            // empty if block
        }
        GravityWell p = new GravityWell(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0, this.midpointstrength);
        double force = p.power / Math.pow(Geometry.range(this.getX(), this.getY(), p.x, p.y), 1.5);
        double ang = Geometry.shortestBearingRadians(1.5707963267948966 - Math.atan2(this.getY() - p.y, this.getX() - p.x));
        this.xforce += Math.sin(ang) * force;
        this.yforce += Math.cos(ang) * force;
    }

    private void antiGravWalls() {
        double baseWallForce = numCache.getDouble("baseWallForce", 30000.0, 0.0, 300000.0);
        double robotWallForce = numCache.getDouble("robotWallForce", 1000.0, 0.0, 10000.0);
        double bulletWallForce = numCache.getDouble("bulletWallForce", 1000.0, 0.0, 10000.0);
        double forceNumerator = baseWallForce + robotWallForce + (double)this.enemyBullets.size();
        this.xforce += forceNumerator / Math.pow(Geometry.range(this.getX(), this.getY(), this.getBattleFieldWidth(), this.getY()), 3.0);
        this.xforce -= forceNumerator / Math.pow(Geometry.range(this.getX(), this.getY(), 0.0, this.getY()), 3.0);
        this.yforce += forceNumerator / Math.pow(Geometry.range(this.getX(), this.getY(), this.getX(), this.getBattleFieldHeight()), 3.0);
        this.yforce -= forceNumerator / Math.pow(Geometry.range(this.getX(), this.getY(), this.getX(), 0.0), 3.0);
    }

    private void resolveAntiGravForces() {
        double xLoc = this.getX() - this.xforce;
        double yLoc = this.getY() - this.yforce;
        this.goTo(xLoc, yLoc);
    }

    private void antiGravMove() {
        this.xforce = 0.0;
        this.yforce = 0.0;
        this.antiGravDueling();
        this.antiGravRobots();
        this.antiGravBullets();
        this.antiGravWalls();
        this.antiGravMidpoint();
        this.resolveAntiGravForces();
    }

    private void findSafePointMove() {
        boolean safePointFound = false;
        double currentX = this.getX();
        double currentY = this.getY();
    }

    void goTo(double x, double y) {
        double antiGravDistance = 20.0;
        double myX = this.getX();
        double myY = this.getY();
        double xLoc = x;
        double yLoc = y;
        double closestWallPoint = Math.max(this.getHeight(), this.getWidth()) + 10.0;
        double angle = 0.0;
        if (xLoc < closestWallPoint) {
            xLoc = closestWallPoint;
        }
        if (xLoc > this.getBattleFieldWidth() - closestWallPoint) {
            xLoc = this.getBattleFieldWidth() - closestWallPoint;
        }
        if (yLoc < closestWallPoint) {
            yLoc = closestWallPoint;
        }
        if (yLoc > this.getBattleFieldHeight() - closestWallPoint) {
            yLoc = this.getBattleFieldHeight() - closestWallPoint;
        }
        angle = Math.toDegrees(Geometry.absoluteBearingRadians(myX, myY, xLoc, yLoc));
        double direction = this.turnTo(angle);
        this.setAhead(antiGravDistance * direction);
    }

    private boolean safePoint(double x, double y, double closestDistance) {
        boolean safePoint = true;
        Enumeration bullets = this.enemyBullets.elements();
        while (bullets.hasMoreElements() && safePoint) {
            EnemyBullet eb = (EnemyBullet)bullets.nextElement();
            Point2D.Double ebPos = eb.guessPosition(this.getTime() + 1L);
            if (!(ebPos.getX() > 0.0) || !(ebPos.getX() < this.getBattleFieldWidth()) || !(ebPos.getY() > 0.0) || !(ebPos.getY() < this.getBattleFieldHeight())) continue;
            boolean bl = safePoint = Geometry.range(ebPos.getX(), ebPos.getY(), x, y) > closestDistance;
        }
        return safePoint;
    }

    int turnTo(double angle) {
        int dir;
        double ang = Geometry.shortestBearingRadians(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }

    private void doScanner() {
        double maxBearingAbs = 0.0;
        double maxBearing = 0.0;
        int scannedBots = 0;
        Enumeration e = this.targets.elements();
        while (e.hasMoreElements()) {
            EnemyRobot en = (EnemyRobot)e.nextElement();
            double timeSinceScanned = this.getTime() - en.getCtime();
            if (en == null || !(timeSinceScanned < 16.0)) continue;
            double bearing = Geometry.shortestBearingRadians(this.getHeadingRadians() + en.getBearing() - this.getRadarHeadingRadians());
            if (Math.abs(bearing) > maxBearingAbs) {
                maxBearingAbs = Math.abs(bearing);
                maxBearing = bearing;
            }
            ++scannedBots;
        }
        double radarTurn = 180 * this.radarDirection;
        if (scannedBots == this.getOthers()) {
            radarTurn = maxBearing;
            radarTurn = maxBearing >= 0.0 ? (radarTurn += 0.39269908169872414) : (radarTurn -= 0.39269908169872414);
        }
        this.setTurnRadarRightRadians(radarTurn);
        this.radarDirection = radarTurn >= 0.0 ? 1 : -1;
    }

    private void doGun() {
        Point2D.Double p = new Point2D.Double(this.target.getX(), this.target.getY());
        double myX = this.getX();
        double myY = this.getY();
        int i = 0;
        while (i < 10) {
            long nextTime = (int)Math.round(Geometry.range(myX, myY, p.x, p.y) / (20.0 - 3.0 * this.firePower));
            long time = this.getTime() + nextTime;
            p = this.target.guessPosition(time);
            ++i;
        }
        double gunOffset = this.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(p.y - myY, p.x - myX));
        this.setTurnGunLeftRadians(Geometry.shortestBearingRadians(gunOffset));
        this.fireThisRound = Math.abs(Geometry.shortestBearingRadians(gunOffset)) < 0.39269908169872414 && this.getOthers() > 0;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Bullet b = e.getBullet();
        double power = b.getPower();
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        numCache.setScore(numCache.getScore() - damage);
    }

    public void onBulletHit(BulletHitEvent e) {
        EnemyRobot en;
        if (this.targets.containsKey(e.getName())) {
            en = (EnemyRobot)this.targets.get(e.getName());
        } else {
            en = new EnemyRobot();
            this.targets.put(e.getName(), en);
        }
        en.setEnergy(e.getEnergy());
        Bullet b = e.getBullet();
        en.setX(b.getX());
        en.setY(b.getY());
        en.setCtime(this.getTime());
        double power = b.getPower();
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        score.setBulletDamage(score.getBulletDamage() + damage);
        numCache.setScore(numCache.getScore() + damage);
        en.setDamageInflicted(en.getDamageInflicted() + damage);
        if (en.getEnergy() <= 0.0) {
            score.setBulletDamageBonus(score.getBulletDamageBonus() + 0.2 * en.getDamageInflicted());
            numCache.setScore(numCache.getScore() + 0.2 * en.getDamageInflicted());
        }
    }

    private EnemyRobot getRobot(ScannedRobotEvent e) {
        double changeInEnergy = 0.0;
        EnemyRobot en = null;
        if (this.targets.containsKey(e.getName())) {
            en = (EnemyRobot)this.targets.get(e.getName());
            changeInEnergy = en.getEnergy() - e.getEnergy();
        } else {
            en = new EnemyRobot();
            this.targets.put(e.getName(), en);
        }
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        double targetX = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
        double targetY = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
        en.setName(e.getName());
        double h = Geometry.shortestBearingRadians(e.getHeadingRadians() - en.getHeading());
        en.setChangehead(h /= (double)(this.getTime() - en.getCtime()));
        en.setX(targetX);
        en.setY(targetY);
        en.setBearing(e.getBearingRadians());
        en.setHeading(e.getHeadingRadians());
        en.setCtime(this.getTime());
        en.setSpeed(e.getVelocity());
        en.setDistance(e.getDistance());
        en.setLive(true);
        en.setEnergy(e.getEnergy());
        en.snapshot();
        if (changeInEnergy > 0.0) {
            this.doDodge(e, en, changeInEnergy);
        }
        return en;
    }

    private void doDodge(ScannedRobotEvent e, EnemyRobot en, double changeInEnergy) {
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        boolean newRobot = false;
        double myX = this.getX();
        double myY = this.getY();
        if (changeInEnergy > 0.1 && changeInEnergy <= 3.0 && en.isLive()) {
            long roundsSinceLastScan = en.getRoundsSinceLastScan();
            SpaceTime lastEnemySpaceTime = null;
            if (roundsSinceLastScan > 1L) {
                lastEnemySpaceTime = en.getLastSpaceTime();
            }
            long numPrevCoordinates = this.lastCoordinates.size();
            long bulletFireTime = this.getTime();
            while (bulletFireTime > this.getTime() - roundsSinceLastScan && bulletFireTime > this.getTime() - numPrevCoordinates && bulletFireTime > this.getTime() - 10L) {
                SpaceTime mySpaceTime = this.getMySpaceTime(bulletFireTime);
                Point2D.Double ep = en.guessPosition(bulletFireTime);
                SpaceTime enSpaceTime = new SpaceTime(ep.x, ep.y, bulletFireTime, 0.0, false);
                if (mySpaceTime != null && enSpaceTime != null) {
                    EnemyRobot myModel = new EnemyRobot(mySpaceTime);
                    myModel.setName("Me");
                    myModel.setChangehead(0.0);
                    myModel.setBearing(0.0);
                    myModel.setDistance(0.0);
                    myModel.setLive(true);
                    myModel.setEnergy(this.getEnergy());
                    myModel.snapshot();
                    myX = mySpaceTime.getX();
                    myY = mySpaceTime.getY();
                    absbearing_rad = Geometry.absoluteBearingRadians(myX, myY, enSpaceTime.getX(), enSpaceTime.getY());
                    int k = 0;
                    while (k < 2) {
                        double distance = Geometry.range(enSpaceTime.getX(), enSpaceTime.getY(), myX, myY) - Math.max(this.getHeight(), this.getWidth());
                        double bulletGravity = numCache.getDouble("bulletGravity", -800.0, -10000.0, 0.0);
                        EnemyBullet eb = new EnemyBullet(myX + Math.sin(absbearing_rad) * distance, myY + Math.cos(absbearing_rad) * distance, bulletGravity /= (double)roundsSinceLastScan);
                        eb.setHeading(Geometry.absoluteBearingRadians(myX + Math.sin(absbearing_rad) * distance, myY + Math.cos(absbearing_rad) * distance, myX, myY));
                        eb.setSpeed(20.0 - 3.0 * changeInEnergy);
                        eb.setCtime(bulletFireTime);
                        eb.setBulletEnergy(changeInEnergy);
                        this.enemyBullets.add(eb);
                        long time = 0L;
                        Point2D.Double p = new Point2D.Double(myX, myY);
                        long nextTime = 0L;
                        int i = 0;
                        while (i < 10) {
                            nextTime = Math.round(Geometry.range(enSpaceTime.getX(), enSpaceTime.getY(), p.x, p.y) / (20.0 - 3.0 * changeInEnergy));
                            time = bulletFireTime + nextTime;
                            p = myModel.guessPosition(time);
                            ++i;
                        }
                        myX = p.x;
                        myY = p.y;
                        absbearing_rad = Geometry.absoluteBearingRadians(myX, myY, enSpaceTime.getX(), enSpaceTime.getY());
                        ++k;
                    }
                }
                --bulletFireTime;
            }
        }
    }

    private SpaceTime getMySpaceTime(long time) {
        if (time <= this.getTime()) {
            if (this.getTime() - time < (long)this.lastCoordinates.size()) {
                return (SpaceTime)this.lastCoordinates.get((int)((long)(this.lastCoordinates.size() - 1) - (this.getTime() - time)));
            }
            return null;
        }
        return null;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        EnemyRobot en = this.getRobot(e);
        this.selectTarget(e, en);
    }

    private void selectTarget(ScannedRobotEvent e, EnemyRobot en) {
        if (this.target == null || !this.target.isLive()) {
            this.target = en;
            this.roundsOnTarget = 0;
        }
        if (e.getDistance() < this.target.getDistance()) {
            this.target = en;
            this.roundsOnTarget = 0;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        EnemyRobot en = (EnemyRobot)this.targets.get(e.getName());
        if (en != null) {
            en.setLive(false);
        }
        score.setSurvivalScore(score.getSurvivalScore() + 50.0);
        numCache.setScore(numCache.getScore() + 50.0);
    }

    public void onWin(WinEvent e) {
        score.setLastSurvivorBonus(score.getLastSurvivorBonus() + (double)(this.numInitialOponents * 5));
        numCache.setScore(numCache.getScore() + (double)(this.numInitialOponents * 30));
        if (trainingMode) {
            this.reportScore();
        }
    }

    public void onDeath(DeathEvent e) {
        numCache.setScore(numCache.getScore() - (double)(this.getOthers() * 10));
        if (trainingMode) {
            this.reportScore();
        }
        this.dumpGene();
    }

    private void dumpGene() {
        System.out.println("\nCache");
        numCache.dumpGene();
    }

    private void reportScore() {
        this.out.println("Cache : " + numCache.getScore());
    }
}

