/*
 * Decompiled with CFR 0.152.
 */
package alk.lap;

import alk.lap.SpottingRobotI;
import alk.lap.bothandling.DriverI;
import alk.lap.bothandling.Gunner;
import alk.lap.bothandling.RadarMovement;
import alk.lap.strategy.StrategicLead;
import alk.lap.strategy.TacticalLead;
import alk.lap.utils.Cronner;
import alk.lap.utils.DVektor;
import alk.lap.utils.Job;
import alk.lap.utils.VirtualCanvas;
import java.awt.Color;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class LoudAndProud
extends AdvancedRobot
implements SpottingRobotI {
    public static final long TIME_TO_MOVE_AWAY = 10L;
    public static final boolean ALLOW_BACKMOVE = false;
    public static final boolean BACKMOVE_ALLOWED = false;
    public static final boolean TALK = false;
    public static final double ASSUM_V_FORTURNRATE = 6.4;
    public static final int STRAT_CALL_FREQUENCE = 5;
    private RadarMovement radarMovement;
    private Gunner gunner;
    private DriverI driver;
    private TacticalLead tacticLead;
    private Cronner cronner;
    private VirtualCanvas vc;
    private double initialDistance;
    private static ArrayList<String> statsBuffer = new ArrayList();
    private static StrategicLead strategicLead = new StrategicLead();
    private double proudsRadius;
    private long recentTime = -1L;
    private double lastMove = Double.POSITIVE_INFINITY;
    private DVektor position = null;
    private double battleFieldWidth = 0.0;
    private double battleFieldHeight = 0.0;
    static DecimalFormat timeFormatter = null;
    static DecimalFormat formatter = null;
    static DecimalFormat de_formatter = null;

    public void run() {
        this.cronner = new Cronner(this);
        this.vc = new VirtualCanvas(this);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setBodyColor(Color.DARK_GRAY);
        this.proudsRadius = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight()) / 2.0;
        this.battleFieldWidth = super.getBattleFieldWidth();
        this.battleFieldHeight = super.getBattleFieldHeight();
        this.initialDistance = -1.0;
        this.recentTime = -1L;
        this.tacticLead = new TacticalLead(this);
        strategicLead.setProudInstance(this);
        this.setGunner(strategicLead.getCurrentGunner());
        this.driver = strategicLead.getFahrer();
        this.radarMovement = new RadarMovement(this);
        this.every(12, new Job(){
            int colorToggle = 0;

            public void doJob(SpottingRobotI robot) {
                LoudAndProud proud = (LoudAndProud)robot;
                Color color = new Color(255, 155, 64);
                if (this.colorToggle++ % 2 == 0) {
                    color = Color.BLACK;
                }
                proud.setRadarColor(color);
            }

            public String describeYourself() {
                return "Pimp my robot";
            }
        });
        this.every(5, strategicLead);
        while (true) {
            this.tacticLead.beforeTurn();
            this.execute();
            this.cronner.checkAndExecuteJobs();
            if (!this.tacticLead.isEnemySpotted()) {
                if (this.getOthers() > 0) {
                    this.log("no enemy spotted...");
                }
            } else if (this.initialDistance == -1.0) {
                this.initialDistance = this.tacticLead.getEnemyDistance();
            }
            this.tacticLead.processTurn();
            this.driver.moveProud();
            this.radarMovement.moveRadar();
            this.gunner.turnGunToTarget();
            this.gunner.doFire();
            this.getVc().cleanUp();
            this.recentTime = -1L;
            this.position = null;
        }
    }

    public boolean isInBorder(DVektor aPosition) {
        return DVektor.isInRectangle(aPosition, 0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
    }

    public boolean isInBorder(DVektor aPosition, double radius) {
        return DVektor.isInRectangle(aPosition, radius, radius, this.getBattleFieldWidth() - radius, this.getBattleFieldHeight() - radius);
    }

    public long remainingTurnsToMoveProud(DVektor target) {
        return this.remainingTurnsToMoveProud(target, 7.0, false);
    }

    public long remainingTurnsToMoveProud(DVektor target, double targetRadius, boolean allowBackMove) {
        DVektor deltaToTarget = DVektor.sub(target, this.getPosition());
        double move = deltaToTarget.getLength();
        if (move > this.lastMove && !allowBackMove) {
            this.lastMove = Double.POSITIVE_INFINITY;
            return 0L;
        }
        this.lastMove = move;
        double angle = LoudAndProud.normalRelativeAngle(deltaToTarget.getDirection() - this.getHeading());
        if (angle > 90.0) {
            angle -= 180.0;
            move *= -1.0;
        }
        if (angle < -90.0) {
            angle += 180.0;
            move *= -1.0;
        }
        if (Math.abs(this.getDistanceRemaining()) < targetRadius) {
            if (Math.abs(move) > 7.0) {
                if (Utils.isNear((double)this.getTurnRemaining(), (double)0.0) && Math.abs(angle) > 1.0) {
                    this.setTurnRight(angle);
                }
                this.setAhead(move);
                return this.timeToReach(target);
            }
            this.lastMove = Double.POSITIVE_INFINITY;
            return 0L;
        }
        if (Utils.isNear((double)this.getTurnRemaining(), (double)0.0) && Math.abs(angle) > 1.0) {
            this.setTurnRight(angle);
        }
        return this.timeToReach(target);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.tacticLead.collectDataFrom(e);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.log("->" + event.getName() + " hit me with " + this.printDouble(event.getPower()));
        this.tacticLead.processHitByBullet(event);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.tacticLead.collectDataFrom(event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.tacticLead.processBulletHitBullet(event);
    }

    public void onCustomEvent(CustomEvent ce) {
        this.gunner.checkCustomEvent(ce);
    }

    public void onDeath(DeathEvent event) {
        this.writeStats(false);
        ++this.getStrategicLead().getAnalystsDB().rounds_lost;
    }

    public void onWin(WinEvent event) {
        this.writeStats(true);
        ++this.getStrategicLead().getAnalystsDB().rounds_won;
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.log("skipped turn");
    }

    public DVektor getPosition() {
        if (this.position == null) {
            this.position = new DVektor(this.getX(), this.getY());
        }
        return this.position;
    }

    public void onPaint(Graphics2D g) {
    }

    public boolean isDirectlyReachable(DVektor target) {
        double v = 6.4;
        double r = 360.0 / (10.0 - 0.75 * v) * v / (Math.PI * 2);
        DVektor proudsPos = this.getPosition();
        DVektor p1 = DVektor.add(proudsPos, new DVektor(r, 0.0));
        DVektor p2 = DVektor.add(proudsPos, new DVektor(-r, 0.0));
        p1.rotate(proudsPos, -this.getHeading());
        p2.rotate(proudsPos, -this.getHeading());
        this.getVc().drawCircle(p1, r, "rechts");
        this.getVc().drawCircle(p2, r, "links");
        return !(p1.getDistanceTo(target) < r) && !(p2.getDistanceTo(target) < r);
    }

    public void setGunner(Gunner newGunner) {
        if (newGunner == null || this.gunner != newGunner) {
            if (this.gunner != null) {
                this.gunner.unMount();
            }
            this.gunner = newGunner;
            this.gunner.mount();
        }
    }

    public Class getGunnerClass() {
        return this.gunner.getClass();
    }

    public DriverI getDriver() {
        return this.driver;
    }

    public void setDriver(DriverI fahrer) {
        this.driver = fahrer;
    }

    public TacticalLead getTacticLead() {
        return this.tacticLead;
    }

    public StrategicLead getStrategicLead() {
        return strategicLead;
    }

    public static StrategicLead getStaticStrategicLead() {
        return strategicLead;
    }

    public VirtualCanvas getVc() {
        return this.vc;
    }

    public double getEnemyBearing() {
        return this.tacticLead.getEnemyBearing();
    }

    public boolean getSpottedEnemy() {
        return this.tacticLead.isEnemySpotted();
    }

    public boolean isTalking() {
        return false;
    }

    public double getProudsRadius() {
        return this.proudsRadius;
    }

    public long getTime() {
        if (this.recentTime == -1L) {
            this.recentTime = super.getTime();
        }
        return this.recentTime;
    }

    public double getBattleFieldWidth() {
        return this.battleFieldWidth;
    }

    public double getBattleFieldHeight() {
        return this.battleFieldHeight;
    }

    public Job every(int i, Job job) {
        return this.cronner.addRepeatJob(i, job);
    }

    public Job at(long time, Job job) {
        return this.cronner.addSingleJob(time, job);
    }

    public Job in(long deltaT, Job job) {
        return this.cronner.addSingleJob(this.getTime() + deltaT, job);
    }

    public void deleteJob(Job aJob) {
        this.cronner.deleteJob(aJob);
    }

    public void logAt(long l, String string) {
        Cronner cronner = this.cronner;
        cronner.getClass();
        this.at(l, new Cronner.MsgJob(cronner, string));
    }

    public void logIn(long delaT, String string) {
        this.logAt(this.getTime() + delaT, string);
    }

    private void writeStats(boolean win) {
    }

    public static double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public static double normalToAbsMin(double value, double minimum) {
        if (value < 0.0) {
            return -Math.min(Math.abs(value), Math.abs(minimum));
        }
        return Math.min(Math.abs(value), Math.abs(minimum));
    }

    public void log(String msg) {
        if (timeFormatter == null) {
            timeFormatter = new DecimalFormat("0000");
        }
    }

    public String printDouble(double d) {
        return LoudAndProud.printStaticDouble(d);
    }

    public static String printStaticDouble(double d) {
        if (formatter == null) {
            formatter = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
        }
        return formatter.format(d);
    }

    public long timeToReach(DVektor target) {
        return this.timeToReach(this.getPosition(), target, this.getVelocity());
    }

    public long timeToReach(DVektor start, DVektor target, double vStart) {
        double d = start.getDistanceTo(target);
        double move = 0.0;
        double currentV = vStart;
        long t = 0L;
        while (move < d) {
            double restmove = d - move;
            if (restmove <= 3.0) {
                currentV = restmove;
            } else if (restmove <= currentV * (currentV + 1.0) / 4.0) {
                currentV -= 2.0;
            } else if (currentV < 8.0) {
                currentV += 1.0;
            }
            move += currentV;
            ++t;
        }
        return t;
    }

    public static Object printStaticDoubleDE(double d) {
        if (de_formatter == null) {
            de_formatter = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.GERMAN));
        }
        return de_formatter.format(d);
    }
}

