/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.targetting;

import alk.lap.LoudAndProud;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.TacticalLead;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import alk.lap.utils.LapUtils;
import java.awt.Color;
import robocode.util.Utils;

public class LinearTargeting
implements TargetStrategy {
    private static final double BEAM_ANGLE = 8.0;
    public static final String NAME = "LinT";
    private double fireEnergy = 3.0;
    LoudAndProud proud;
    private String name = "LinT";

    public String describe() {
        return this.name;
    }

    public TargetStrategy.StrategyType getType() {
        return TargetStrategy.StrategyType.MoveBased;
    }

    public double[] getFireAngleTo(int target, FireWave wave) {
        double angle = 0.0;
        if (target == 1) {
            double bearingToTarget = this.proud.getTacticLead().getEnemyBearing() - 180.0;
            double cosAlpha = Math.cos(Math.toRadians(180.0 - (wave.proudsHeadingAtEmission - bearingToTarget)));
            double distance = this.proud.getTacticLead().getEnemyDistance();
            double vTarget = this.getVProud(wave);
            double t = (2.0 * vTarget * distance * cosAlpha - Math.sqrt(Math.pow(2.0 * vTarget * distance * cosAlpha, 2.0) - 4.0 * (vTarget * vTarget - wave.bulletVelocity * wave.bulletVelocity) * distance * distance)) / (2.0 * (vTarget * vTarget - wave.bulletVelocity * wave.bulletVelocity));
            DVektor targetPosAtT = DVektor.add(wave.proudsPositionAtEmission, DVektor.scaleVector(DVektor.fromPolarCoord(wave.proudsHeadingAtEmission, vTarget), t));
            angle = wave.emittingPosition.getDirectionTo(targetPosAtT);
        } else {
            TacticalLead tLead = this.proud.getTacticLead();
            if (!tLead.isEnemySpotted()) {
                return LapUtils.toDArray(this.proud.getRadarHeading());
            }
            DVektor targetStartPosAtIteration = null;
            DVektor targetVAtIteration = null;
            DVektor gunnerPosition = null;
            double bearingToTarget = 0.0;
            long elapsedTime = 0L;
            double eHeading = tLead.getEnemyHeading();
            double eVelocity = this.getVEnemy(tLead);
            double enemyTurnRate = this.getEnemyTurnRate(tLead);
            double enemyAccelerationRate = this.getEnemyAccelerationRate(tLead);
            boolean found = false;
            targetStartPosAtIteration = tLead.getEnemyPos().copy();
            targetVAtIteration = DVektor.fromPolarCoord(eHeading, eVelocity);
            gunnerPosition = this.proud.getPosition();
            if (Utils.isNear((double)targetVAtIteration.getLength(), (double)0.0) && enemyAccelerationRate == 0.0) {
                found = true;
            }
            while (!found) {
                bearingToTarget = gunnerPosition.getDirectionTo(targetStartPosAtIteration);
                double targetMoveDirection = eVelocity > 0.0 ? targetVAtIteration.getDirection() : targetVAtIteration.getDirection() - 180.0;
                double cosAlpha = Math.cos(Math.toRadians(180.0 - (targetMoveDirection - bearingToTarget)));
                double distance = gunnerPosition.getDistanceTo(targetStartPosAtIteration);
                double targetVel = targetVAtIteration.getLength();
                double bulletVel = 20.0 - 3.0 * this.fireEnergy;
                double a = targetVel * targetVel - bulletVel * bulletVel;
                double b = 2.0 * bulletVel * bulletVel * (double)elapsedTime + 2.0 * targetVel * distance * cosAlpha;
                double c = distance * distance - Math.pow(bulletVel * (double)elapsedTime, 2.0);
                double tD = (b - Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * c)) / (2.0 * a);
                if (tD < 1.0) {
                    found = true;
                    targetStartPosAtIteration.add(DVektor.scaleVector(targetVAtIteration, tD));
                } else {
                    ++elapsedTime;
                    targetStartPosAtIteration.add(targetVAtIteration);
                    if (!this.proud.isInBorder(targetStartPosAtIteration)) {
                        found = true;
                    }
                    eHeading += enemyTurnRate;
                    if (Math.abs(eVelocity += enemyAccelerationRate) > 8.0) {
                        eVelocity = 8.0 * (double)this.signum(eVelocity);
                    }
                    targetVAtIteration = DVektor.fromPolarCoord(eHeading, eVelocity);
                }
                this.proud.getVc().drawPoint(targetStartPosAtIteration, "Prognosed enemy");
            }
            angle = gunnerPosition.getDirectionTo(targetStartPosAtIteration);
        }
        return LapUtils.toDArray(angle);
    }

    protected double getEnemyAccelerationRate(TacticalLead lead) {
        return lead.getEnemyAccRate();
    }

    protected double getEnemyTurnRate(TacticalLead lead) {
        return 0.0;
    }

    protected double getVEnemy(TacticalLead lead) {
        return lead.getEnemyVelocitiy();
    }

    protected double getVProud(FireWave wave) {
        return wave.proudsVelocityAtEmission;
    }

    public double getFireEnergy() {
        return this.fireEnergy;
    }

    public double getBeamAngle() {
        return 8.0;
    }

    public LinearTargeting setName(String name) {
        this.name = name;
        return this;
    }

    public LinearTargeting setFireEnergy(double fireEnergy) {
        this.fireEnergy = fireEnergy;
        this.setName(String.valueOf(this.describe()) + "-f" + LoudAndProud.printStaticDouble(fireEnergy));
        return this;
    }

    public Color getColorCode() {
        return Color.cyan;
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
    }

    public int signum(double d) {
        if (d == 0.0) {
            return 0;
        }
        if (d > 0.0) {
            return 1;
        }
        return -1;
    }
}

