/*
 * Decompiled with CFR 0.152.
 */
package rtk;

import java.awt.geom.Point2D;
import robocode.Rules;
import rtk.Aiming;
import rtk.Help;
import rtk.Tachikoma;

public class BulletEnemy {
    private double heading;
    private double x;
    private double y;
    private double power;
    private String ownerName;
    private String victimName;
    private boolean active = false;
    private long shotTime;
    private Point2D shotPosition;
    private double possibleAreaSize = 1.0;
    private Tachikoma robot;
    private double speed;
    private Aiming.AimTypeEnemy aiming = Aiming.AimTypeEnemy.LastSeenPlace;

    public BulletEnemy(double heading, double x, double y, double power, String ownerName, String victimName, boolean isActive, long shotTime, Tachikoma robot, double notUpdatedTimeSpan, Aiming.AimTypeEnemy aiming) {
        this.heading = heading;
        this.x = x;
        this.y = y;
        this.power = power;
        this.ownerName = ownerName;
        this.victimName = victimName;
        this.active = isActive;
        this.shotTime = shotTime;
        this.possibleAreaSize = notUpdatedTimeSpan;
        this.robot = robot;
        this.speed = Rules.getBulletSpeed((double)this.power);
        this.shotPosition = new Point2D.Double(this.x, this.y);
        this.aiming = aiming;
        this.tick();
    }

    public BulletEnemy(BulletEnemy b) {
        this.heading = b.heading;
        this.x = b.x;
        this.y = b.y;
        this.power = b.power;
        this.ownerName = b.ownerName;
        this.victimName = b.victimName;
        this.active = b.active;
        this.shotTime = b.shotTime;
        this.shotPosition = b.shotPosition;
        this.possibleAreaSize = b.possibleAreaSize;
        this.robot = b.robot;
        this.speed = b.speed;
        this.aiming = b.aiming;
    }

    public void tick() {
        if (this.isActive()) {
            this.x += Help.calcFromDirX(this.heading, this.speed);
            this.y += Help.calcFromDirY(this.heading, this.speed);
            if (this.x <= 0.0 || this.x >= (double)Tachikoma.FIELD_WIDTH || this.y <= 0.0 || this.y >= (double)Tachikoma.FIELD_HEIGHT) {
                this.setActive(false);
            }
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point2D getPos() {
        return new Point2D.Double(this.x, this.y);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getShotTime() {
        return this.shotTime;
    }

    public double getPossibleAreaSize() {
        return this.possibleAreaSize;
    }

    public double getSpeed() {
        return this.speed;
    }

    public Point2D getShotPosition() {
        return this.shotPosition;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getPower() {
        return this.power;
    }

    public Aiming.AimTypeEnemy getAiming() {
        return this.aiming;
    }
}

