/*
 * Decompiled with CFR 0.152.
 */
package rtk;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;
import rtk.Aiming;
import rtk.ArrayListCapped;
import rtk.BulletEnemy;
import rtk.Enemy;
import rtk.GravityPoint;
import rtk.Help;
import rtk.RobotData;

public class Tachikoma
extends AdvancedRobot {
    public static int FIELD_WIDTH;
    public static int FIELD_HEIGHT;
    public static int FIELD_SIZE_MAX;
    public static double TANK_SIZE;
    public static final double TANK_SIZE_EXTRA_COLLISIONS = 1.38;
    public static final double TANK_SIZE_EXTRA_WALLS = 10.0;
    private static final int MY_POS_LIST_CAP = 300;
    private static final int GOTO_POINT_CHANGE_FREQUENCY = 20;
    private static final int MAX_TURN_AT_SPEED = 67;
    private static final int TURN_LEFT_MAX_BEARING_ANGLE = 110;
    private static final int TURN_LEFT_WALL_CHECK_DISTANCE = 120;
    private static final int TURN_RIGHT_MAX_EXTRA_ANGLE_OVER = 40;
    private static final int TURN_RIGHT_MAX_EXTRA_ANGLE_UNDER = 0;
    private static final int TURN_RIGHT_WALL_CLEAR_ANGLE = 170;
    private static final int TURN_RIGHT_WALL_CHECK_DISTANCE = 300;
    private static final int MOVE_ONE_ON_ONE_PREDICT_IMAX = 30;
    private static final int MOVE_MELEE_LAST_NO_OF_PLACES_TO_BE_DANGEROUS = 3;
    private int scanDir = 1;
    public boolean radarFoundEveryoneFirst = false;
    private Point2D myPos;
    private Point2D myNextPos;
    private List<Point2D> myPosList = new ArrayListCapped<Point2D>(300);
    private List<RobotData> history = new ArrayListCapped<RobotData>(2);
    private double myVelocity;
    private double myMaxVelocity;
    public double myHeading;
    public int others = 0;
    private int myRotateDir = 0;
    private double turning = 0.0;
    public String name;
    private boolean fired = false;
    private Bullet hitMe = null;
    private List<Bullet> hitEnemy = new ArrayList<Bullet>();
    private Enemy target = null;
    private Aiming.AimType aimType = Aiming.AimType.LookAhead;
    private List<Bullet> bullets = new ArrayList<Bullet>();
    private Point2D goToPoint;
    private List<Point2D> movePredictList = new ArrayList<Point2D>();
    private Random random = new Random();
    private boolean left = true;
    private boolean changingLeft = false;
    private long changingLeftForBullet = 0L;
    private boolean stop = false;
    private double leftForced = 0.0;

    public void run() {
        this.Colour();
        FIELD_WIDTH = (int)this.getBattleFieldWidth();
        FIELD_HEIGHT = (int)this.getBattleFieldHeight();
        FIELD_SIZE_MAX = (int)Help.calcDiagonal(FIELD_WIDTH, FIELD_HEIGHT);
        TANK_SIZE = (int)Help.calcDiagonal(this.getWidth(), this.getHeight());
        this.setAdjustGunForRobotTurn(false);
        this.setAdjustRadarForGunTurn(false);
        this.setAdjustRadarForRobotTurn(false);
        this.myMaxVelocity = 8.0;
        this.name = this.getName();
        while (true) {
            RobotData d = new RobotData(this.myVelocity, this.myHeading);
            this.history.add(d);
            this.myVelocity = this.getVelocity();
            this.myHeading = this.getHeading();
            this.myPos = new Point2D.Double(this.getX(), this.getY());
            this.myNextPos = !this.isOneOnOne() ? this.Pos(-1) : Help.calcPos(this.myPos, this.myHeading, this.myVelocity);
            this.myPosList.add(this.myPos);
            this.others = this.getOthers();
            Enemy.Tick(this, this.fired, this.hitMe, this.hitEnemy, this.getTime(), this.getRoundNum());
            this.fired = false;
            this.hitMe = null;
            this.hitEnemy.clear();
            this.radar();
            this.move();
            this.target();
            this.execute();
        }
    }

    private void radar() {
        double angle = Double.POSITIVE_INFINITY;
        Enemy FarthestEnemy = null;
        if (this.others == Enemy.getList().size() || this.radarFoundEveryoneFirst) {
            this.radarFoundEveryoneFirst = true;
            Enemy farthestEnemyLeft = null;
            Enemy farthestEnemyRight = null;
            double farthestAngleLeft = 0.0;
            double farthestAngleRight = 0.0;
            for (Enemy e : Enemy.getList()) {
                double angleToE = Help.calcDirection(this.myNextPos, e.getData(0).getPosition());
                double angleDiff = Help.calcAngleDiff(this.getRadarHeading(), angleToE);
                if (angleDiff < farthestAngleLeft) {
                    farthestEnemyLeft = e;
                    farthestAngleLeft = angleDiff;
                    continue;
                }
                if (!(angleDiff > farthestAngleRight)) continue;
                farthestEnemyRight = e;
                farthestAngleRight = angleDiff;
            }
            if (farthestAngleLeft == 0.0) {
                this.scanDir = -1;
                FarthestEnemy = farthestEnemyRight;
            } else if (farthestAngleRight == 0.0) {
                this.scanDir = 1;
                FarthestEnemy = farthestEnemyLeft;
            }
        }
        if (FarthestEnemy != null) {
            Point2D pos = FarthestEnemy.getData(0).getPosition();
            double ang = Math.abs(Help.calcAngleDiff(this.getRadarHeading(), Help.calcDirection(this.myNextPos, pos)));
            if (ang < 45.0) {
                angle = ang + 22.5;
            }
        }
        this.setTurnRadarLeft((double)this.scanDir * angle);
        if (this.target == null && angle > 45.0) {
            this.setTurnGunLeft((double)this.scanDir * (angle - 45.0));
        } else {
            this.setTurnGunLeft(0.0);
        }
    }

    private void target() {
        double disMult;
        double hr;
        int fireTime = (int)Math.ceil(this.getGunHeat() / this.getGunCoolingRate());
        if (!this.isOneOnOne()) {
            int i = 0;
            while (i < Enemy.getList().size()) {
                Enemy e = Enemy.getList().get(i);
                e.calcTarPos(this.aimType, this.myNextPos, fireTime, 2.0);
                e.setFiringAngleMultiplyer(0.0);
                double firingAngle = e.getFiringAngle();
                int j = 0;
                while (j < i) {
                    Enemy e2 = Enemy.getList().get(j);
                    double firingAngleOther = e2.getFiringAngle();
                    double dif = Math.abs(Help.calcAngleDiff(firingAngle, firingAngleOther)) + 1.0;
                    e.setFiringAngleMultiplyer(e.getFiringAngleMultiplyer() + 1.0 / dif);
                    e2.setFiringAngleMultiplyer(e2.getFiringAngleMultiplyer() + 1.0 / dif);
                    ++j;
                }
                ++i;
            }
        }
        Enemy t = null;
        if (!this.isOneOnOne()) {
            if (this.target == null) {
                t = Enemy.getClosestEnemy(this.myPos);
            }
        } else {
            List<Enemy> eList = Enemy.getList();
            if (eList.size() > 0) {
                t = eList.get(0);
            }
        }
        double largestHr = Double.MIN_VALUE;
        for (Enemy e : Enemy.getList()) {
            int dis = Aiming.getClosestDistance(this.myNextPos.distance(e.getData(0).getPosition()));
            hr = e.getBestAimingHitRate(dis);
            if (!this.isOneOnOne()) {
                if (hr <= Double.MIN_NORMAL) {
                    hr = Double.MIN_NORMAL;
                }
                disMult = Math.pow(1.0 / this.myNextPos.distance(e.getData(0).getPosition()), 4.0) * 100000.0;
                hr *= disMult;
                double energyMult = 1.0 / (e.getData(0).getEnergy() + 1.0) * 10.0;
                hr += hr * energyMult;
                double firingAngleMult = e.getFiringAngleMultiplyer() * 10.0;
                hr *= 1.0 + firingAngleMult;
            }
            if (!(hr - largestHr > largestHr / 100.0)) continue;
            largestHr = hr;
            t = e;
        }
        if (this.target != t && t != null) {
            this.target = t;
            Enemy.setRandomPositions(this.myNextPos);
        }
        if (this.others == 0) {
            this.target = null;
        }
        if (this.target != null) {
            this.aimType = this.calcAimType(this.target);
            double power = 2.0;
            if (!this.isOneOnOne()) {
                if (this.target.getData(0).getPosition().distance(this.myNextPos) <= 100.0 || this.target.getFiringAngleMultiplyer() > 1.0) {
                    power = 3.0;
                }
            } else {
                int aimDis = Aiming.getClosestDistance(this.myNextPos.distance(this.target.getData(0).getPosition()));
                hr = this.target.getBestAimingHitRate(aimDis);
                disMult = Math.pow(1.0 / this.myNextPos.distance(this.target.getData(0).getPosition()), 2.0) * 100000.0;
                power = Math.min(Math.max((hr *= disMult) * 30.0 * 10.0, 2.0), 3.0);
            }
            if (this.getEnergy() <= 10.0) {
                power = Math.max((this.getEnergy() - 0.1) / 10.0, 0.1);
                power = Math.min(power, 0.5);
            }
            if (this.isOneOnOne() && Rules.getBulletDamage((double)power) > this.target.getData(0).getEnergy()) {
                power = this.target.getData(0).getEnergy() / 4.0;
            }
            Point2D tarPos = this.target.calcTarPos(this.aimType, this.myNextPos, fireTime, power);
            double dir = Help.calcDirection(this.myNextPos, tarPos);
            double extra = 0.0;
            extra = this.getTurnRemaining() >= 0.0 ? -Math.min(Math.abs(this.getTurnRemaining()), Rules.getTurnRate((double)this.myVelocity)) : Math.min(Math.abs(this.getTurnRemaining()), Rules.getTurnRate((double)this.myVelocity));
            double relDir = Help.calcAngleDiff(dir, this.getGunHeading() - extra);
            this.setTurnGunLeft(Math.min(relDir, 20.0));
            if (Math.abs(this.getGunTurnRemaining()) <= 20.0 && (double)fireTime <= this.getGunCoolingRate()) {
                this.fired = true;
                Bullet b = this.setFireBullet(power);
                Enemy.setRandomPositions(this.myNextPos);
                this.bullets.add(b);
            }
        }
    }

    private Aiming.AimType calcAimType(Enemy target) {
        if (target.getHitRateSize(Aiming.AimType.LookAhead, Aiming.PREDICT_POS_DATA_TIME_DISTANCES.length - 1) > 10) {
            int distance = Aiming.getClosestDistance(this.myNextPos.distance(target.getData(0).getPosition()));
            Aiming.AimType at = target.getBestAiming(distance);
            if (at == Aiming.AimType.LastSeenPlace && target.getHitRateTime(at, distance) < 0.01 && Math.abs(target.getHitRateTime(at, distance) - target.getHitRateTime(Aiming.AimType.Random, distance)) < target.getHitRateTime(at, distance) / 5.0) {
                at = Aiming.AimType.Random;
            }
            return at;
        }
        return Aiming.AimType.LookAhead;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy.scan(e, this, this.getTime());
    }

    public void onBulletHit(BulletHitEvent e) {
        this.hitEnemy.add(e.getBullet());
        this.removeInactiveBullets();
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Enemy enemy = Enemy.getFromName(e.getHitBullet().getName());
        if (enemy != null) {
            enemy.shotMe(e.getHitBullet(), true);
        }
        this.removeInactiveBullets();
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.removeInactiveBullets();
    }

    private void removeInactiveBullets() {
        int i = this.bullets.size() - 1;
        while (i >= 0) {
            Bullet b = this.bullets.get(i);
            if (b != null) {
                if (!b.isActive()) {
                    this.bullets.remove(i);
                }
            } else {
                this.bullets.remove(i);
            }
            --i;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.hitMe = e.getBullet();
        Enemy enemy = Enemy.getFromName(e.getName());
        if (enemy != null) {
            enemy.shotMe(e.getBullet(), false);
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        Enemy enemy = Enemy.getFromName(e.getName());
        if (!this.isOneOnOne()) {
            double dir = Help.calcDirection(this.myPos, enemy.getData(0).getPosition());
            dir = (dir + 180.0) % 360.0;
            int dis = (int)(TANK_SIZE * 2.0);
            this.goToPoint = this.fixGoToPointForWalls(Help.calcPos(this.myPos, dir, dis));
        } else {
            this.changeDir();
        }
    }

    public void onHitWall(HitWallEvent event) {
        if (!this.isOneOnOne()) {
            this.goToPoint = this.getGoToPointMelee();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy.remove(Enemy.getIDFromName(e.getName()));
    }

    public void onDeath(DeathEvent e) {
        Enemy.removeAll();
    }

    public void onWin(WinEvent event) {
    }

    public void onRoundEnded(RoundEndedEvent e) {
        Enemy.removeAll();
    }

    public void onBattleEnded(BattleEndedEvent event) {
    }

    private void Colour() {
        this.setColors(Color.white, Color.red, Color.red, Color.red, Color.red);
    }

    public boolean isOneOnOne() {
        return this.others == 1;
    }

    public Point2D Pos() {
        return this.myPos;
    }

    public Point2D Pos(int t) {
        if (t >= 0) {
            if (t <= 0) {
                return this.myPos;
            }
            if (t >= this.myPosList.size()) {
                return this.myPosList.get(this.myPosList.size() - 1);
            }
            return this.myPosList.get(this.myPosList.size() - 1 - t);
        }
        if (-t >= this.movePredictList.size()) {
            if (this.movePredictList.size() == 0) {
                return this.myPos;
            }
            return this.movePredictList.get(this.movePredictList.size() - 1);
        }
        return this.movePredictList.get(-t - 1);
    }

    private RobotData history(int t) {
        if (t <= 0) {
            return null;
        }
        if (t - 1 >= this.history.size()) {
            return this.history.get(this.history.size() - 1);
        }
        return this.history.get(t - 1);
    }

    private void move() {
        if (!this.isOneOnOne()) {
            this.moveMelee();
        } else {
            this.moveOneOnOne();
        }
    }

    private void moveMelee() {
        if (this.goToPoint == null || this.getTime() % 20L == 0L) {
            this.goToPoint = this.getGoToPointMelee();
        }
        if (this.goToPoint != null && this.goToPoint != this.myPos) {
            this.movePredictList.clear();
            this.movePredictList = this.createGoToPointPredictList(this.myPos, this.goToPoint, this.myVelocity, this.myHeading);
            double dir = Help.calcDirection(this.myPos, this.goToPoint);
            double dis = this.goToPoint.distance(this.myPos);
            double[] data = new double[2];
            data = this.getMoveBearing(dir, this.myHeading, dis, this.getTurnRemaining());
            double bearing = data[0];
            boolean forward = data[1] >= 0.0;
            double d = this.getMoveDistance(this.myPos, this.myVelocity, this.myHeading, dis, bearing);
            this.setTurnLeft(Math.abs(bearing));
            if (d == 0.0) {
                this.setAhead(0.0);
                this.setBack(0.0);
            } else if (forward) {
                this.setAhead(dis);
            } else {
                this.setBack(dis);
            }
            if (this.myPos.distance(this.goToPoint) <= 8.0) {
                this.goToPoint = null;
            }
        }
    }

    private double[] getMoveBearing(double dir, double heading, double dis, double turnRemaining) {
        double[] data = new double[2];
        if (dis > 8.0) {
            double bearing = Help.calcAngleDiff(heading, dir);
            boolean forward = true;
            if (bearing < 0.0) {
                bearing = Math.abs(bearing);
                forward = true;
            } else {
                bearing = 180.0 - bearing;
                forward = false;
            }
            data[0] = bearing -= Math.min(Math.abs(turnRemaining) + 1.0, Rules.getTurnRate((double)this.myVelocity));
            data[1] = forward ? 1 : -1;
        } else {
            data[0] = 0.0;
            data[1] = 1.0;
        }
        return data;
    }

    private double getMoveDistance(Point2D p, double velocity, double heading, double dis, double bearing) {
        if (Math.abs(bearing) > 67.0 || Help.calcWallAheadDis(p, velocity, heading, true) <= TANK_SIZE || dis <= 8.0) {
            return 0.0;
        }
        return dis;
    }

    private List<Point2D> createGoToPointPredictList(Point2D p, Point2D endP, double velocity, double heading) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        double ahead = 0.0;
        double back = 0.0;
        double tLeft = 0.0;
        double dis = endP.distance(p);
        int i = 0;
        int iMax = 300;
        while (dis > 8.0 && i < iMax) {
            ++i;
            double dir = Help.calcDirection(p, endP);
            dis = endP.distance(p);
            double[] data = new double[2];
            data = this.getMoveBearing(dir, heading, dis, 0.0);
            double bearing = data[0];
            boolean forward = data[1] >= 0.0;
            double d = this.getMoveDistance(p, velocity, heading, dis, bearing);
            tLeft = bearing;
            if (d == 0.0) {
                ahead = 0.0;
                back = 0.0;
            } else if (forward) {
                ahead = dis;
                back = 0.0;
            } else {
                back = dis;
                ahead = 0.0;
            }
            double[] out = this.emulateMovement(ahead, back, tLeft, velocity, heading, 8.0);
            velocity = out[0];
            heading = out[1];
            for (Enemy e : Enemy.getList()) {
                Point2D ep = e.getData(-i).getPosition();
                if (!(ep.distance(p) <= TANK_SIZE)) continue;
                velocity = 0.0;
                i = iMax;
            }
            p = this.fixGoToPointForWalls(Help.calcPos(p, heading, velocity));
            list.add(p);
        }
        return list;
    }

    private double[] emulateMovement(double ahead, double back, double tLeft, double velocity, double heading, double maxVelocity) {
        double accel = 0.0;
        if (velocity >= 0.0) {
            if (ahead > 0.0 || back == 0.0) {
                if (ahead >= velocity * 2.0 + velocity / 2.0 && ahead != 0.0) {
                    accel = 1.0;
                } else if (velocity <= 2.0) {
                    accel = 0.0;
                    velocity = 0.0;
                } else {
                    accel = Math.max(-2.0, -velocity);
                }
            } else {
                accel = -2.0;
            }
        } else if (back > 0.0 || ahead == 0.0) {
            if (back >= -velocity * 2.0 + -velocity / 2.0 && back != 0.0) {
                accel = -1.0;
            } else if (velocity >= -2.0) {
                accel = 0.0;
                velocity = 0.0;
            } else {
                accel = Math.min(2.0, -velocity);
            }
        } else {
            accel = 2.0;
        }
        heading -= Math.min(Math.abs(tLeft), Math.abs(Rules.getTurnRate((double)velocity)));
        velocity += accel;
        velocity = velocity >= 0.0 ? Math.min(velocity, maxVelocity) : Math.max(velocity, -maxVelocity);
        double[] out = new double[]{velocity, heading};
        return out;
    }

    public Point2D fixGoToPointForWalls(Point2D p) {
        if (p.getX() < TANK_SIZE / 1.5) {
            p.setLocation(TANK_SIZE / 1.5, p.getY());
        } else if (p.getX() > (double)FIELD_WIDTH - TANK_SIZE / 1.5) {
            p.setLocation((double)FIELD_WIDTH - TANK_SIZE / 1.5, p.getY());
        }
        if (p.getY() < TANK_SIZE / 1.5) {
            p.setLocation(p.getX(), TANK_SIZE / 1.5);
        } else if (p.getY() > (double)FIELD_HEIGHT - TANK_SIZE / 1.5) {
            p.setLocation(p.getX(), (double)FIELD_HEIGHT - TANK_SIZE / 1.5);
        }
        return p;
    }

    private List<GravityPoint> createGravityPoints() {
        ArrayList<GravityPoint> gravityPoints = new ArrayList<GravityPoint>();
        for (Enemy e : Enemy.getList()) {
            double hr;
            double energy = e.getData(0).getEnergy();
            if (energy < 0.1) {
                energy = 0.1;
            }
            if (Utils.isNear((double)(hr = e.getBestAimingHitRate(0)), (double)0.0)) {
                hr = 1.0E-5;
            }
            double power = energy / 100.0;
            GravityPoint gravityPoint = new GravityPoint(e.getData(0).getPosition(), power *= 1.0 / hr / 10000.0);
            gravityPoints.add(gravityPoint);
        }
        GravityPoint gravityPoint = new GravityPoint(new Point2D.Double(FIELD_WIDTH / 2, FIELD_HEIGHT / 2), 0.001);
        gravityPoints.add(gravityPoint);
        int i = 0;
        while (i < 3) {
            gravityPoint = new GravityPoint(this.Pos(i), 0.001);
            gravityPoints.add(gravityPoint);
            ++i;
        }
        return gravityPoints;
    }

    private Point2D getGoToPointMelee() {
        double value = 0.0;
        List<GravityPoint> gravityPoints = this.createGravityPoints();
        double smallest = Double.MAX_VALUE;
        Point2D smallestP = this.myNextPos;
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 5) {
                double dir = (double)(i * 36) + this.random.nextDouble() * 36.0;
                Point2D point = Help.calcPos(this.myNextPos, dir, (double)(j + 1) * 32.0);
                point = this.fixGoToPointForWalls(point);
                List<Point2D> predictList = this.createGoToPointPredictList(this.myNextPos, point, this.myVelocity, this.myHeading);
                Point2D p = point;
                if (predictList.size() > 0) {
                    p = predictList.get(predictList.size() - 1);
                }
                value = 0.0;
                for (GravityPoint gravityPoint : gravityPoints) {
                    double dis = gravityPoint.getPoint().distance(p);
                    if (Utils.isNear((double)dis, (double)0.0)) {
                        dis = 1.0E-6;
                    }
                    double pow = gravityPoint.getPower();
                    value += (1.0 + pow) * (1.0 / Math.pow(dis, 1.0));
                }
                if (value < smallest) {
                    smallest = value;
                    smallestP = point;
                }
                ++j;
            }
            ++i;
        }
        return smallestP;
    }

    public boolean checkForFutureBulletCollisions(List<Point2D> moveList, Enemy e, long bulletToIgnoreShotTime, long time, double getGunCoolingRate) {
        boolean hit = false;
        ArrayList<BulletEnemy> bulletList = new ArrayList<BulletEnemy>(e.getBullets());
        double gunHeat = e.getData(0).getGunHeat();
        int i = 0;
        while (i < moveList.size()) {
            Point2D p = moveList.get(i);
            if (gunHeat <= 0.0) {
                double power = 2.0;
                if (bulletList.size() > 0) {
                    power = ((BulletEnemy)bulletList.get(bulletList.size() - 1)).getPower();
                }
                Aiming.AimTypeEnemy[] aimTypeEnemyArray = Aiming.AimTypeEnemy.values();
                int n = aimTypeEnemyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Aiming.AimTypeEnemy aiming = aimTypeEnemyArray[n2];
                    Point2D tarPos = this.calcTarPos(aiming, e.getData(-i).getPosition(), power);
                    double h = Help.calcDirection(e.getData(-i).getPosition(), tarPos);
                    Point2D pos = e.getData(-i).getPosition();
                    BulletEnemy be = new BulletEnemy(h, pos.getX(), pos.getY(), power, e.name, this.name, true, time + (long)i, this, 1.0, aiming);
                    bulletList.add(be);
                    ++n2;
                }
                gunHeat = Rules.getGunHeat((double)power);
            }
            gunHeat -= getGunCoolingRate;
            for (BulletEnemy be : bulletList) {
                BulletEnemy b;
                if (be.getAiming() != e.getAimingMethod() && be.getAiming() != e.getAimingMethodLast() || (b = new BulletEnemy(be)).getShotTime() == bulletToIgnoreShotTime) continue;
                int j = 0;
                while (j < i) {
                    b.tick();
                    ++j;
                }
                if (!(p.distance(b.getPos()) <= TANK_SIZE)) continue;
                hit = true;
                break;
            }
            if (hit) break;
            ++i;
        }
        return hit;
    }

    private void moveOneOnOne() {
        List<Enemy> list = Enemy.getList();
        if (list.size() > 0) {
            Enemy e = list.get(0);
            this.leftForced = 0.0;
            this.stop = false;
            List<Point2D> l = this.predictMoveOneOnOne(e, false, this.leftForced);
            this.movePredictList.clear();
            this.movePredictList = l;
            this.decideOneOnOneDirection(e);
            double[] out = this.moveOneOnOneCalc(e, this.myPos, this.myVelocity, this.myHeading, this.myRotateDir, this.changingLeft, this.left, this.myMaxVelocity, this.turning, this.leftForced);
            if (out[0] == 1.0 || out[0] == 2.0) {
                this.setAhead(out[1]);
            }
            if (out[0] == 0.0 || out[0] == 2.0) {
                this.setBack(out[2]);
            }
            this.setTurnLeft(Math.abs(out[3]));
            this.myRotateDir = (int)out[4];
            this.changingLeft = out[5] == 1.0;
            this.left = out[6] == 1.0;
            this.myMaxVelocity = out[7];
            this.turning = out[8];
            this.leftForced = out[9];
            this.setMaxVelocity(this.myMaxVelocity);
        }
    }

    private List<Point2D> predictMoveOneOnOne(Enemy e, boolean reverse, double hardLeft) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        double ahead = 0.0;
        double back = 0.0;
        double tLeft = 0.0;
        int rotateDir = this.myRotateDir;
        boolean changingLeftt = this.changingLeft;
        boolean leftt = this.left;
        double maxVelocity = this.myMaxVelocity;
        double turningg = this.turning;
        Point2D pos = this.myPos;
        double velocity = this.myVelocity;
        double heading = this.myHeading;
        if (reverse) {
            changingLeftt = true;
            leftt = !leftt;
            rotateDir = -rotateDir;
        }
        int i = 0;
        while (i < 30) {
            double[] out = this.moveOneOnOneCalc(e, pos, velocity, heading, rotateDir, changingLeftt, leftt, maxVelocity, turningg, hardLeft);
            if (out[0] == 1.0 || out[0] == 2.0) {
                ahead = out[1];
            }
            if (out[0] == 0.0 || out[0] == 2.0) {
                back = out[2];
            }
            tLeft = Math.abs(out[3]);
            rotateDir = (int)out[4];
            changingLeftt = out[5] == 1.0;
            leftt = out[6] == 1.0;
            maxVelocity = out[7];
            turningg = out[8];
            hardLeft = out[9];
            double[] out2 = this.emulateMovement(ahead, back, tLeft, velocity, heading, maxVelocity);
            velocity = out2[0];
            heading = out2[1];
            pos = Help.calcPos(pos, heading, velocity);
            list.add(pos);
            ++i;
        }
        return list;
    }

    private void changeDir() {
        this.changingLeft = true;
        this.left = !this.left;
        this.myRotateDir = -this.myRotateDir;
    }

    private double[] moveOneOnOneCalc(Enemy e, Point2D pos, double velocity, double heading, int rotateDir, boolean changingLeftt, boolean leftt, double maxVelocity, double turningg, double hardLeft) {
        boolean tooClose;
        int aheadOrBack = 1;
        double ahead = 0.0;
        double back = 0.0;
        double tLeft = 0.0;
        Point2D ePos = e.getData(0).getPosition();
        double meEDir = Help.calcDirection(pos, ePos);
        double bearing = Help.calcAngleDiff(meEDir, heading);
        if (rotateDir == 0) {
            rotateDir = bearing >= 0.0 ? 1 : -1;
        }
        boolean tooSharp = Math.abs(Help.calcAngleDiff(meEDir, heading * (double)rotateDir)) < 30.0;
        boolean bl = tooClose = pos.distance(ePos) < 200.0;
        if (tooSharp || tooClose) {
            if ((leftt || !(turningg > Rules.getTurnRate((double)velocity))) && (tooClose && this.Pos(-10).distance(ePos) <= pos.distance(e.getData(-10).getPosition()) || tooSharp) && !changingLeftt) {
                changingLeftt = true;
                leftt = !leftt;
                rotateDir = -rotateDir;
            }
        } else if (!tooSharp || !tooClose) {
            changingLeftt = false;
        }
        double angle = 0.0;
        Rectangle2D.Double rect = new Rectangle2D.Double(TANK_SIZE / 2.0, TANK_SIZE / 2.0, (double)FIELD_WIDTH - TANK_SIZE, (double)FIELD_HEIGHT - TANK_SIZE);
        if (leftt) {
            turningg = 0.0;
            if (rotateDir < 0) {
                bearing += 180.0;
            }
            angle = bearing > 110.0 ? Math.max(bearing - 90.0, 0.0) : 0.0;
            boolean ok = true;
            int imax = (int)Rules.getTurnRate((double)this.myVelocity);
            int i = (int)angle;
            while (i < imax) {
                if (!rect.contains(Help.calcPos(pos, (heading - angle + 360.0) % 360.0, 120 * rotateDir))) {
                    angle += 1.0;
                    if (i >= imax - 1) {
                        ok = false;
                    }
                } else {
                    ok = true;
                }
                ++i;
            }
            maxVelocity = !ok ? Math.max(maxVelocity - 2.0, 0.0) : Math.min(maxVelocity + 1.0, 8.0);
            if (rotateDir > 0) {
                ahead = !this.stop ? 100.0 : 0.0;
                aheadOrBack = 1;
            } else if (rotateDir < 0) {
                back = !this.stop ? 100.0 : 0.0;
                aheadOrBack = 0;
            }
        } else {
            maxVelocity = 8.0;
            if (turningg > Rules.getTurnRate((double)velocity)) {
                angle = Math.min(turningg, Rules.getTurnRate((double)velocity));
                turningg -= Rules.getTurnRate((double)velocity);
            } else {
                turningg = 0.0;
                angle = 0.0;
                boolean wallHit = false;
                if (!rect.contains(Help.calcPos(pos, heading, 20 * rotateDir))) {
                    wallHit = true;
                }
                boolean timeToTurn = false;
                if ((rotateDir > 0 && Math.abs(bearing) > 130.0 || rotateDir < 0 && Math.abs(bearing) < 50.0) && (!(pos.distance(ePos) < 200.0) || !(Help.calcPos(pos, heading, 80.0 * (double)rotateDir).distance(e.getData(-10).getPosition()) > pos.distance(e.getData(-10).getPosition())))) {
                    timeToTurn = true;
                }
                if (timeToTurn || wallHit) {
                    ahead = 0.0;
                    back = 0.0;
                    aheadOrBack = 2;
                    turningg = timeToTurn ? (rotateDir > 0 ? Math.abs(Help.calcAngleDiff((meEDir + 90.0) % 360.0, heading)) - 0.0 : Math.abs(Help.calcAngleDiff((meEDir + 90.0) % 360.0, (heading + 180.0) % 360.0)) - 0.0) : 170.0;
                    rotateDir = -rotateDir;
                    while (!rect.contains(Help.calcPos(pos, heading - turningg, 300 * rotateDir))) {
                        turningg -= 1.0;
                    }
                } else if (rotateDir > 0) {
                    ahead = !this.stop ? 100.0 : 0.0;
                    aheadOrBack = 1;
                } else if (rotateDir < 0) {
                    back = !this.stop ? 100.0 : 0.0;
                    aheadOrBack = 0;
                }
            }
        }
        tLeft = Math.abs(angle);
        if (hardLeft > 0.0) {
            hardLeft -= 1.0;
            tLeft = 100.0;
        }
        double[] out = new double[]{aheadOrBack, ahead, back, tLeft, rotateDir, changingLeftt ? 1 : 0, leftt ? 1 : 0, maxVelocity, turningg, hardLeft};
        return out;
    }

    private void decideOneOnOneDirection(Enemy e) {
        int reverse = 0;
        long time = this.getTime();
        double getGunCoolingRate = this.getGunCoolingRate();
        double closest1 = 0.0;
        double closest2 = 0.0;
        BulletEnemy closestBe1 = null;
        BulletEnemy closestBe2 = null;
        double nextClosest = 0.0;
        for (BulletEnemy be : e.getBullets()) {
            double dis;
            double travDis;
            if (!be.isActive() || be.getAiming() != e.getAimingMethod() && be.getAiming() != e.getAimingMethodLast() || !((travDis = be.getSpeed() * (double)(time - be.getShotTime())) <= (dis = be.getShotPosition().distance(this.myPos)) + TANK_SIZE * 2.0)) continue;
            if (travDis > closest1) {
                closest1 = travDis;
                closestBe1 = be;
                continue;
            }
            if (travDis > closest2) {
                closest2 = travDis;
                closestBe2 = be;
                continue;
            }
            if (!(travDis > nextClosest)) continue;
            nextClosest = travDis;
        }
        int hit = 0;
        if (closestBe1 != null) {
            BulletEnemy b1 = new BulletEnemy(closestBe1);
            double dis = b1.getShotPosition().distance(this.myPos) - closest1;
            int timeToHit = (int)(dis / Rules.getBulletSpeed((double)b1.getSpeed()));
            double extra = b1.getPossibleAreaSize() * Rules.getBulletSpeed((double)b1.getSpeed());
            int i = 0;
            while (i < timeToHit) {
                b1.tick();
                if (b1.getPos().distance(this.Pos(-i)) - extra <= TANK_SIZE) {
                    hit = 1;
                }
                ++i;
            }
            if (closestBe2 != null) {
                BulletEnemy b2 = new BulletEnemy(closestBe2);
                dis = b2.getShotPosition().distance(this.myPos) - closest2;
                timeToHit = (int)(dis / Rules.getBulletSpeed((double)b2.getSpeed()));
                extra = b2.getPossibleAreaSize() * Rules.getBulletSpeed((double)b2.getSpeed());
                int i2 = 0;
                while (i2 < timeToHit) {
                    b2.tick();
                    if (b2.getPos().distance(this.Pos(-i2)) - extra <= TANK_SIZE) {
                        hit = 2;
                    }
                    ++i2;
                }
            }
            if (hit > 0) {
                List<Point2D> moveList = this.predictMoveOneOnOne(e, true, this.leftForced);
                if (!this.checkForFutureBulletCollisions(moveList, e, -1L, time, getGunCoolingRate)) {
                    reverse = 1;
                    if (closestBe1.getPos().distance(this.myPos) / closestBe1.getSpeed() > 10.0) {
                        if (reverse == 0) {
                            moveList = this.movePredictList;
                        }
                        if (this.checkForFutureBulletCollisions(moveList, e, closestBe1.getShotTime(), time, getGunCoolingRate)) {
                            reverse = 2;
                        }
                    }
                } else {
                    double t = b1.getPos().distance(this.myPos) / b1.getSpeed();
                    moveList = this.predictMoveOneOnOne(e, false, t);
                    if (!this.checkForFutureBulletCollisions(moveList, e, -1L, time, getGunCoolingRate)) {
                        this.leftForced = t;
                    } else {
                        moveList = this.predictMoveOneOnOne(e, true, t);
                        if (!this.checkForFutureBulletCollisions(moveList, e, -1L, time, getGunCoolingRate)) {
                            this.leftForced = t;
                            reverse = 1;
                        }
                    }
                }
            }
        }
        if (reverse == 1 && time - this.changingLeftForBullet > 15L && this.turning <= 0.0) {
            this.changeDir();
            this.changingLeftForBullet = time;
        }
        if (reverse == 2) {
            this.stop = true;
        }
    }

    public Point2D calcTarPos(Aiming.AimTypeEnemy aimType, Point2D shotPos, double power) {
        int bTime;
        Point2D tarPos = this.calcPositionFromAiming(aimType, 0, 2);
        double bSpeed = Rules.getBulletSpeed((double)power);
        int time = bTime = (int)Math.round(shotPos.distance(tarPos) / bSpeed);
        int i = 0;
        while (i < time) {
            time = bTime = (int)Math.round(shotPos.distance(tarPos) / bSpeed);
            tarPos = this.calcPositionFromAiming(aimType, time, 2);
            ++i;
        }
        return tarPos;
    }

    private Point2D calcPositionFromAiming(Aiming.AimTypeEnemy aimType, int time, int howFarInPast) {
        Point2D p = this.myPos;
        if (aimType == Aiming.AimTypeEnemy.LastSeenPlace) {
            p = this.Pos(howFarInPast);
        } else if (aimType == Aiming.AimTypeEnemy.LookAheadBasic) {
            p = Help.calcPos(this.Pos(howFarInPast), this.history(howFarInPast).getHeading(), this.history(howFarInPast).getVelocity() * (double)time);
        } else if (aimType == Aiming.AimTypeEnemy.LookAhead) {
            p = this.Pos(-time);
        }
        return p;
    }
}

