/*
 * Decompiled with CFR 0.152.
 */
package gjr;

import gjr.EnemiesTrackingStrategy;
import gjr.Enemy;
import gjr.RobocodeUtils;
import gjr.StrategyRobot;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class CircularTargetingStrategy
extends EnemiesTrackingStrategy {
    protected final Map enemies = new HashMap();

    public CircularTargetingStrategy(StrategyRobot robot) {
        this.setRobot(robot);
    }

    public void execute() {
        StrategyRobot robot = this.getRobot();
        Enemy closest = this.getClosestEnemy();
        if (closest != null) {
            double myX = robot.getX();
            double myY = robot.getY();
            double closestX = closest.getX();
            double closestY = closest.getY();
            double distance = Point2D.Double.distance(myX, myY, closestX, closestY);
            double firePower = CircularTargetingStrategy.calculateFirepower(distance);
            Point2D.Double closestPosition = new Point2D.Double(closestX, closestY);
            for (int i = 0; i < 10; ++i) {
                long nextTime = (int)Math.round(Point2D.Double.distance(myX, myY, closestPosition.x, closestPosition.y) / (20.0 - 3.0 * firePower));
                long time = robot.getTime() + nextTime;
                closestPosition = closest.guessPosition(time);
            }
            double gunOffset = robot.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(closestPosition.y - myY, closestPosition.x - myX));
            robot.setTurnGunLeftRadians(RobocodeUtils.normaliseBearing(gunOffset));
            robot.setFire(firePower);
        }
    }

    private static double calculateFirepower(double distance) {
        double firePower = 400.0 / distance;
        firePower = firePower > 4.0 ? 4.0 : firePower;
        firePower = firePower < 0.1 ? 0.1 : firePower;
        return firePower;
    }
}

