/*
 * Decompiled with CFR 0.152.
 */
package spin;

import spin.MathVector;
import spin.PhysicPoint;
import spin.RoboMath;

public class PredictedBullet
extends PhysicPoint {
    private double power;
    private long updatedAt;
    private long firedAt;
    private long tickCount = 1L;

    public PredictedBullet(double power, double fromX, double fromY, double toX, double toY, long time) {
        super(fromX, fromY, 0.0, 0.0);
        this.setPower(power);
        this.setVelocity(new MathVector(toX - fromX, toY - fromY).norm().mul(RoboMath.getBulletSpeed(power)));
        this.updatedAt = time;
        this.firedAt = time;
    }

    public PredictedBullet(double power, MathVector from, MathVector to, long time) {
        super(from.getX(), from.getY(), 0.0, 0.0);
        this.setPower(power);
        this.setVelocity(to.sub(from).norm().mul(RoboMath.getBulletSpeed(power)));
        this.updatedAt = time;
        this.firedAt = time;
    }

    public void update(long time) {
        this.setCoords(this.add(this.getVelocity().mul(time - this.updatedAt)));
        this.tickCount = time - this.updatedAt;
        this.updatedAt = time;
    }

    @Override
    public MathVector getNextPosition() {
        return this.add(this.getVelocity().mul(this.tickCount));
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }
}

