/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import pa3k.Configurable;
import pa3k.Game;
import pa3k.Log;
import robocode.AdvancedRobot;

abstract class Configuration {
    protected List<Game> games = new LinkedList<Game>();
    protected Game currentGame;

    public void newRound() {
        this.currentGame = new Game();
        this.games.add(this.currentGame);
    }

    public void dumpData() {
        Log.log(1, this + ": games played " + this.games.size());
        Log.log(1, "  last game: " + this.currentGame);
    }

    public abstract void apply(AdvancedRobot var1, Configurable var2);

    public void hit() {
        this.currentGame.hit();
    }

    public void shot() {
        this.currentGame.shot();
    }

    public double getRating() {
        if (this.games.size() == 0) {
            return 0.5;
        }
        int n = 0;
        int n2 = 0;
        Iterator<Game> iterator = this.games.iterator();
        Game game = null;
        while (iterator.hasNext()) {
            game = iterator.next();
            n += game.getHits();
            n2 += game.getShots();
        }
        n += game.getHits();
        n2 += game.getShots();
        return (double)(n += game.getHits()) / (double)(n2 += game.getShots());
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }
}

