/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.BulletTracking;
import pa3k.Gun;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;

public class NoAccelGun
extends Gun {
    protected int waiting;
    protected double lastHitProbability;
    protected long targetReevaluate;

    public NoAccelGun(AdvancedRobot advancedRobot, Tracking tracking) {
        super(advancedRobot, tracking);
    }

    @Override
    public void init() {
        this.waiting = 0;
        this.lastHitProbability = 0.0;
    }

    @Override
    public void turn() {
        int n;
        Position position = new Position((Robot)this.robot);
        position.modify(1L, this.robot.getVelocity(), this.robot.getHeadingRadians());
        if (this.targetReevaluate <= 0L || this.target == null || this.target.lastSeen(this.robot.getTime()) > 3L) {
            this.targetReevaluate = 30L;
            Object[] objectArray = this.tracking.getTargets();
            double d = 0.0;
            for (int i = 0; i < objectArray.length; ++i) {
                Opponent opponent = (Opponent)objectArray[i];
                if (opponent.lastSeen(this.robot.getTime()) >= 3L) continue;
                BulletTracking bulletTracking = new BulletTracking(1.8, position, opponent, this.tracking, this.robot.getTime());
                double d2 = bulletTracking.getRandomHitProbability();
                double d3 = opponent.getSelfAiming().getHittingRatio();
                if (this.tracking.getLastHitBy() == opponent) {
                    d3 += 0.4;
                }
                Log.log(3, "Opponent " + opponent + ", r. hit prob. " + d2 + ", hit history " + d3);
                if (!(d < d2 + d3)) break;
                d = d2 + d3;
                this.target = opponent;
                this.lastHitProbability = d2;
                break;
            }
            if (this.target != null) {
                this.tracking.setOpponentOfInterest(this.target);
                Log.log(2, "Targeting " + this.target + " random hit probability " + this.lastHitProbability);
            }
        }
        if (this.target != null && this.newBullet == null && (n = this.target.getScanPriority(this.robot.getTime())) != -1 && n < 2) {
            boolean bl;
            BulletTracking bulletTracking = new BulletTracking(1.8, position, this.target, this.tracking, this.robot.getTime());
            double d = bulletTracking.getRandomHitProbability();
            assert (d != Double.NaN);
            boolean bl2 = bl = this.target.getLastSpeedChange(this.robot.getTime()) == 1L;
            if (this.robot.getGunHeat() == 0.0 && (this.waiting == 0 || !bl || d > 0.4)) {
                double d4 = 1.8;
                if (d > 0.2) {
                    d4 = 2.4;
                }
                if (d > 0.3) {
                    d4 = 3.0;
                }
                if (d < 0.05) {
                    d4 = 0.6;
                }
                if (d4 > this.robot.getEnergy() - 0.1) {
                    d4 = this.robot.getEnergy() - 0.1;
                }
                if (d4 >= 0.1) {
                    double d5 = this.target.getLastEnergy() / 4.0;
                    if (d5 < d4 && (d4 = d5) < 0.1) {
                        d4 = 0.1;
                    }
                    this.newBullet = bulletTracking = this.target.getSelfAiming().getBestAimingAngle(position, this.target, this.tracking, d4, this.robot.getTime());
                    this.waiting = 30;
                }
            } else if (this.waiting > 0) {
                --this.waiting;
            }
            this.lastHitProbability = d;
        }
        --this.targetReevaluate;
        super.turn();
    }
}

