/*
 * Decompiled with CFR 0.152.
 */
package pulsar.util;

import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Util {
    public static final NumberFormat percentFormat = NumberFormat.getPercentInstance();
    public static final NumberFormat distanceFormat = new DecimalFormat("0000");

    Util() {
    }

    public static double calculateDamage(double shotPower) {
        double damage = shotPower * (double)4;
        if (shotPower > 1.0) {
            damage += (shotPower - 1.0) * (double)2;
        }
        return damage;
    }

    public static final double getDeclineFactor(int middle, int index, double power) {
        return Math.pow(Math.abs(middle - index) + 1, -power);
    }

    public static double calcFirePowerNeeded(double targetEnergy) {
        if (targetEnergy <= (double)4) {
            return targetEnergy / 4.0;
        }
        return (targetEnergy + 2.0) / 6.0;
    }

    public static double sign(double value) {
        return value == 0.0 ? 0.0 : value / Math.abs(value);
    }

    public static double getBulletSpeed(double power) {
        return (double)20 - (double)3 * power;
    }

    public static double getGunHeat(double firepower, long timeSinceFired) {
        double heat = 1.0 + firepower / 5.0;
        return Math.max(0.0, heat - (double)timeSinceFired * 0.1);
    }

    public static long getTimeToGunReady(double firepower, long timeSinceFired) {
        double heat = Util.getGunHeat(firepower, timeSinceFired);
        return (long)((double)10 * heat);
    }

    public static final double absbearing(double x1, double y1, double x2, double y2) {
        return Math.atan2(x2 - x1, y2 - y1);
    }

    public static final double absbearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static final double normalizeRelativeAngle(double angle) {
        double relativeAngle = angle % (Math.PI * 2);
        if (relativeAngle <= -Math.PI) {
            return Math.PI + relativeAngle % Math.PI;
        }
        if (relativeAngle > Math.PI) {
            return -Math.PI + relativeAngle % Math.PI;
        }
        return relativeAngle;
    }

    public static final double normalizeAngle(double angle) {
        while (!(angle >= 0.0)) {
            angle += Math.PI * 2;
        }
        return angle % (Math.PI * 2);
    }

    public static final double getAverage(double average, int count, double newValue) {
        return (average * (double)count + newValue) / (double)(++count);
    }

    public static final double getRollingAverage(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static final double maxEscapeAngle(double firePower) {
        return Math.abs(Math.asin(8.0 / Util.getBulletSpeed(firePower)));
    }

    public static final int getIntervalIndex(double value, double minValue, double maxValue, int segments) {
        if (!(minValue <= value) || !(maxValue >= value) || segments <= 0) {
            throw new IllegalArgumentException("minValue must be smaller than value." + " maxValue must be larger than the value." + " Number of segments must be more than 0." + " value=" + value + " minValue=" + minValue + " maxValue=" + maxValue + " segments=" + segments);
        }
        double segSize = Math.abs(maxValue - minValue) / (double)segments;
        int segment = (int)(value / segSize);
        int index = segment + (minValue < 0.0 && maxValue > 0.0 ? (int)Math.abs((maxValue - minValue) / ((double)2 * segSize)) : 0);
        return Math.min(segments - 1, Math.max(0, index));
    }

    public static final Point2D.Double linearPredict(double x, double y, double heading, double velocity, int timeDiff) {
        return new Point2D.Double(x + Math.sin(heading) * (velocity * (double)timeDiff), y + Math.cos(heading) * (velocity * (double)timeDiff));
    }

    public static final Point2D.Double circularPredict(double x, double y, double heading, double velocity, double changehead, int timeDiff) {
        double newX;
        double newY;
        if (Math.abs(changehead) > 1.0E-5) {
            double radius = velocity / changehead;
            double tothead = (double)timeDiff * changehead;
            newY = y + Math.sin(heading + tothead) * radius - Math.sin(heading) * radius;
            newX = x + Math.cos(heading) * radius - Math.cos(heading + tothead) * radius;
        } else {
            newY = y + Math.cos(heading) * velocity * (double)timeDiff;
            newX = x + Math.sin(heading) * velocity * (double)timeDiff;
        }
        return new Point2D.Double(newX, newY);
    }

    public static final double sum(float[] values) {
        double total = 0.0;
        int i = 0;
        while (i < values.length) {
            total += (double)values[i];
            ++i;
        }
        return total;
    }

    static {
        percentFormat.setMaximumFractionDigits(2);
        percentFormat.setMinimumFractionDigits(2);
    }
}

