/*
 * Decompiled with CFR 0.152.
 */
package eem.bullets;

import eem.EvBot;
import eem.bullets.firedBullet;
import eem.gun.baseGun;
import eem.gun.gunManager;
import eem.misc.graphics;
import eem.misc.math;
import eem.misc.physics;
import eem.target.InfoBot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import robocode.Bullet;

public class wave {
    protected EvBot myBot;
    protected Bullet robocodeBullet;
    public InfoBot firedBot = null;
    protected boolean isItMine = true;
    protected Point2D.Double firingPosition;
    protected long firedTime;
    protected double bulletSpeed;
    public LinkedList<firedBullet> bullets = new LinkedList();
    public HashMap<String, Point2D.Double> enemyPosAtFiringTime = new HashMap();
    public HashMap<String, Double> enemyMEAatFiringTime = new HashMap();
    protected Color waveColor = new Color(255, 0, 0, 128);

    public wave() {
    }

    public wave(EvBot evBot) {
        this.myBot = evBot;
        this.firingPosition = this.myBot.myCoord;
        this.firedBot = EvBot._tracker;
    }

    public wave(EvBot evBot, firedBullet firedBullet2) {
        this.myBot = evBot;
        this.isItMine = true;
        this.firedBot = EvBot._tracker;
        this.firingPosition = (Point2D.Double)firedBullet2.getFiringPosition().clone();
        this.firedTime = this.myBot.ticTime;
        this.bulletSpeed = firedBullet2.getSpeed();
        this.setEnemyPosAtFiringTime();
        this.setEnemyMEAatFiringTime();
        this.waveColor = firedBullet2.getColor();
        double d = firedBullet2.getBulletEnergy();
        String string = this.myBot.fightType();
        gunManager cfr_ignored_0 = this.myBot._gmanager;
        LinkedList<baseGun> linkedList = gunManager.gunSets.get(string);
        for (baseGun baseGun2 : linkedList) {
            firedBullet firedBullet3 = new firedBullet(this.myBot, EvBot._tracker, this.myBot._trgt, baseGun2, d);
            if (baseGun2.getName().equals(firedBullet2.getFiredGun().getName())) {
                firedBullet3.setIsItVirtual(false);
            } else {
                firedBullet3.setIsItVirtual(true);
            }
            this.addBullet(firedBullet3);
            baseGun2.updBulletFiredCount(EvBot._tracker, (InfoBot)this.myBot._trgt, firedBullet3);
        }
    }

    public wave(EvBot evBot, InfoBot infoBot, double d) {
        this.myBot = evBot;
        this.isItMine = false;
        this.firedBot = infoBot;
        baseGun baseGun2 = new baseGun();
        this.bulletSpeed = physics.bulletSpeed(d);
        this.firingPosition = (Point2D.Double)infoBot.getPosition().clone();
        this.firedTime = this.myBot.ticTime;
        this.setEnemyPosAtFiringTime();
        this.setEnemyMEAatFiringTime();
        String string = "firingAtMyBot_in_" + this.myBot.fightType();
        gunManager cfr_ignored_0 = this.myBot._gmanager;
        if (!gunManager.gunSets.containsKey(string)) {
            string = "firingAtMyBot_in_default";
        }
        gunManager cfr_ignored_1 = this.myBot._gmanager;
        LinkedList<baseGun> linkedList = gunManager.gunSets.get(string);
        for (baseGun baseGun3 : linkedList) {
            firedBullet firedBullet2 = new firedBullet(this.myBot, infoBot, baseGun3, infoBot.energyDrop());
            firedBullet2.setIsItVirtual(true);
            this.addBullet(firedBullet2);
            baseGun3.updBulletFiredCount(infoBot, EvBot._tracker, firedBullet2);
        }
    }

    private void setEnemyPosAtFiringTime() {
        LinkedList<InfoBot> linkedList = new LinkedList<InfoBot>();
        linkedList.addAll(this.myBot._botsmanager.listOfAliveBots());
        linkedList.add(EvBot._tracker);
        for (InfoBot infoBot : linkedList) {
            if (this.firedBot.getName().equals(infoBot.getName())) continue;
            String string = infoBot.getName();
            Point2D.Double double_ = (Point2D.Double)infoBot.getPosition().clone();
            this.enemyPosAtFiringTime.put(string, double_);
        }
    }

    private void setEnemyMEAatFiringTime() {
        LinkedList<InfoBot> linkedList = new LinkedList<InfoBot>();
        linkedList.addAll(this.myBot._botsmanager.listOfAliveBots());
        linkedList.add(EvBot._tracker);
        for (InfoBot infoBot : linkedList) {
            if (this.firedBot.getName().equals(infoBot.getName())) continue;
            String string = infoBot.getName();
            double d = math.calculateMEA(this.bulletSpeed);
            this.enemyMEAatFiringTime.put(string, d);
        }
    }

    public double getSpeed() {
        return this.bulletSpeed;
    }

    public void initTic() {
        this.updatedWaveStats();
    }

    public void updatedWaveStats() {
        long l = this.myBot.ticTime;
        double d = this.getDistanceTraveledAtTime(l);
        double d2 = this.getDistanceTraveledAtTime(l + 1L);
        LinkedList<firedBullet> linkedList = new LinkedList<firedBullet>();
        LinkedList<InfoBot> linkedList2 = new LinkedList<InfoBot>();
        linkedList2.addAll(this.myBot._botsmanager.listOfAliveBots());
        linkedList2.add(EvBot._tracker);
        for (InfoBot infoBot : linkedList2) {
            Point2D.Double double_;
            double d3;
            if (this.firedBot.getName().equals(infoBot.getName()) || !(Math.abs(d - (d3 = (double_ = infoBot.getPosition()).distance(this.firingPosition))) <= Math.abs(d2 - d3))) continue;
            String string = infoBot.getName();
            double d4 = math.angle2pt(this.firingPosition, double_) - math.angle2pt(this.firingPosition, this.enemyPosAtFiringTime.get(string));
            d4 = math.shortest_arc(d4);
            double d5 = d4 / this.enemyMEAatFiringTime.get(string);
            d5 = Math.max(-1.0, d5);
            d5 = Math.min(1.0, d5);
            this.firedBot.updateHitGuessFactor(infoBot, d5);
            for (firedBullet firedBullet2 : this.getBullets()) {
                if (!(double_.distance(firedBullet2.getPosition()) <= Math.sqrt(2.0) * (double)this.myBot.robotHalfSize)) continue;
                if (this.myBot.fightType().equals("1on1")) {
                    // empty if block
                }
                ++EvBot.bulletHitByPredictedCnt;
                linkedList.add(firedBullet2);
                if (infoBot.getName().equals(this.myBot.getName()) || firedBullet2.getFiredGun().getName().equals("shadow")) continue;
                firedBullet2.getFiredGun().updBulletHitCount(EvBot._tracker, infoBot, firedBullet2);
                linkedList.add(firedBullet2);
            }
            for (firedBullet firedBullet2 : linkedList) {
                this.bullets.remove(firedBullet2);
            }
        }
    }

    public int getGuessFactorCount(InfoBot infoBot, double d) {
        return this.firedBot.getGuessFactorCount(infoBot, d);
    }

    public double getGuessFactorForPoint(InfoBot infoBot, Point2D.Double double_) {
        String string = infoBot.getName();
        double d = math.angle2pt(this.firingPosition, double_) - math.angle2pt(this.firingPosition, this.enemyPosAtFiringTime.get(string));
        d = math.shortest_arc(d);
        double d2 = d / this.enemyMEAatFiringTime.get(string);
        return d2;
    }

    public int getGuessFactorCountForPoint(InfoBot infoBot, Point2D.Double double_) {
        double d = this.getGuessFactorForPoint(infoBot, double_);
        return this.firedBot.getGuessFactorCount(infoBot, d);
    }

    public double getGuessFactorNormProbForPoint(InfoBot infoBot, Point2D.Double double_) {
        double d = this.getGuessFactorForPoint(infoBot, double_);
        return this.firedBot.getGuessFactorNormProb(infoBot, d);
    }

    public double getGuessFactorProbForPoint(InfoBot infoBot, Point2D.Double double_) {
        double d = this.getGuessFactorForPoint(infoBot, double_);
        return this.firedBot.getGuessFactorProb(infoBot, d);
    }

    public boolean isPosWithMEAforBot(Point2D.Double double_, InfoBot infoBot) {
        Point2D.Double double_2 = (Point2D.Double)this.enemyPosAtFiringTime.get(infoBot.getName()).clone();
        double d = this.enemyMEAatFiringTime.get(infoBot.getName());
        double d2 = math.angle2pt(this.firingPosition, double_2);
        double d3 = math.angle2pt(this.firingPosition, double_);
        return Math.abs(d3 - d2) < d;
    }

    public Point2D.Double getFiringPosition() {
        return this.firingPosition;
    }

    public long getFiredTime() {
        return this.firedTime;
    }

    public LinkedList<firedBullet> getBullets() {
        return this.bullets;
    }

    public double distance(Point2D.Double double_) {
        double d = this.firingPosition.distance(double_) - this.getDistanceTraveled();
        return d;
    }

    public double distance(Point2D.Double double_, long l) {
        double d = this.firingPosition.distance(double_) - this.getDistanceTraveledAtTime(l);
        return d;
    }

    public void addBullet(firedBullet firedBullet2) {
        this.bullets.add(firedBullet2);
    }

    public void removeBullet(firedBullet firedBullet2) {
        this.bullets.remove(firedBullet2);
    }

    public void removeInactiveBullets() {
        ListIterator listIterator = this.bullets.listIterator();
        while (listIterator.hasNext()) {
            if (((firedBullet)listIterator.next()).isActive()) continue;
            listIterator.remove();
        }
    }

    public double getDistanceTraveledAtTime(long l) {
        double d = l - this.firedTime + 1L;
        if (!this.isItMine) {
            d += 1.0;
        }
        double d2 = d * this.bulletSpeed;
        return d2;
    }

    public double getDistanceTraveled() {
        return this.getDistanceTraveledAtTime(this.myBot.ticTime);
    }

    public void onPaint(Graphics2D graphics2D) {
        graphics2D.setColor(this.waveColor);
        double d = this.getDistanceTraveled();
        graphics.drawCircle(graphics2D, this.firingPosition, d);
        if (!this.isItMine) {
            Iterator<Point2D.Double> iterator = (Point2D.Double)this.enemyPosAtFiringTime.get(this.myBot.getName()).clone();
            double d2 = this.enemyMEAatFiringTime.get(this.myBot.getName());
            double d3 = math.angle2pt(this.firingPosition, iterator);
            double d4 = d3 + d2;
            double d5 = d3 - d2;
            graphics.drawCircArc(graphics2D, this.firingPosition, d - 5.0, d4, d5);
            int[] nArray = this.firedBot.getGuessFactorBins(EvBot._tracker);
            int n = nArray.length;
            double d6 = math.calculateMEA(this.bulletSpeed);
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
            for (int i = 0; i < n; ++i) {
                double d7 = math.bin2gf(i, n);
                double d8 = Math.toRadians(d3 + d6 * d7);
                double d9 = d + 5.0;
                double_.x = this.firingPosition.x + d9 * Math.sin(d8);
                double_.y = this.firingPosition.y + d9 * Math.cos(d8);
                d9 = d + 5.0 + 1.0 + 20.0 * this.firedBot.getGuessFactorNormProb(EvBot._tracker, d7);
                double_2.x = this.firingPosition.x + d9 * Math.sin(d8);
                double_2.y = this.firingPosition.y + d9 * Math.cos(d8);
                graphics.drawLine(graphics2D, double_, double_2);
            }
        }
        for (firedBullet firedBullet2 : this.bullets) {
            firedBullet2.onPaint(graphics2D);
        }
        for (Point2D.Double double_ : this.enemyPosAtFiringTime.values()) {
            graphics.drawSquare(graphics2D, double_, 4.0);
        }
    }
}

