/*
 * Decompiled with CFR 0.152.
 */
package eem.radar;

import eem.EvBot;
import eem.misc.logger;
import eem.misc.math;
import java.util.LinkedList;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class radar {
    protected EvBot myBot;
    protected int radarSpinDirection = 1;
    protected static double radarMaxRotationAngle;
    protected LinkedList<String> scannedBots = new LinkedList();
    protected String botToSearchFor = "";
    boolean needToTrackTarget = false;

    public radar(EvBot evBot) {
        this.myBot = evBot;
        Rules cfr_ignored_0 = this.myBot.game_rules;
        radarMaxRotationAngle = 45.0;
        this.needToTrackTarget = false;
        this.botToSearchFor = "";
    }

    public void initTic() {
        this.myBot.setAdjustRadarForGunTurn(true);
    }

    public void setNeedToTrackTarget(boolean bl) {
        this.needToTrackTarget = bl;
    }

    public void manage() {
        double d = 0.0;
        if (this.myBot.numEnemyBotsAlive == 0) {
            return;
        }
        if (this.scannedBots.size() < this.myBot.numEnemyBotsAlive) {
            d = (double)this.radarSpinDirection * radarMaxRotationAngle;
            this.setTurnRadarRight(d);
            return;
        }
        if (this.needToTrackTarget) {
            if (this.myBot._trgt.haveTarget) {
                String string = this.myBot._trgt.getName();
                this.moveRadarToBot(string);
            } else {
                this.refreshBotsPositions();
            }
            return;
        }
        this.refreshBotsPositions();
    }

    public void refreshBotsPositions() {
        String string = this.scannedBots.getFirst();
        this.moveRadarToBot(string);
    }

    public void moveRadarToBot(String string) {
        double d = 0.0;
        long l = this.myBot.ticTime - this.myBot._botsmanager.getBotByName(string).getLastSeenTime();
        if (this.botToSearchFor.equals(string) && l > 1L) {
            d = (double)this.radarSpinDirection * radarMaxRotationAngle;
        } else {
            this.botToSearchFor = string;
            double d2 = this.myBot.getRadarHeading();
            double d3 = math.angle2pt(this.myBot.myCoord, this.myBot._botsmanager.getBotByName(string).getPosition());
            d = d3 - d2;
            d = math.shortest_arc(d);
            this.radarSpinDirection = math.signNoZero(d);
            d = Math.abs(d);
            d += radarMaxRotationAngle / 2.0;
            d = (double)this.radarSpinDirection * d;
        }
        this.setTurnRadarRight(d);
    }

    protected void setTurnRadarRight(double d) {
        double d2 = math.putWithinRange(d, -radarMaxRotationAngle, radarMaxRotationAngle);
        logger.noise("Radar rotation angle = " + d2);
        this.myBot.setTurnRadarRight(d2);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        String string = robotDeathEvent.getName();
        this.scannedBots.remove(string);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        long l = System.nanoTime();
        String string = scannedRobotEvent.getName();
        for (String string2 : this.scannedBots) {
            if (!string2.equals(string)) continue;
            this.scannedBots.remove(string2);
            break;
        }
        this.scannedBots.addLast(string);
        long l2 = System.nanoTime();
        logger.profiler("radar.onScannedRobot execution time =\t\t\t\t" + (l2 - l) + " ns");
    }
}

