/*
 * Decompiled with CFR 0.152.
 */
package eem.target;

import eem.EvBot;
import eem.misc.logger;
import eem.target.InfoBot;
import eem.target.botStatPoint;
import eem.target.target;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.LinkedList;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class botsManager {
    public EvBot myBot;
    public static HashMap<String, InfoBot> bots = new HashMap();
    public static HashMap<String, InfoBot> deadBots = new HashMap();
    protected double distAtWhichHitProbabilityDrops = 200.0;

    public botsManager(EvBot evBot) {
        this.myBot = evBot;
        if (deadBots.size() >= 1) {
            for (InfoBot infoBot : deadBots.values()) {
                String string = infoBot.getName();
                bots.put(string, infoBot);
            }
        }
        deadBots.clear();
    }

    public InfoBot getBotByName(String string) {
        InfoBot infoBot = null;
        infoBot = bots.get(string);
        if (null != infoBot) {
            return infoBot;
        }
        infoBot = deadBots.get(string);
        if (null != infoBot) {
            return infoBot;
        }
        logger.error("Bots manager cannot find bot: " + string);
        return infoBot;
    }

    public double botWeightForTargeting(InfoBot infoBot) {
        double d = 0.0;
        double d2 = infoBot.getLastDistance(this.myBot.myCoord);
        double d3 = 100.0 / d2;
        d3 *= Math.exp(-d2 / this.distAtWhichHitProbabilityDrops);
        int n = this.myBot._gmanager.totalBotFiredCount(infoBot);
        double d4 = this.myBot._gmanager.botAsTargetWeight(infoBot);
        double d5 = this.myBot.fightType().equals("meleeMidle") ? (1.0 / (double)this.myBot.numEnemyBotsAlive - d4) * Math.exp(-n / 10) + d4 : 1.0 / (double)this.myBot.numEnemyBotsAlive;
        double d6 = 0.0;
        d6 = 100.0 / (infoBot.getEnergy() + 0.001);
        d6 *= Math.exp(-d2 / this.distAtWhichHitProbabilityDrops);
        d6 = 1.0;
        int n2 = infoBot.getBulletFiredCount();
        double d7 = 30.0 / (double)(30 + n2);
        d = 100.0 * d5 * d3 * d6 * d7;
        if (d < 0.0) {
            logger.dbg("ERROR: bot weight as a target is negative");
        }
        logger.noise(" dist2bot = " + d2 + " wDist = " + logger.shortFormatDouble(d3) + " wGun = " + logger.shortFormatDouble(d5) + " cFir = " + n + " wEnrg = " + logger.shortFormatDouble(d6) + " cEnFir = " + n2 + " wSurv = " + logger.shortFormatDouble(d7) + " weight " + " = " + logger.shortFormatDouble(d) + " for " + infoBot.getName());
        return d;
    }

    public target choseTarget() {
        target target2 = this.myBot._trgt;
        double d = target2.haveTarget ? this.botWeightForTargeting(target2) : -1000.0;
        for (InfoBot infoBot : bots.values()) {
            double d2;
            if (infoBot.getName().equals(target2.getName()) || !(d < (d2 = this.botWeightForTargeting(infoBot)))) continue;
            d = d2;
            target2 = new target(infoBot);
            logger.noise("new target " + target2.getName());
        }
        return target2;
    }

    public void initTic(long l) {
        for (InfoBot infoBot : bots.values()) {
            infoBot.initTic(l);
            if (!infoBot.didItFireABullet(l)) continue;
            this.myBot._bmanager.add_enemy_wave(infoBot);
        }
    }

    public void printGunsStats() {
        logger.routine("-------------------------------------------------------");
        logger.routine("Summary for enemies guns");
        logger.routine("-------------------------------------------------------");
        logger.routine("--- Alive bots ---");
        for (InfoBot infoBot : bots.values()) {
            infoBot.printGunsStats();
        }
        logger.routine("--- Dead bots ---");
        for (InfoBot infoBot : deadBots.values()) {
            infoBot.printGunsStats();
        }
        logger.routine("--- Guess factors at which I seen ---");
        for (InfoBot infoBot : this.listOfKnownBots()) {
            infoBot.printGFstats(EvBot._tracker);
        }
    }

    public LinkedList<InfoBot> listOfKnownBots() {
        LinkedList<InfoBot> linkedList = new LinkedList<InfoBot>();
        linkedList.addAll(this.listOfAliveBots());
        linkedList.addAll(this.listOfDeadBots());
        return linkedList;
    }

    public LinkedList<InfoBot> listOfAliveBots() {
        LinkedList<InfoBot> linkedList = new LinkedList<InfoBot>();
        for (InfoBot infoBot : bots.values()) {
            linkedList.add(infoBot);
        }
        return linkedList;
    }

    public LinkedList<InfoBot> listOfDeadBots() {
        LinkedList<InfoBot> linkedList = new LinkedList<InfoBot>();
        for (InfoBot infoBot : deadBots.values()) {
            linkedList.add(infoBot);
        }
        return linkedList;
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        String string = robotDeathEvent.getName();
        InfoBot infoBot = bots.get(string);
        deadBots.put(string, infoBot);
        bots.remove(string);
    }

    public void add(InfoBot infoBot) {
        bots.put(infoBot.getName(), infoBot);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        String string = hitByBulletEvent.getName();
        InfoBot infoBot = bots.get(string);
        if (infoBot != null) {
            infoBot.incBulletHitCount();
        }
        if ((infoBot = deadBots.get(string)) != null) {
            infoBot.incBulletHitCount();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        long l = System.nanoTime();
        String string = scannedRobotEvent.getName();
        InfoBot infoBot = bots.get(string);
        if (infoBot == null) {
            infoBot = new InfoBot(string);
        }
        infoBot.update(new botStatPoint(this.myBot, scannedRobotEvent));
        bots.put(string, infoBot);
        logger.profiler("botsManager.onScannedRobot execution time =\t\t\t\t" + (System.nanoTime() - l) + " ns");
    }

    public void onPaint(Graphics2D graphics2D) {
        for (InfoBot infoBot : bots.values()) {
        }
    }
}

