/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import tcf.Arena;
import tcf.Bot;
import tcf.GuessFactor;
import tcf.SimBot;
import tcf.TestGf;

class CircularGfTest
implements TestGf {
    double m_minGf;
    double m_maxGf;

    CircularGfTest(Bot bot, Bot bot2, Arena arena, double d, double d2) {
        double d3 = Math.atan2(bot2.x() - bot.x(), bot2.y() - bot.y());
        double d4 = Math.hypot(bot2.x() - bot.x(), bot2.y() - bot.y());
        double[] dArray = new double[2];
        for (int i = 0; i < 2; ++i) {
            double d5;
            double d6 = Math.toRadians(i == 0 ? 50.0 : -50.0);
            double d7 = Math.signum(d6);
            double d8 = d5 / 16.0;
            for (d5 = Math.abs(d6); d5 >= 0.0; d5 -= d8) {
                double d9;
                double d10 = d3 + d5 * d7;
                double d11 = bot.x() + d4 * Math.sin(d10);
                if (arena.containsPoint(d11, d9 = bot.y() + d4 * Math.cos(d10))) break;
            }
            dArray[i] = GuessFactor.angleToGf(d5 * d7, d, d2);
        }
        this.m_minGf = Math.min(dArray[0], dArray[1]);
        this.m_maxGf = Math.max(dArray[0], dArray[1]);
    }

    public boolean test(double d) {
        return this.m_minGf <= d && d <= this.m_maxGf;
    }

    public String toString() {
        return String.format("minGf %g maxGf %g", this.m_minGf, this.m_maxGf);
    }

    public static void main(String[] stringArray) {
        Arena arena = new Arena(800.0, 600.0, 36.0, 36.0);
        SimBot simBot = new SimBot("g", 0L, 100.0, 300.0, 0.0, 0.0);
        SimBot simBot2 = new SimBot("t", 0L, 700.0, 300.0, 0.0, 0.0);
        double d = Math.toRadians(-50.0);
        double d2 = Math.toRadians(50.0);
        CircularGfTest circularGfTest = new CircularGfTest(simBot, simBot2, arena, d, d2);
        System.out.println(((Object)circularGfTest).toString());
        simBot2 = new SimBot("t", 0L, 700.0, 100.0, 0.0, 0.0);
        circularGfTest = new CircularGfTest(simBot, simBot2, arena, d, d2);
        System.out.println(((Object)circularGfTest).toString());
        simBot2 = new SimBot("t", 0L, 700.0, 500.0, 0.0, 0.0);
        circularGfTest = new CircularGfTest(simBot, simBot2, arena, d, d2);
        System.out.println(((Object)circularGfTest).toString());
    }
}

