/*
 * Decompiled with CFR 0.152.
 */
package tcf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeQueue<T> {
    private T[] m_array = new Object[4];
    private int m_head;
    private int m_size;

    DeQueue() {
    }

    void clear() {
        this.m_array = new Object[4];
        this.m_size = 0;
        this.m_head = 0;
    }

    int size() {
        return this.m_size;
    }

    int capacity() {
        return this.m_array.length;
    }

    T get(int n) {
        int n2 = this.m_head + n;
        if (n2 >= this.m_array.length) {
            n2 -= this.m_array.length;
        }
        return this.m_array[n2];
    }

    void addHead(T t) {
        if (this.m_size >= this.m_array.length) {
            this.increaseCapacity();
        }
        if (--this.m_head < 0) {
            this.m_head = this.m_array.length - 1;
        }
        this.m_array[this.m_head] = t;
    }

    void addTail(T t) {
        int n;
        if (this.m_size >= this.m_array.length) {
            this.increaseCapacity();
        }
        if ((n = this.m_head + this.m_size++) >= this.m_array.length) {
            n -= this.m_array.length;
        }
        this.m_array[n] = t;
    }

    T removeHead() {
        if (this.m_size > 0) {
            --this.m_size;
            T t = this.m_array[this.m_head++];
            if (this.m_head >= this.m_array.length) {
                this.m_head = 0;
            }
            return t;
        }
        return null;
    }

    T removeTail() {
        if (this.m_size > 0) {
            int n;
            if ((n = this.m_head + --this.m_size) >= this.m_array.length) {
                n -= this.m_array.length;
            }
            return this.m_array[n];
        }
        return null;
    }

    private void increaseCapacity() {
        int n = this.m_array.length * 2;
        Object[] objectArray = new Object[n];
        if (this.m_head + this.m_size <= this.m_array.length) {
            System.arraycopy(this.m_array, this.m_head, objectArray, 0, this.m_size);
        } else {
            int n2 = this.m_array.length - this.m_head;
            int n3 = this.m_size - n2;
            System.arraycopy(this.m_array, this.m_head, objectArray, 0, n2);
            System.arraycopy(this.m_array, 0, objectArray, n2, n3);
        }
        this.m_array = objectArray;
        this.m_head = 0;
    }
}

