/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.List;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.util.Utils;
import tcf.Arena;
import tcf.Bot;
import tcf.CrowdTargettingWave;
import tcf.MovementBase;
import tcf.OppBot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrbitalMovement
extends MovementBase {
    AdvancedRobot m_robot;
    Bot m_self;
    List<CrowdTargettingWave> m_waves;
    double m_toX;
    double m_toY;
    int m_updateDestCount = 0;
    int m_pathT;
    double[] m_pathX;
    double[] m_pathY;
    int[] m_pathV;

    OrbitalMovement(Arena arena, AdvancedRobot advancedRobot, Bot bot, List<CrowdTargettingWave> list) {
        super(arena);
        this.m_robot = advancedRobot;
        this.m_self = bot;
        this.m_waves = list;
    }

    @Override
    void tick(Map<String, OppBot> map, int n, OppBot oppBot) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n52;
        int n6;
        int n7;
        int n8;
        int n9;
        double d;
        if (--this.m_updateDestCount > 0) {
            return;
        }
        this.m_updateDestCount = 20;
        this.updateGrid(map, n);
        double[] dArray = new double[25];
        double[] dArray2 = new double[25];
        double[] dArray3 = new double[401];
        double[] dArray4 = new double[401];
        double d2 = this.m_arena.WIDTH / 2.0;
        double d3 = this.m_arena.HEIGHT / 2.0;
        if (oppBot != null) {
            d2 = oppBot.x();
            d3 = oppBot.y();
        }
        for (int i = -1; i <= 1; i += 2) {
            double d4 = 0.0;
            double d5 = 0.0;
            int n10 = 0;
            int n11 = 0;
            double d6 = this.m_self.x();
            double d7 = this.m_self.y();
            for (int j = 0; j <= 200; ++j) {
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = Math.hypot(d2 - d6, d3 - d7);
                d = Math.atan2(d2 - d6, d3 - d7);
                double d11 = Math.min(128.0, d10);
                dArray3[200 + i * j] = d6;
                dArray4[200 + i * j] = d7;
                int n12 = 95 + Math.max(0, (int)((600.0 - d10) / 12.0));
                n9 = n12 - 80;
                for (n8 = n12 * i; n8 != n9; n8 -= 2 * i) {
                    double d12 = d + Math.toRadians(n8);
                    d8 = Math.sin(d12);
                    d9 = Math.cos(d12);
                    d4 = d6 + d11 * d8;
                    d5 = d7 + d11 * d9;
                    n10 = (int)Math.floor((d4 - (double)this.m_gridX) / this.m_gridStep);
                    n11 = (int)Math.floor((d5 - (double)this.m_gridY) / this.m_gridStep);
                    if (n10 < 0 || n10 >= this.m_gridW || n11 < 0 || n11 >= this.m_gridH) continue;
                    n7 = this.m_gridW - 1 - n10;
                    n6 = this.m_gridH - 1 - n11;
                    if (n10 + n11 >= 4 && n10 + n6 >= 4 && n7 + n11 >= 4 && n7 + n6 >= 4) break;
                }
                d6 += d8;
                d7 += d9;
                d6 = this.m_arena.clipX(d6, 40);
                d7 = this.m_arena.clipY(d7, 40);
            }
        }
        double d13 = Math.atan2(d2 - this.m_self.x(), d3 - this.m_self.y());
        int[] nArray = new int[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2};
        int[] nArray2 = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 0};
        int[][] nArray3 = new int[25][7218];
        long l = System.nanoTime();
        double d14 = 0.0;
        for (int i = 0; i < 401; ++i) {
            int n13;
            for (n52 = n13 = (Math.abs(i - 200) + 7) / 8; n52 < 25; ++n52) {
                d = 0.0;
                for (CrowdTargettingWave object2 : this.m_waves) {
                    d += object2.calcHit(dArray3[i], dArray4[i], 25.0, n52);
                }
                nArray3[n52][i] = (int)(d * 1000.0) << 4;
                if (!(d14 < d)) continue;
                d14 = d;
            }
        }
        long l2 = System.nanoTime();
        n52 = (int)Math.round(this.m_self.speed());
        if (Utils.normalRelativeAngle((double)(d13 - this.m_self.heading())) > 0.0) {
            n52 = -n52;
        }
        int n14 = (9 + n52) * 401 + 200;
        nArray3[0][n14] = 0xFFFFFF0 - nArray3[0][200];
        l = System.nanoTime();
        for (n5 = 0; n5 < 24; ++n5) {
            int n15 = n5 * 8;
            int[] nArray4 = nArray3[n5];
            int[] nArray42 = nArray3[n5 + 1];
            for (n9 = -8; n9 <= 8; ++n9) {
                n8 = (9 + n9) * 401;
                int n16 = nArray[8 + n9];
                int n21 = nArray2[8 + n9];
                n7 = 200 + n15;
                for (n6 = 200 - n15; n6 <= n7; ++n6) {
                    n4 = nArray4[n8 + n6];
                    if (n4 == 0) continue;
                    for (n3 = n16; n3 <= n21; ++n3) {
                        int n10 = (9 + n9 + n3) * 401 + n6 + n9 + n3;
                        int n11 = n4 - nArray42[n6];
                        if (nArray42[n10] >= n11) continue;
                        nArray42[n10] = n11 & 0xFFFFFFF0 | 4 + n3;
                    }
                }
            }
        }
        l2 = System.nanoTime();
        n5 = -1;
        double d15 = 2.147483647E9;
        for (int i = -8; i <= 8; ++i) {
            for (n9 = 0; n9 < 401; ++n9) {
                n8 = (9 + i) * 401 + n9;
                int n20 = nArray3[24][n8];
                double d4 = 0xFFFFFF - (n20 >>> 4);
                n6 = this.calcGridX(dArray3[n9]);
                n4 = this.calcGridY(dArray4[n9]);
                n3 = n6 + n4 * this.m_gridW;
                d4 -= (double)this.m_grid[n3] * 0.001;
                if (n20 == 0 || !(d15 > d4)) continue;
                n5 = n8;
                d15 = d4;
            }
        }
        int[] nArray5 = new int[25];
        n9 = n5 % 401;
        n8 = n5 / 401 - 9;
        for (n2 = 24; n2 > 0; --n2) {
            nArray5[n2] = n8;
            int n12 = (nArray3[n2][n5] & 7) - 4;
            n5 = (9 + (n8 -= n12)) * 401 + (n9 -= n8);
        }
        nArray5[0] = n8;
        for (n2 = 0; n2 < 25; ++n2) {
            dArray[n2] = dArray3[n9];
            dArray2[n2] = dArray4[n9];
            n9 += nArray5[n2];
        }
        this.m_pathT = 0;
        this.m_pathX = dArray;
        this.m_pathY = dArray2;
        this.m_pathV = nArray5;
        this.m_toX = this.m_self.x();
        this.m_toY = this.m_self.y();
    }

    @Override
    void event(MovementBase.Event event) {
        switch (event) {
            default: 
        }
        this.m_updateDestCount = 0;
    }

    @Override
    void drive() {
        this.m_toX = this.m_pathX[this.m_pathT];
        this.m_toY = this.m_pathY[this.m_pathT];
        ++this.m_pathT;
        int n = Math.min(this.m_pathT + 1, this.m_pathX.length - 1);
        double[] dArray = this.doGoto(this.m_self, this.m_pathX[n], this.m_pathY[n]);
        dArray[1] = Math.signum(dArray[1]) * (double)Math.abs(this.m_pathV[this.m_pathT]);
        this.m_robot.setTurnRightRadians(dArray[0]);
        this.m_robot.setAhead(dArray[1] == 0.0 ? 0.0 : (dArray[1] < 0.0 ? -100.0 : 100.0));
        this.m_robot.setMaxVelocity(Math.abs(dArray[1]));
    }

    @Override
    double getToX() {
        return this.m_toX;
    }

    @Override
    double getToY() {
        return this.m_toY;
    }
}

