/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.List;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.util.Utils;
import tcf.Arena;
import tcf.Bot;
import tcf.CrowdTargettingWave;
import tcf.MovementBase;
import tcf.OppBot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleOrbitalMovement
extends MovementBase {
    AdvancedRobot m_robot;
    Bot m_self;
    List<CrowdTargettingWave> m_waves;
    double m_toX;
    double m_toY;
    int m_updateDestCount = 0;
    int m_pathT;
    double[] m_pathX;
    double[] m_pathY;
    int[] m_pathV;

    SimpleOrbitalMovement(Arena arena, AdvancedRobot advancedRobot, Bot bot, List<CrowdTargettingWave> list) {
        super(arena);
        this.m_robot = advancedRobot;
        this.m_self = bot;
        this.m_waves = list;
    }

    @Override
    void tick(Map<String, OppBot> map, int n, OppBot oppBot) {
        int n2;
        int n3;
        int object2;
        int n4;
        double d;
        double d2;
        int n5;
        double d3;
        if (--this.m_updateDestCount > 0) {
            return;
        }
        this.m_updateDestCount = 20;
        this.updateGrid(map, n);
        double[] dArray = new double[25];
        double[] dArray2 = new double[25];
        double[] dArray3 = new double[401];
        double[] dArray4 = new double[401];
        double d4 = this.m_arena.WIDTH / 2.0;
        double d5 = this.m_arena.HEIGHT / 2.0;
        if (oppBot != null) {
            d4 = oppBot.x();
            d5 = oppBot.y();
        }
        for (int i = -1; i <= 1; i += 2) {
            double d6 = 0.0;
            double d7 = 0.0;
            int n6 = 0;
            int n7 = 0;
            double d8 = this.m_self.x();
            d3 = this.m_self.y();
            for (n5 = 0; n5 <= 200; ++n5) {
                d2 = 0.0;
                double d9 = 0.0;
                d = Math.hypot(d4 - d8, d5 - d3);
                double d10 = Math.atan2(d4 - d8, d5 - d3);
                double d11 = Math.min(128.0, d);
                dArray3[200 + i * n5] = d8;
                dArray4[200 + i * n5] = d3;
                n4 = 95 + Math.max(0, (int)((600.0 - d) / 12.0));
                object2 = n4 - 80;
                for (int j = n4 * i; j != object2; j -= 2 * i) {
                    double d12 = d10 + Math.toRadians(j);
                    d2 = Math.sin(d12);
                    d9 = Math.cos(d12);
                    d6 = d8 + d11 * d2;
                    d7 = d3 + d11 * d9;
                    n6 = (int)Math.floor((d6 - (double)this.m_gridX) / this.m_gridStep);
                    n7 = (int)Math.floor((d7 - (double)this.m_gridY) / this.m_gridStep);
                    if (n6 < 0 || n6 >= this.m_gridW || n7 < 0 || n7 >= this.m_gridH) continue;
                    n3 = this.m_gridW - 1 - n6;
                    n2 = this.m_gridH - 1 - n7;
                    if (n6 + n7 >= 4 && n6 + n2 >= 4 && n3 + n7 >= 4 && n3 + n2 >= 4) break;
                }
                d8 += d2;
                d3 += d9;
                d8 = this.m_arena.clipX(d8, 40);
                d3 = this.m_arena.clipY(d3, 40);
            }
        }
        double d13 = Math.atan2(d4 - this.m_self.x(), d5 - this.m_self.y());
        long l = System.nanoTime();
        double[] dArray5 = new double[401];
        int[] nArray = new int[401];
        CrowdTargettingWave[] crowdTargettingWaveArray = new CrowdTargettingWave[401];
        d3 = 0.0;
        for (n5 = 0; n5 < 401; ++n5) {
            d2 = 0.0;
            nArray[n5] = Integer.MAX_VALUE;
            for (CrowdTargettingWave object3 : this.m_waves) {
                d = Math.hypot(dArray3[n5] - object3.gunInitX(), dArray4[n5] - object3.gunInitY()) - object3.shotDist();
                int n8 = (int)(d / object3.shotSpeed());
                if (n8 <= 0 || nArray[n5] <= n8) continue;
                nArray[n5] = n8;
                crowdTargettingWaveArray[n5] = object3;
            }
            if (crowdTargettingWaveArray[n5] == null) continue;
            dArray5[n5] = crowdTargettingWaveArray[n5].calcHit(dArray3[n5], dArray4[n5]);
            if (!(d3 < d2)) continue;
            d3 = d2;
        }
        System.out.printf("time p0 %d\n", nArray[200]);
        long l2 = System.nanoTime();
        int n6 = (int)Math.round(this.m_self.speed());
        if (Utils.normalRelativeAngle((double)(d13 - this.m_self.heading())) > 0.0) {
            n6 = -n6;
        }
        int n10 = 200;
        l = System.nanoTime();
        int[] nArray2 = new int[]{0, 0, 0, 1, 2, 4, 6, 9, 12};
        int n11 = 0;
        double d6 = 1.0E8;
        for (int i = 0; i < 401; ++i) {
            int n12 = i - n10;
            int n7 = n6;
            n4 = 0;
            object2 = nArray2[Math.abs(n7)];
            if (n12 * n7 < 0 || object2 > Math.abs(n12)) {
                while (n7 != 0) {
                    n7 = (n7 < 0 ? -1 : 1) * Math.max(0, Math.abs(n7) - 2);
                    n12 += n7;
                    ++n4;
                }
            }
            n12 = Math.abs(n12);
            n7 = Math.abs(n7);
            while (n12 > 0) {
                int n14;
                if (n7 == 8) {
                    n14 = (n12 - nArray2[8]) / 8;
                    n12 -= n14 * 8;
                    n4 += n14;
                }
                int n15 = Math.max(0, n7 - 2);
                for (n14 = Math.min(8, n7 + 1); n14 > n15 && n12 - n14 < nArray2[n14]; --n14) {
                }
                n7 = n14;
                n12 -= n7;
                ++n4;
            }
            if (n4 > nArray[i]) continue;
            double d15 = dArray5[i];
            int n8 = this.calcGridX(dArray3[i]);
            n2 = n8 + (n3 = this.calcGridY(dArray4[i])) * this.m_gridW;
            if (!(d6 > (d15 -= (double)this.m_grid[n2] * 0.001))) continue;
            d6 = d15;
            n11 = i;
        }
        l2 = System.nanoTime();
        this.m_toX = dArray3[n11];
        this.m_toY = dArray4[n11];
    }

    @Override
    void event(MovementBase.Event event) {
        switch (event) {
            default: 
        }
        this.m_updateDestCount = 0;
    }

    @Override
    void drive() {
        double[] dArray = this.doGoto(this.m_self, this.m_toX, this.m_toY);
        this.m_robot.setTurnRightRadians(dArray[0]);
        this.m_robot.setAhead(dArray[1] == 0.0 ? 0.0 : (dArray[1] < 0.0 ? -100.0 : 100.0));
        this.m_robot.setMaxVelocity(Math.abs(dArray[1]));
    }

    @Override
    double getToX() {
        return this.m_toX;
    }

    @Override
    double getToY() {
        return this.m_toY;
    }
}

