/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rGun;

import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rGun.BattleInfo;
import dsekercioglu.mega.rGun.PPMEA;
import dsekercioglu.mega.rMove.MoveUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.Rules;
import robocode.util.Utils;

public class Wave {
    final Point2D.Double SOURCE;
    final Point2D.Double TARGET;
    final double WAVE_VELOCITY;
    final double WAVE_DAMAGE;
    final double ABS_BEARING;
    final int LATERAL_DIRECTION;
    final double MEA;
    final double MEA_CLOCKWISE;
    final double MEA_COUNTER_CLOCKWISE;
    final double CLOCKWISE_MEA_RATIO;
    final double COUNTER_CLOCKWISE_MEA_RATIO;
    double distanceTraveled;
    ArrayList<GuessFactor> guessFactors = new ArrayList();
    ArrayList<Double> virtualGunGuessFactors = new ArrayList();
    final BattleInfo INFO;
    boolean real = false;

    public Wave(double power, BattleInfo battleInfo) {
        this.INFO = battleInfo.clone();
        this.distanceTraveled = this.WAVE_VELOCITY = 20.0 - 3.0 * power;
        this.WAVE_DAMAGE = Rules.getBulletDamage((double)power);
        this.ABS_BEARING = battleInfo.absoluteBearing;
        this.LATERAL_DIRECTION = battleInfo.getEnemyLateralDirection();
        this.SOURCE = (Point2D.Double)battleInfo.botLocation.clone();
        this.TARGET = (Point2D.Double)battleInfo.enemyLocation.clone();
        PPMEA ppmea = new PPMEA(battleInfo.BATTLE_FIELD_WIDTH, battleInfo.BATTLE_FIELD_HEIGHT, 0.01);
        ppmea.calculateEscapeAngle(this.TARGET, this.SOURCE, this.WAVE_VELOCITY);
        this.MEA_CLOCKWISE = Math.abs(Utils.normalRelativeAngle((double)(ppmea.getEscapeAngle(1) - this.ABS_BEARING)));
        this.MEA_COUNTER_CLOCKWISE = Math.abs(Utils.normalRelativeAngle((double)(ppmea.getEscapeAngle(-1) - this.ABS_BEARING)));
        this.MEA = FastMath.asin(8.0 / this.WAVE_VELOCITY);
        this.CLOCKWISE_MEA_RATIO = this.MEA_CLOCKWISE / this.MEA;
        this.COUNTER_CLOCKWISE_MEA_RATIO = this.MEA_COUNTER_CLOCKWISE / this.MEA;
    }

    public void setReal(boolean real) {
        this.real = real;
    }

    public boolean isReal() {
        return this.real;
    }

    public void setGuessFactors(ArrayList<GuessFactor> guessFactors) {
        this.guessFactors = new ArrayList();
        for (GuessFactor guessFactor : guessFactors) {
            GuessFactor scaledGuessFactor = new GuessFactor(this.scaleGuessFactor(guessFactor.GUESS_FACTOR * (double)this.LATERAL_DIRECTION) * (double)this.LATERAL_DIRECTION, guessFactor.getWeight(), guessFactor.SCAN);
            this.guessFactors.add(scaledGuessFactor);
        }
    }

    public void setVirtualGunGuessFactors(ArrayList<Double> guessFactors) {
        this.virtualGunGuessFactors = guessFactors;
    }

    public ArrayList<Double> getVirtualGunGuessFactors() {
        return this.virtualGunGuessFactors;
    }

    public boolean update(Point2D.Double targetLocation) {
        this.distanceTraveled += this.WAVE_VELOCITY;
        return this.distanceTraveled > this.SOURCE.distance(targetLocation);
    }

    public double getFireAngle(double guessFactor) {
        return this.ABS_BEARING + guessFactor * this.MEA * (double)this.LATERAL_DIRECTION;
    }

    public double getGuessFactor(double x, double y) {
        double deltaAngle = Utils.normalRelativeAngle((double)(MoveUtils.absoluteBearing(this.SOURCE, new Point2D.Double(x, y)) - this.ABS_BEARING)) * (double)this.LATERAL_DIRECTION;
        return deltaAngle / this.MEA;
    }

    public double getPreciseGuessFactor(double x, double y) {
        double deltaAngle = Utils.normalRelativeAngle((double)(MoveUtils.absoluteBearing(this.SOURCE, new Point2D.Double(x, y)) - this.ABS_BEARING)) * (double)this.LATERAL_DIRECTION;
        return this.descaleGuessFactor(deltaAngle / this.MEA);
    }

    public double getDanger(double startGuessFactor, double endGuessFactor, double bandWidth) {
        double totalDanger = 0.0;
        for (GuessFactor guessFactor : this.guessFactors) {
            totalDanger += this.getDangerForOneGuessFactor(startGuessFactor, endGuessFactor, guessFactor, bandWidth);
        }
        return totalDanger;
    }

    private double getDangerForOneGuessFactor(double startGuessFactor, double endGuessFactor, GuessFactor guessFactor, double bandWidth) {
        double checkGuessFactor = guessFactor.GUESS_FACTOR;
        return this.integrateDanger(endGuessFactor - checkGuessFactor, startGuessFactor - checkGuessFactor, guessFactor.getWeight(), bandWidth);
    }

    private double integrateDanger(double value0, double value1, double weight, double bandWidth) {
        return value0 > 0.0 && value1 < 0.0 ? weight : 0.0;
    }

    private double scaleGuessFactor(double guessFactor) {
        return guessFactor * (guessFactor < 0.0 ? this.COUNTER_CLOCKWISE_MEA_RATIO : this.CLOCKWISE_MEA_RATIO);
    }

    private double descaleGuessFactor(double guessFactor) {
        return guessFactor * (guessFactor < 0.0 ? 1.0 / this.COUNTER_CLOCKWISE_MEA_RATIO : 1.0 / this.CLOCKWISE_MEA_RATIO);
    }

    public BattleInfo getInfo() {
        return this.INFO;
    }
}

