/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.movetree.nodes.modify.optimize;

import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.rMove.MoveUtils;
import dsekercioglu.mega.rMove.info.WaveData;
import dsekercioglu.mega.rMove.movetree.nodes.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CombineNode
extends Node {
    private final int MAP_BINS;
    private final Node[] NODES;

    public CombineNode(int mapBins, Node ... nodes) {
        this.MAP_BINS = mapBins;
        this.NODES = nodes;
    }

    @Override
    public List<GuessFactor> getGuessFactors(WaveData battleInfo) {
        ArrayList<GuessFactor> weightedGuessFactors = new ArrayList<GuessFactor>();
        List[] guessFactorMap = new List[this.MAP_BINS];
        Arrays.setAll(guessFactorMap, i -> new ArrayList());
        for (Node node : this.NODES) {
            List<GuessFactor> ithGuessFactors = node.getGuessFactors(battleInfo);
            block1: for (GuessFactor guessFactor : ithGuessFactors) {
                double gfValue = guessFactor.GUESS_FACTOR;
                int bin = (int)MoveUtils.limit(0.0, (gfValue + 1.0) * 0.5 * (double)this.MAP_BINS, this.MAP_BINS - 1);
                List guessFactors = guessFactorMap[bin];
                if (guessFactorMap[bin].isEmpty()) {
                    guessFactorMap[bin].add(guessFactor);
                    continue;
                }
                for (GuessFactor gf : guessFactors) {
                    if (gf.GUESS_FACTOR != gfValue) continue;
                    gf.setWeight(gf.getWeight() + guessFactor.getWeight());
                    continue block1;
                }
                guessFactors.add(guessFactor);
            }
        }
        for (List guessFactors : guessFactorMap) {
            weightedGuessFactors.addAll(guessFactors);
        }
        return weightedGuessFactors;
    }

    @Override
    public void addData(WaveData battleInfo, GuessFactor guessFactor, boolean real) {
        for (Node node : this.NODES) {
            node.addData(battleInfo, guessFactor, real);
        }
    }

    @Override
    public String toString() {
        return Arrays.toString(this.NODES);
    }
}

