/*
 * Decompiled with CFR 0.152.
 */
package robar.nano;

import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Mosquito
extends AdvancedRobot {
    static double prevE;
    static double direction;
    static double invChance;
    static double turnAm;
    static final double FP = 2.5;
    static final double BV = 12.5;

    public void run() {
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.setAdjustGunForRobotTurn(true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        double absB = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absB - this.getGunHeadingRadians() + e.getVelocity() * Math.sin(e.getHeadingRadians() - absB) / 12.5)));
        if (this.getEnergy() > 5.0) {
            this.setFire(2.5);
        }
        double d2 = prevE;
        prevE = e.getEnergy();
        if (d2 - d > 0.0) {
            turnAm = 40.0 * Math.random();
            if (Math.random() * 100.0 < invChance) {
                direction = -direction;
            }
            this.setAhead(500.0 * direction);
            this.setMaxVelocity(16.0 * Math.random());
        }
        this.setTurnRight(e.getBearing() + 90.0 + (e.getDistance() < 200.0 ? turnAm : -turnAm) * direction);
        this.setTurnRadarLeft(this.getRadarTurnRemaining());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        prevE += 3.0 * e.getPower();
    }

    public void onHitWall(HitWallEvent e) {
        if (invChance < 100.0) {
            direction = -direction;
        }
    }

    public void onDeath(DeathEvent e) {
        invChance = 1.0 / invChance;
    }

    static {
        direction = 1.0;
        invChance = 100.0;
    }
}

