/*
 * Decompiled with CFR 0.152.
 */
package syl.fire;

import java.util.ArrayList;
import java.util.HashMap;
import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.core.EnemyListener;
import syl.fire.FireStrategy;
import syl.util.Angle;
import syl.util.Coordinate;
import syl.util.RobotMath;
import syl.util.pattern.BoyerMoorePatternFinder;
import syl.util.pattern.PatternFinder;

public class PatternFireStrategy
extends FireStrategy
implements EnemyListener {
    private static final int MAX_HISTORY_SIZE = 1000;
    private static final int MIN_HISTORY_SIZE = 100;
    private static final int MIN_PATTERN_SIZE = 9;
    private static final int MAX_PATTERN_SIZE = 200;
    private long patternFindTime;
    private HashMap patterns = new HashMap();
    private Coordinate futurePosition;
    private long futurePositionTime;

    public PatternFireStrategy(BaseRobot robot) {
        super(robot);
    }

    public void initialize() {
        super.initialize();
        this.getRobot().getEnemyMap().addEnemyListener(this);
    }

    public boolean isEvasiveFireStrategy() {
        return false;
    }

    public Coordinate getFuturePosition(Enemy enemy, double firePower) {
        Pattern pattern = this.getPattern(enemy.getName());
        if (this.futurePositionTime != this.getRobot().getTime()) {
            this.futurePositionTime = this.getRobot().getTime();
            if (pattern.updatePattern()) {
                this.patternFindTime = this.getRobot().getTime();
                Coordinate targetCoordinate = enemy.getCoordinate();
                int i = 0;
                while (i < 10) {
                    double distance = targetCoordinate.getDistance(this.getRobot().getCoordinate());
                    long timeDifference = (int)Math.round(distance / RobotMath.getBulletVelocity(firePower));
                    targetCoordinate = pattern.getCoordinate(enemy.getCoordinate(), enemy.getHeading(), timeDifference);
                    if (targetCoordinate == null) {
                        this.futurePosition = enemy.getCoordinate();
                        return this.futurePosition;
                    }
                    ++i;
                }
                this.futurePosition = targetCoordinate;
                return this.futurePosition;
            }
            this.futurePosition = enemy.getCoordinate();
            return this.futurePosition;
        }
        return this.futurePosition;
    }

    public void onEnemyChange(Enemy enemy) {
        Pattern pattern = this.getPattern(enemy.getName());
        double velocity = enemy.getVelocity();
        double dHeading = enemy.getHeading() - enemy.getOldHeading();
        pattern.addReading(enemy.getScanTime(), velocity, dHeading);
    }

    public void onEnemyDeath(Enemy enemy) {
    }

    private Pattern getPattern(String enemyName) {
        Pattern pattern = (Pattern)this.patterns.get(enemyName);
        if (pattern == null) {
            pattern = new Pattern();
            this.patterns.put(enemyName, pattern);
        }
        return pattern;
    }

    class Pattern {
        private ArrayList history = new ArrayList();
        private ArrayList patternToFind = new ArrayList();
        private long lastDataUpdate;
        private int patternIndex;
        private int patternSize;
        private int newPatternSize;

        public Pattern() {
            this.history.add(new PatternTick(0.0, 0.0));
            this.patternSize = 9;
            this.newPatternSize = 9;
        }

        public void addReading(long time, double velocity, double headingChange) {
            long timeDifference = time - this.lastDataUpdate;
            PatternTick prevPatternTick = (PatternTick)this.history.get(this.history.size() - 1);
            double prevVelocity = prevPatternTick.getVelocity();
            double prevHeadingChange = prevPatternTick.getHeadingChange();
            double velocityTick = (velocity - prevVelocity) / (double)timeDifference;
            double headingTick = Angle.toRelativeAngle(headingChange) / (double)timeDifference;
            int i = 0;
            while ((long)i < timeDifference) {
                PatternTick patternTick = new PatternTick(prevVelocity + velocityTick, headingTick);
                this.history.add(patternTick);
                prevVelocity = patternTick.getVelocity();
                prevHeadingChange = patternTick.getHeadingChange();
                if (this.history.size() > 1000) {
                    this.history.remove(0);
                }
                ++i;
            }
            this.lastDataUpdate = time;
        }

        public boolean updatePattern() {
            if (this.history.size() < 100) {
                return false;
            }
            this.fillPatternToFind();
            BoyerMoorePatternFinder patternFinder = new BoyerMoorePatternFinder();
            this.patternIndex = this.findSmallerPattern(patternFinder);
            if (this.patternIndex != -1 && this.patternIndex < this.history.size() - this.newPatternSize) {
                int bigger = this.findBiggestPattern(patternFinder);
                if (bigger != -1 && bigger < this.history.size() - this.newPatternSize) {
                    this.patternIndex = bigger;
                }
                return true;
            }
            return false;
        }

        private int findBiggestPattern(PatternFinder patternFinder) {
            boolean goOn = true;
            int result = -1;
            while (goOn) {
                if (this.newPatternSize < 200) {
                    ++this.newPatternSize;
                } else {
                    goOn = false;
                }
                this.fillPatternToFind();
                result = patternFinder.findOne(this.history, this.patternToFind);
                if (result != -1 && result < this.history.size() - this.newPatternSize) continue;
                result = -1;
                goOn = false;
            }
            return result;
        }

        private int findSmallerPattern(PatternFinder patternFinder) {
            int result = -1;
            boolean goOn = true;
            while (goOn) {
                if (this.newPatternSize > 9) {
                    --this.newPatternSize;
                } else {
                    goOn = false;
                }
                this.fillPatternToFind();
                result = patternFinder.findOne(this.history, this.patternToFind);
                if (result == -1 && result >= this.history.size() - this.newPatternSize) continue;
                goOn = false;
            }
            return result;
        }

        public Coordinate getCoordinate(Coordinate origin, double heading, long timeDifference) {
            Coordinate result = origin.getClone();
            int movementStartIndex = this.patternIndex + this.patternSize;
            int i = 0;
            while ((long)i < timeDifference) {
                if (this.patternIndex + i >= this.history.size()) {
                    return null;
                }
                PatternTick historyTick = (PatternTick)this.history.get(this.patternIndex + i);
                heading = historyTick.applyPatternTick(result, heading);
                ++i;
            }
            return result;
        }

        private void fillPatternToFind() {
            this.patternToFind.clear();
            int i = this.history.size() - this.newPatternSize;
            while (i < this.history.size()) {
                this.patternToFind.add(this.history.get(i));
                ++i;
            }
        }

        class PatternTick {
            private double velocity;
            private double headingChange;

            public PatternTick(double velocity, double headingChange) {
                this.velocity = Math.round(velocity);
                this.headingChange = (double)Math.round(headingChange * 10.0) / 10.0;
            }

            public boolean equals(Object o) {
                if (o instanceof PatternTick) {
                    PatternTick tick = (PatternTick)o;
                    if (Math.abs(this.velocity - tick.velocity) == 0.0 && Math.abs(this.headingChange - tick.headingChange) < 2.0) {
                        return true;
                    }
                }
                return false;
            }

            public int hashCode() {
                return (int)this.velocity;
            }

            public double applyPatternTick(Coordinate coordinate, double heading) {
                coordinate.move(heading += this.headingChange, this.velocity);
                return heading;
            }

            public double getVelocity() {
                return this.velocity;
            }

            public double getHeadingChange() {
                return this.headingChange;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append('(').append(this.velocity).append(',').append(this.headingChange).append(')');
                return sb.toString();
            }
        }
    }
}

