/*
 * Decompiled with CFR 0.152.
 */
package lunchie;

import java.io.PrintStream;
import lunchie.Log;
import lunchie.MathUtils;
import lunchie.Position;
import lunchie.RobotEvent;

public class RobotInfo {
    static final int maxHistorySize = 10;
    private static final String className = "RobotInfo";
    private boolean alive = false;
    private RobotEvent[] history = new RobotEvent[10];
    private int numEvents = -1;
    private String myName = "?";

    public void init() {
        this.numEvents = -1;
        this.alive = true;
    }

    public void init(String name) {
        this.myName = name;
        this.init();
    }

    public void addBotEvent(RobotEvent botEvent) {
        if (this.numEvents < 0 || this.lastEvent().time < botEvent.time) {
            ++this.numEvents;
        }
        int eventIx = this.numEvents % 10;
        RobotEvent previous = this.prevEvent(3);
        if (previous != null) {
            botEvent.calcDifferentials(previous);
        }
        this.history[eventIx] = botEvent;
    }

    public RobotEvent lastEvent() {
        return this.prevEvent(0);
    }

    public RobotEvent prevEvent(int prevCount) {
        int prevIx = this.numEvents - prevCount;
        if (prevIx < 0 || prevCount > 10) {
            return null;
        }
        return this.history[prevIx % 10];
    }

    public String name() {
        return this.myName;
    }

    public boolean dead() {
        return !this.alive;
    }

    public boolean alive() {
        return this.alive;
    }

    public void hasDied() {
        this.alive = false;
    }

    private final int getNextIndex(int index) {
        return (index + 1) % 10;
    }

    private final int getPrevIndex(int index) {
        return (index - 1) % 10;
    }

    public boolean calcDifferentials() {
        boolean i = true;
        RobotEvent last = this.lastEvent();
        if (last != null) {
            int depth = 2;
            RobotEvent prev = null;
            while (prev == null && depth > 0) {
                prev = this.prevEvent(depth--);
            }
            if (prev != null) {
                last.calcDifferentials(prev);
                return true;
            }
        }
        return false;
    }

    public Position predict(double power, Position shooter, long now) {
        if (!this.calcDifferentials()) {
            return null;
        }
        Position pred = null;
        Position prevPred = null;
        RobotEvent last = this.lastEvent();
        double timeToTarget = 0.0;
        double range = 0.0;
        double posDiff = Position.ArenaMaxDist;
        int count = 0;
        long scanLag = now - last.time;
        if (scanLag > 1L) {
            last.updateRange(shooter);
        }
        while (posDiff > 15.0 && count < 4) {
            range = pred == null ? last.range : shooter.getRangeTo(pred);
            timeToTarget = range / (20.0 - 3.0 * power);
            Log.print(2, className, "predict", ++count + ": timeToTarget=" + timeToTarget + ": " + last.toString());
            prevPred = pred;
            pred = this._predict(timeToTarget + (double)scanLag, last);
            Log.print(2, className, "predict", count + ": pred " + pred.toString());
            if (pred == null || !pred.isInArena()) {
                return null;
            }
            if (prevPred == null) continue;
            posDiff = Math.abs(pred.getX() - prevPred.getX());
            Log.print(2, className, "predict", count + ": posdiff " + (posDiff += Math.abs(pred.getY() - prevPred.getY())));
        }
        return posDiff < 20.0 ? pred : null;
    }

    private final Position _predict(double timeToTarget, RobotEvent rEv) {
        double nx = rEv.pos.getX();
        double ny = rEv.pos.getY();
        if (Math.abs(rEv.av) < 0.01) {
            Log.print(2, className, "_predict", "linear: " + rEv.av);
            nx += timeToTarget * rEv.dx;
            ny += timeToTarget * rEv.dy;
        } else {
            Log.print(2, className, "_predict", "circular");
            double radius = rEv.velocity / rEv.av;
            double dTheta = timeToTarget * rEv.av;
            nx += radius * (Math.cos(rEv.headingR) - Math.cos(rEv.headingR + dTheta));
            ny += radius * (MathUtils.sin(rEv.headingR + dTheta) - MathUtils.sin(rEv.headingR));
        }
        return new Position(nx, ny, 20);
    }

    public void dump(PrintStream ostr) {
        ostr.println(this.myName + " : " + (this.numEvents + 1) + " events scanned");
        ostr.println("==============================");
        int i = 0;
        RobotEvent re = this.prevEvent(i);
        while (re != null) {
            re.dump(ostr);
            ostr.println();
            re = this.prevEvent(++i);
        }
        ostr.println();
    }

    public static double normaliseAngleR(double angleR) {
        while (angleR > Math.PI) {
            angleR -= Math.PI * 2;
        }
        while (angleR < -Math.PI) {
            angleR += Math.PI * 2;
        }
        return angleR;
    }

    public static double normaliseAngle(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static double normaliseHeadingR(double angleR) {
        while (angleR > Math.PI * 2) {
            angleR -= Math.PI * 2;
        }
        while (angleR < 0.0) {
            angleR += Math.PI * 2;
        }
        return angleR;
    }

    public static double normaliseHeading(double heading) {
        while (heading > 360.0) {
            heading -= 360.0;
        }
        while (heading < 0.0) {
            heading += 360.0;
        }
        return heading;
    }
}

