/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import java.awt.Color;
import robocode.Event;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.util.Utils;
import synapse.BaseBot;
import synapse.Enemy;
import synapse.Module;
import synapse.Scanner;
import synapse.Util;

public class SpotLight
extends Module
implements Scanner {
    private BaseBot bot;
    private int scanDirection = 1;
    private Enemy leastFresh;

    public SpotLight(BaseBot bot) {
        this.bot = bot;
    }

    @Override
    public void acquireTarget() {
        for (Enemy e : this.bot.targets.values()) {
            if (this.bot.target.live && !(e.distance + 100.0 < this.bot.target.distance)) continue;
            this.bot.target = e;
        }
    }

    @Override
    public void doTick() {
        if (this.bot.getOthers() > this.bot.targets.size() || this.bot.target == null) {
            this.bot.setTurnRadarLeftRadians(7.0);
        } else {
            boolean newLeastFresh = false;
            if (this.leastFresh == null) {
                this.leastFresh = this.bot.target;
            }
            for (Enemy e : this.bot.targets.values()) {
                if (!e.live || e.ctime > this.leastFresh.ctime || this.leastFresh == e) continue;
                this.leastFresh = e;
                newLeastFresh = true;
            }
            double h = Utils.normalRelativeAngle((double)(this.bot.getRadarHeadingRadians() - Util.absoluteBearing(this.bot.location, this.leastFresh.location)));
            h += Math.signum(h) * Math.asin(Math.min(1.0, ((double)(this.bot.time - this.leastFresh.ctime) + Math.abs(h) / (Rules.RADAR_TURN_RATE_RADIANS - Rules.GUN_TURN_RATE_RADIANS)) * 8.0 / this.leastFresh.distance));
            if (!newLeastFresh && this.leastFresh.ctime < this.bot.time) {
                this.bot.setTurnRadarLeftRadians((double)this.scanDirection * Rules.RADAR_TURN_RATE_RADIANS);
            } else {
                this.scanDirection = (int)(Math.signum(h) == 0.0 ? (double)this.scanDirection : Math.signum(h));
                this.bot.setTurnRadarLeftRadians(h);
            }
        }
    }

    @Override
    public void useEvent(Event evt) {
        if (evt instanceof RobotDeathEvent && this.bot.getOthers() == 1) {
            this.setDuelColors();
        }
    }

    @Override
    public String toString() {
        return "SpotLight";
    }

    @Override
    public void setDuelColors() {
        this.bot.setScanColor(new Color(0.3f, 0.3f, 0.3f));
    }
}

