/*
 * Decompiled with CFR 0.152.
 */
package TNT;

import TNT.Coordinate;
import TNT.Pattern;
import TNT.Recon;
import TNT.ReconCollection;
import TNT.TNTMath;
import java.util.Hashtable;
import java.util.Map;

class StrafingPattern
implements Pattern {
    private static final long ALLOWABLE_TIME_DIFFERENCE = 10L;
    private static final float ALLOWABLE_MATCH_PERCENTAGE = 0.7f;
    private Map data = new Hashtable();

    public Coordinate estimatePosition(double in_x, double in_y, double in_velocity, double in_time, double in_heading, ReconCollection in_collection) {
        long time = ((StrafingPatternData)this.data.get((Object)in_collection.get((int)0).getName())).strafTurnTime;
        CriticalPoint iLastDirectionChange = this.findDirectionChange(in_collection.toArray(), 0);
        if (iLastDirectionChange != null) {
            long lastDirectionChangeTime = iLastDirectionChange.zeroTime;
            long turnCountDown = time - (in_collection.get(0).getTime() - lastDirectionChangeTime);
            double secondAngle = in_collection.get(0).getAngle();
            double firstAngle = in_collection.get(1).getAngle();
            double angleChange = TNTMath.normalRelativeAngle(secondAngle - firstAngle) / (double)(in_collection.get(0).getTime() - in_collection.get(1).getTime());
            double acceleration = in_collection.get(0).getVelocity() - in_collection.get(1).getVelocity();
            acceleration = acceleration > 0.0 ? 1 : (acceleration == 0.0 ? 0 : -2);
            Coordinate currentPosition = new Coordinate(in_x, in_y);
            int roundTime = Math.round((float)in_time);
            if (in_collection.notMovingForTerms(2)) {
                return new Coordinate(in_collection.get(0).getX(), in_collection.get(0).getY());
            }
            int iCounter = 0;
            while (iCounter < roundTime) {
                if (turnCountDown <= 0L && in_velocity <= 0.0) {
                    in_heading = TNTMath.normalAbsoluteAngle(in_heading + Math.PI);
                    acceleration = 1.0;
                    in_velocity = 0.0;
                    turnCountDown = time;
                } else {
                    acceleration = in_velocity + (double)(-2L * turnCountDown) >= 0.0 ? -2.0 : 1.0;
                }
                in_velocity = in_velocity > 8.0 ? 8.0 : (in_velocity < 0.0 ? 0.0 : (in_velocity += acceleration));
                in_heading = TNTMath.normalAbsoluteAngle(in_heading + angleChange);
                currentPosition.setX(currentPosition.getX() + Math.sin(in_heading) * in_velocity);
                currentPosition.setY(currentPosition.getY() + Math.cos(in_heading) * in_velocity);
                --turnCountDown;
                ++iCounter;
            }
            in_heading = TNTMath.normalAbsoluteAngle(in_heading + angleChange * (in_time - (double)roundTime));
            currentPosition.setX(currentPosition.getX() + Math.sin(in_heading) * (in_velocity * (in_time - (double)roundTime)));
            currentPosition.setY(currentPosition.getY() + Math.cos(in_heading) * (in_velocity * (in_time - (double)roundTime)));
            return currentPosition;
        }
        return null;
    }

    private final CriticalPoint findDirectionChange(Recon[] in_strand, int in_startingWith) {
        if (in_strand[in_startingWith] != null) {
            short currentDirection = in_strand[in_startingWith].getDirection();
            int iCounter = in_startingWith;
            while (iCounter < in_strand.length) {
                if (in_strand[iCounter] != null && in_strand[iCounter].getDirection() != currentDirection) {
                    CriticalPoint out = new CriticalPoint();
                    out.firstIndex = iCounter;
                    long currentTime = in_strand[iCounter].getTime();
                    long previousTime = in_strand[iCounter - 1].getTime();
                    double currentVelocity = in_strand[iCounter].getVelocity();
                    double previousVelocity = in_strand[iCounter - 1].getVelocity();
                    if (currentVelocity == 0.0) {
                        out.zeroTime = currentTime;
                    } else if (currentVelocity > previousVelocity) {
                        out.zeroTime = (long)((double)previousTime - previousVelocity);
                    } else if (currentVelocity < previousVelocity) {
                        out.zeroTime = currentTime + Math.round(currentVelocity / 2.0);
                    } else {
                        double firstEstimate = (double)currentTime + 2.0 % currentVelocity;
                        double secondEstimate = (double)previousTime - previousVelocity;
                        out.zeroTime = Math.round((firstEstimate + secondEstimate) / 2.0);
                    }
                    return out;
                }
                ++iCounter;
            }
        }
        return null;
    }

    public boolean test(Recon[] in_strand) {
        CriticalPoint nextInstance;
        CriticalPoint indexOfFirstOccurance = this.findDirectionChange(in_strand, 0);
        if (indexOfFirstOccurance != null && (nextInstance = this.findDirectionChange(in_strand, indexOfFirstOccurance.firstIndex)) != null) {
            float iNumberOfAnomolies = 0.0f;
            float iNumberOfMatches = 0.0f;
            CriticalPoint indexOfLastOccurance = nextInstance;
            long timeTaken = indexOfFirstOccurance.zeroTime - nextInstance.zeroTime;
            long currentTime = 0L;
            while ((nextInstance = this.findDirectionChange(in_strand, indexOfLastOccurance.firstIndex)) != null) {
                currentTime = indexOfLastOccurance.zeroTime - nextInstance.zeroTime;
                if (timeTaken - 10L <= currentTime && timeTaken + 10L >= currentTime) {
                    iNumberOfMatches += 1.0f;
                } else {
                    iNumberOfAnomolies += 1.0f;
                }
                indexOfLastOccurance = nextInstance;
            }
            if (iNumberOfMatches + iNumberOfAnomolies != 0.0f && iNumberOfMatches / (iNumberOfMatches + iNumberOfAnomolies) >= 0.7f) {
                this.data.put(in_strand[0].getName(), new StrafingPatternData(timeTaken));
                return true;
            }
        }
        return false;
    }

    StrafingPattern() {
    }

    public class CriticalPoint {
        public long zeroTime = -1L;
        public int firstIndex = -1;
    }

    private class StrafingPatternData {
        public long strafTurnTime = 0L;

        public StrafingPatternData(long time) {
            this.strafTurnTime = time;
        }
    }
}

