/*
 * Decompiled with CFR 0.152.
 */
package TNT;

import TNT.ConditionalTNTStrategy;
import TNT.TNT;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

abstract class TNTStrategyManager {
    private List m_availableStrategies;
    private ConditionalTNTStrategy m_currentStrategy = null;
    protected TNT m_owner;

    public void addStrategy(ConditionalTNTStrategy in_strat) {
        this.m_availableStrategies.add(in_strat);
    }

    public void setStrategy(ConditionalTNTStrategy in_strat) {
        this.resetStrategy();
        this.m_currentStrategy = in_strat;
        this.operateStrategy(this.m_currentStrategy);
    }

    public void operate() {
        if (this.m_currentStrategy == null || this.m_currentStrategy.expiredStrategy()) {
            this.selectBestStrategy();
        }
        if (this.m_currentStrategy != null) {
            this.operateStrategy(this.m_currentStrategy);
        }
    }

    public void selectBestStrategy() {
        this.m_currentStrategy = null;
        int numberOfStrategies = this.m_availableStrategies.size();
        ArrayList<ConditionalTNTStrategy> subList = new ArrayList<ConditionalTNTStrategy>();
        int subListSize = 0;
        ConditionalTNTStrategy temp = null;
        int iCounter = 0;
        while (iCounter < numberOfStrategies) {
            temp = (ConditionalTNTStrategy)this.m_availableStrategies.get(iCounter);
            if (temp.shouldUseStrategy()) {
                subList.add(temp);
            }
            ++iCounter;
        }
        subListSize = subList.size();
        if (this.m_availableStrategies.size() > 0 && subListSize == 0) {
            this.m_currentStrategy = (ConditionalTNTStrategy)this.m_availableStrategies.get(0);
        } else if (subListSize > 0) {
            iCounter = 0;
            while (iCounter < subListSize) {
                temp = (ConditionalTNTStrategy)subList.get(iCounter);
                if (this.m_currentStrategy == null) {
                    this.m_currentStrategy = temp;
                } else if (temp.getStrategyDominence() > this.m_currentStrategy.getStrategyDominence()) {
                    this.m_currentStrategy = temp;
                }
                ++iCounter;
            }
            this.resetStrategy();
        }
    }

    public ConditionalTNTStrategy getStrategy() {
        return this.m_currentStrategy;
    }

    public abstract void operateStrategy(ConditionalTNTStrategy var1);

    public abstract void resetStrategy();

    public TNTStrategyManager(TNT in_owner) {
        this.m_owner = in_owner;
        this.m_availableStrategies = new Vector();
    }
}

