/*
 * Decompiled with CFR 0.152.
 */
package ustimaw;

import java.io.Serializable;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.Rules;
import ustimaw.Nightmare;

class Score
implements Serializable {
    double threshold;
    int round;
    double ss;
    double bd;
    double ours;
    double enemys;
    double sours;
    double senemys;
    boolean isEnded;
    int nupdates;

    Score() {
    }

    void setThreshold(double d) {
        this.threshold = d;
    }

    void onRobotDeath(Nightmare n, String s) {
        if (n.isTeammate(s)) {
            this.enemys += (double)(50 * n.getLivingEnemys().length);
        } else {
            this.ours += (double)(50 * n.getLivingAllTeammates().length);
            this.ss += (double)(50 * n.getLivingAllTeammates().length);
        }
        if (n.getLivingEnemys().length == 0) {
            this.isEnded = true;
            this.ours += (double)(50 * n.getLivingAllTeammates().length);
        } else if (n.getLivingAllTeammates().length == 0) {
            this.isEnded = true;
            this.enemys += (double)(50 * n.getLivingEnemys().length);
        }
    }

    void onHitByBullet(Nightmare n, HitByBulletEvent e) {
        if (!n.isTeammate(e.getName())) {
            this.senemys += Rules.getBulletDamage((double)e.getPower());
            if (n.getEnergy() == 0.0) {
                this.senemys += 20.0;
            }
        }
    }

    void onBulletHit(Nightmare n, BulletHitEvent e) {
        if (!n.isTeammate(e.getName())) {
            this.sours += Rules.getBulletDamage((double)e.getBullet().getPower());
            this.bd += Rules.getBulletDamage((double)e.getBullet().getPower());
            if (e.getEnergy() == 0.0) {
                this.sours += 20.0;
            }
        }
    }

    void onHitRobot(Nightmare n, HitRobotEvent e) {
        if (!n.isTeammate(e.getName())) {
            if (e.isMyFault()) {
                this.sours += 1.2;
                if (e.getEnergy() == 0.0) {
                    this.sours += 30.0;
                }
            } else {
                this.senemys += 1.2;
                if (n.getEnergy() == 0.0) {
                    this.senemys += 30.0;
                }
            }
        }
    }

    void update(Score s) {
        if (s.isEnded) {
            this.ss = s.ss;
            this.ours = s.ours;
            this.enemys = s.enemys;
        }
        this.senemys += s.senemys;
        this.sours += s.sours;
        this.bd += s.bd;
        ++this.nupdates;
    }

    double getPercent() {
        return (this.ours + this.sours) / (this.ours + this.sours + this.enemys + this.senemys);
    }

    void print(Robot r) {
        r.out.println("SS\t" + this.ss);
        r.out.println("BD\t" + this.bd);
    }
}

