/*
 * Decompiled with CFR 0.152.
 */
package barontrozo;

import java.awt.geom.Point2D;
import robocode.Rules;
import robocode.util.Utils;

public class ChooseStrategicPosition {
    double midFieldWidth_;
    double midFieldHeight_;
    double modifier_;
    boolean wasLeft_;
    boolean wasDown_;
    double desiredLen_;
    double minLimit_;
    double maxXLimit_;
    double maxYLimit_;

    public ChooseStrategicPosition(double fieldWidth, double fieldHeight, double minLimit, int turns) {
        this.midFieldWidth_ = fieldWidth / 2.0;
        this.midFieldHeight_ = fieldHeight / 2.0;
        this.modifier_ = Math.sin(0.7853981633974483);
        this.wasLeft_ = true;
        this.wasDown_ = true;
        this.desiredLen_ = Rules.getBulletSpeed((double)2.0) * (double)turns;
        this.minLimit_ = minLimit;
        this.maxXLimit_ = fieldWidth - minLimit;
        this.maxYLimit_ = fieldHeight - minLimit;
    }

    public void CalculateStrategicPoint(Point2D.Double enemyPosition, Point2D.Double myPosition, Point2D.Double strategicPosition) {
        double y;
        double x;
        if (this.wasLeft_ && enemyPosition.getX() < this.midFieldWidth_ * 1.2) {
            x = enemyPosition.getX() + this.modifier_ * this.desiredLen_;
            this.wasLeft_ = true;
        } else if (enemyPosition.getX() < this.midFieldWidth_ * 0.8) {
            x = enemyPosition.getX() + this.modifier_ * this.desiredLen_;
            this.wasLeft_ = true;
        } else {
            x = enemyPosition.getX() - this.modifier_ * this.desiredLen_;
            this.wasLeft_ = false;
        }
        if (this.wasDown_ && enemyPosition.getY() < this.midFieldHeight_ * 1.2) {
            y = enemyPosition.getY() + this.modifier_ * this.desiredLen_;
            this.wasDown_ = true;
        } else if (enemyPosition.getY() < this.midFieldHeight_ * 0.8) {
            y = enemyPosition.getY() + this.modifier_ * this.desiredLen_;
            this.wasDown_ = true;
        } else {
            y = enemyPosition.getY() - this.modifier_ * this.desiredLen_;
            this.wasDown_ = false;
        }
        strategicPosition.setLocation(x, y);
        double dist = myPosition.distance(enemyPosition);
        if (dist < this.desiredLen_ / 2.0) {
            double angle = Math.atan2(myPosition.getX() - enemyPosition.getX(), myPosition.getY() - enemyPosition.getY());
            double ang1 = Utils.normalAbsoluteAngle((double)(angle + 0.7853981633974483));
            double ang2 = Utils.normalAbsoluteAngle((double)(angle - 0.7853981633974483));
            Point2D.Double p1 = new Point2D.Double(myPosition.getX() + Math.sin(ang1) * this.desiredLen_, myPosition.getY() + Math.cos(ang1) * this.desiredLen_);
            Point2D.Double p2 = new Point2D.Double(myPosition.getX() + Math.sin(ang2) * this.desiredLen_, myPosition.getY() + Math.cos(ang2) * this.desiredLen_);
            if (p1.distance(strategicPosition) < p2.distance(strategicPosition)) {
                strategicPosition.setLocation(p1);
            } else {
                strategicPosition.setLocation(p2);
            }
        }
        if (strategicPosition.getX() < this.minLimit_) {
            strategicPosition.x = this.minLimit_;
        }
        if (strategicPosition.getY() < this.minLimit_) {
            strategicPosition.y = this.minLimit_;
        }
        if (strategicPosition.getX() > this.maxXLimit_) {
            strategicPosition.x = this.maxXLimit_;
        }
        if (strategicPosition.getY() > this.maxYLimit_) {
            strategicPosition.y = this.maxYLimit_;
        }
    }
}

