/*
 * Decompiled with CFR 0.152.
 */
package barontrozo;

import java.awt.geom.Point2D;
import robocode.Rules;
import robocode.util.Utils;

public class GotoManoeubre {
    Point2D.Double objetive_;
    Point2D.Double tank_;
    Point2D.Double pointPerpendicular_;
    double vel_;
    double heading_;
    double orderAhead_;
    double orderHeading_;
    double minLimit_;
    double maxXLimit_;
    double maxYLimit_;
    int turnToReach_;
    static double[] orderAheadInd_ = new double[]{0.0, 2.0, 6.0, 12.0, 20.0};
    static double[][] orderAheadDistances_ = new double[][]{{0.0, 2.0, 4.0, 6.0, 8.0}, {0.0, 2.0, 6.0, 10.0, 14.0}, {0.0, 2.0, 6.0, 12.0, 20.0}};

    public GotoManoeubre(double minLimit, double maxXLimit, double maxYLimit) {
        this.minLimit_ = minLimit;
        this.maxXLimit_ = maxXLimit;
        this.maxYLimit_ = maxYLimit;
    }

    public void SetObjetive(Point2D.Double objetive, int turnsToReach) {
        this.objetive_ = objetive;
        this.turnToReach_ = turnsToReach;
    }

    public void SetTankStatus(Point2D.Double tank, double heading, double vel) {
        this.tank_ = tank;
        this.heading_ = heading;
        this.vel_ = vel;
    }

    public void IfPosiblePerpendicularTo(Point2D.Double pointPerpendicular) {
        this.pointPerpendicular_ = pointPerpendicular;
    }

    public void GetMinimumReachAHead() {
        int turn = this.turnToReach_ - 1;
        if (turn < 0) {
            turn = 0;
        }
        int i = 0;
        while (i < orderAheadInd_.length) {
            if (this.orderAhead_ <= orderAheadDistances_[turn][i]) break;
            ++i;
        }
        if (i == orderAheadInd_.length) {
            i = orderAheadInd_.length - 1;
        }
        this.orderAhead_ = orderAheadInd_[i];
    }

    public void CalculateMovement() {
        this.orderHeading_ = Utils.normalRelativeAngle((double)(Math.atan2(this.objetive_.getX() - this.tank_.getX(), this.objetive_.getY() - this.tank_.getY()) - this.heading_));
        this.orderAhead_ = this.tank_.distance(this.objetive_);
        if (Math.abs(this.orderHeading_) > 1.5707963267948966) {
            this.orderHeading_ = Utils.normalRelativeAngle((double)(this.orderHeading_ + Math.PI));
            this.orderAhead_ = -this.orderAhead_;
        }
        if (Math.abs(this.orderAhead_) < 2.0) {
            this.orderAhead_ = 0.0;
            this.orderHeading_ = Utils.normalRelativeAngle((double)(Math.atan2(this.pointPerpendicular_.getX() - this.tank_.getX(), this.pointPerpendicular_.getY() - this.tank_.getY()) + 1.5707963267948966 - this.heading_));
            if (Math.abs(this.orderHeading_) > 1.5707963267948966) {
                this.orderHeading_ = Utils.normalRelativeAngle((double)(this.orderHeading_ + Math.PI));
            }
        }
        double workHeading = this.heading_;
        double variation = Rules.getTurnRateRadians((double)this.vel_);
        double var = this.orderHeading_;
        workHeading = Math.abs(var) > variation ? (workHeading += var) : (var > 0.0 ? (workHeading += variation) : (workHeading -= variation));
        workHeading = Utils.normalAbsoluteAngle((double)workHeading);
        if (this.turnToReach_ <= 3 && Math.abs(this.orderAhead_) < 20.0) {
            this.GetMinimumReachAHead();
        }
        double x = this.tank_.getX() + Math.sin(workHeading) * this.orderAhead_;
        double y = this.tank_.getY() + Math.cos(workHeading) * this.orderAhead_;
        if (x < this.minLimit_) {
            this.orderAhead_ = 0.0;
        }
        if (y < this.minLimit_) {
            this.orderAhead_ = 0.0;
        }
        if (x > this.maxXLimit_) {
            this.orderAhead_ = 0.0;
        }
        if (y > this.maxYLimit_) {
            this.orderAhead_ = 0.0;
        }
    }
}

