/*
 * Decompiled with CFR 0.152.
 */
package xander.cat;

import java.awt.geom.Path2D;
import xander.cat.drive.GreenBeeSurfSelector;
import xander.cat.radar.BasicRadar;
import xander.core.AbstractXanderRobot;
import xander.core.ComponentChain;
import xander.core.drive.DistancingEquation;
import xander.core.drive.DriveBoundsFactory;
import xander.core.gun.XanderGun;
import xander.core.gun.power.FixedPowerSelector;
import xander.gfws.data.DataPointFactorArrayProcessor;
import xander.gfws.data.FactorArrayParms;
import xander.gfws.data.KDTreeWaveLogger;
import xander.gfws.data.KNNLogReader;
import xander.gfws.data.KNNParms;
import xander.gfws.drive.DirectWaveSurfingDrive;
import xander.gfws.gun.targeter.GuessFactorTargeter;
import xander.gfws.modifier.LinearFactorArrayModifier;
import xander.gfws.processor.FAMFactorArrayProcessor;
import xander.gfws.segment.AttackerBearingSegmenter;
import xander.gfws.segment.BulletTravelTimeSegmenter;
import xander.gfws.segment.DefenderAccelerationSegmenter;
import xander.gfws.segment.DefenderSpeedSegmenter;
import xander.gfws.segment.WallStickSegmenter;

public class SamAxe
extends AbstractXanderRobot {
    @Override
    protected void addComponents(ComponentChain chain) {
        chain.addDefaultComponents(new BasicRadar(45.0, 5.0));
        Path2D.Double driveBounds = DriveBoundsFactory.getSmoothedRectangleBounds(this.getBattleFieldSize());
        DistancingEquation de = new DistancingEquation(80.0, 400.0, 600.0, 75.0, 40.0);
        LinearFactorArrayModifier fam = new LinearFactorArrayModifier(3.0);
        FAMFactorArrayProcessor driveFAP = new FAMFactorArrayProcessor(false, 67, fam);
        GreenBeeSurfSelector surfSelector = new GreenBeeSurfSelector(driveFAP, de);
        DirectWaveSurfingDrive mainDrive = new DirectWaveSurfingDrive("AL Drive", surfSelector, driveBounds);
        chain.addDefaultComponents(mainDrive);
        FixedPowerSelector mainPowerSelector = new FixedPowerSelector(1.85);
        KDTreeWaveLogger gunWaveLogger = new KDTreeWaveLogger(true, new DefenderSpeedSegmenter(16), new BulletTravelTimeSegmenter(24, this.getBattleFieldSize()), new DefenderAccelerationSegmenter(), new AttackerBearingSegmenter(24), new WallStickSegmenter(4, 60.0, 260.0, true), new WallStickSegmenter(4, 60.0, 260.0, false));
        KNNParms gunKNNParms = new KNNParms(20, 100, 0.05);
        gunKNNParms.setKnnWhenSelectionEmpty(0);
        KNNLogReader gunLogReader = new KNNLogReader(gunWaveLogger, gunKNNParms);
        FactorArrayParms gunFactorArrayParms = new FactorArrayParms(true);
        DataPointFactorArrayProcessor gunFAP = new DataPointFactorArrayProcessor(gunLogReader, 91, gunFactorArrayParms);
        GuessFactorTargeter targeter = new GuessFactorTargeter(gunFAP);
        XanderGun gun = new XanderGun("GF Gun", targeter, mainPowerSelector);
        gun.setMinEnergyToFire(4.1);
        gun.setLowEnergyConservationRate(0.3333333333333333);
        chain.addDefaultComponents(gun);
    }
}

