/*
 * Decompiled with CFR 0.152.
 */
package kid.info;

import java.io.PrintStream;
import kid.info.RobotInfo;
import kid.utils.Utils;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;

public class GunInfo
extends RobotInfo {
    private static final long serialVersionUID = -477733568063030206L;
    public static final double GUN_TURN_RATE = 20.0;

    public GunInfo(Robot myRobot) {
        super(myRobot);
        this.init(myRobot);
    }

    protected GunInfo(GunInfo myRobot) {
        super(myRobot);
        this.init(myRobot.robot);
    }

    private void init(Robot myRobot) {
        this.robot = myRobot;
    }

    @Override
    public double getHeading() {
        return this.robot.getGunHeading();
    }

    @Override
    public double getTurnRemaining() {
        if (this.robot instanceof AdvancedRobot) {
            AdvancedRobot myRobot = (AdvancedRobot)this.robot;
            return myRobot.getGunTurnRemaining();
        }
        return 0.0;
    }

    @Override
    public int getTurningSign() {
        return this.getTurnRemaining() == 0.0 ? 0 : Utils.sign(this.getTurnRemaining());
    }

    public double getHeat() {
        return this.robot.getGunHeat();
    }

    @Override
    public void print(PrintStream console) {
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    @Override
    public Object clone() {
        return new GunInfo(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GunInfo) {
            GunInfo robot = (GunInfo)obj;
            return robot.robot.getName().equals(this.robot.getName());
        }
        return false;
    }

    @Override
    public String toString() {
        return new String();
    }

    @Override
    protected void finalize() {
        this.robot = null;
    }
}

