/*
 * Decompiled with CFR 0.152.
 */
package kneels;

import robocode.AdvancedRobot;
import robocode.GunTurnCompleteCondition;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RateControlRobot;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;

public class ToNoone
extends RateControlRobot {
    private static final int STATE_SEEK = 0;
    private static final int STATE_HIDE = 1;
    private static final int MIN_DIST = 150;
    private static final int ROT_RATE_ESCAPE = 20;
    private static final int TOP = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 4;
    private static final int RIGHT = 8;
    private double escapeDirection;
    private int actionState;
    private String attacking;
    private GunTurnCompleteCondition gunTurn;

    private void handlerSeek() {
        this.setVelocityRate(15.0);
        this.execute();
    }

    private void handlerHide() {
        this.setTurnRate(this.escapeDirection);
        this.setVelocityRate(20.0);
        this.execute();
    }

    public void run() {
        this.gunTurn = new GunTurnCompleteCondition((AdvancedRobot)this);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(false);
        this.setAdjustRadarForRobotTurn(true);
        this.actionState = 0;
        this.setRadarRotationRate(45.0);
        this.setVelocityRate(15.0);
        this.execute();
        while (true) {
            int lastAction = this.actionState;
            double x = this.getX();
            double y = this.getY();
            double w = this.getBattleFieldWidth();
            double h = this.getBattleFieldHeight();
            int hitDir = 0;
            hitDir = x < 150.0 && this.getHeading() > 180.0 ? 4 : 0;
            hitDir = w - x < 150.0 && this.getHeading() < 180.0 ? 8 : hitDir;
            hitDir = h - y < 150.0 && (this.getHeading() < 90.0 || this.getHeading() > 270.0) ? 1 : hitDir;
            hitDir = y < 150.0 && this.getHeading() > 90.0 && this.getHeading() < 270.0 ? 2 : hitDir;
            switch (hitDir) {
                case 1: {
                    this.escapeDirection = this.getHeading() > 90.0 ? -20 : 20;
                    break;
                }
                case 8: {
                    this.escapeDirection = this.getHeading() < 90.0 ? -20 : 20;
                    break;
                }
                case 4: {
                    this.escapeDirection = this.getHeading() < 270.0 ? -20 : 20;
                    break;
                }
                case 2: {
                    this.escapeDirection = this.getHeading() < 90.0 ? -20 : 20;
                }
            }
            this.actionState = hitDir != 0 ? 1 : 0;
            if (this.actionState != lastAction) {
                System.out.println("new state = " + this.actionState + " with dir " + hitDir);
                switch (this.actionState) {
                    case 0: {
                        this.handlerSeek();
                        break;
                    }
                    case 1: {
                        this.handlerHide();
                    }
                }
                continue;
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.attacking == null) {
            this.attacking = e.getName();
        }
        if (this.actionState != 1) {
            double bodyRotNeeded = e.getBearing() + this.getHeading();
            while (bodyRotNeeded < -180.0) {
                bodyRotNeeded += 360.0;
            }
            while (bodyRotNeeded > 180.0) {
                bodyRotNeeded -= 360.0;
            }
            if (Math.abs(bodyRotNeeded) < 45.0) {
                this.setTurnRate(0.0);
            } else {
                this.setTurnRate(bodyRotNeeded);
            }
        }
        if (this.attacking != e.getName()) {
            return;
        }
        this.setRadarRotationRate(-this.getRadarRotationRate());
        double rotNeeded = e.getBearing() + this.getHeading() - this.getGunHeading();
        while (rotNeeded < -180.0) {
            rotNeeded += 360.0;
        }
        while (rotNeeded > 180.0) {
            rotNeeded -= 360.0;
        }
        if (Math.abs(rotNeeded) < 20.0) {
            this.fire(10.0);
        }
        if (this.gunTurn.test()) {
            if (rotNeeded > 180.0) {
                this.turnGunLeft(360.0 - rotNeeded);
            } else {
                this.turnGunRight(rotNeeded);
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent event) {
        if (event.getName() == this.attacking) {
            this.attacking = null;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRoundEnded(RoundEndedEvent event) {
        System.out.println("round ended with event: " + event);
    }
}

