/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.Iterator;
import java.util.LinkedList;
import pa3k.CalendarMovingTask;
import pa3k.CircleMoving;
import pa3k.Log;
import pa3k.Tracking;
import robocode.AdvancedRobot;

public class CalendarMoving
extends CircleMoving {
    protected LinkedList<CalendarMovingTask> calendar = new LinkedList();

    public CalendarMoving(AdvancedRobot robot, Tracking tracking) {
        super(robot, tracking);
    }

    protected void addTask(CalendarMovingTask t) {
        Iterator i = this.calendar.iterator();
        int c = 0;
        while (i.hasNext()) {
            CalendarMovingTask tmp = (CalendarMovingTask)i.next();
            if (tmp.getTime() > t.getTime()) break;
            ++c;
        }
        this.calendar.add(c, t);
    }

    protected void addFirstTaskRemoveRest(CalendarMovingTask t) {
        if (this.calendar.size() == 0 || this.calendar.peekFirst().time > t.time) {
            this.calendar = new LinkedList();
            this.calendar.add(t);
        }
    }

    @Override
    public void turn() {
        long currentTime = this.robot.getTime();
        CalendarMovingTask t = this.calendar.peekFirst();
        if (t != null && t.time <= currentTime) {
            Log.log(3, "Calendar@" + currentTime + ": Executing task(" + t.time + ")");
            this.calendar.removeFirst();
            t.execute(this);
        }
        super.turn();
    }
}

