/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import pa3k.Log;
import pa3k.Opponent;
import robocode.Bullet;
import robocode.Robot;
import robocode.util.Utils;

public class Position
extends Point2D.Double {
    private static double BATTLEFIELD_WIDTH;
    private static double BATTLEFIELD_HEIGHT;
    private boolean wasWallCorrected = false;
    private static final long serialVersionUID = 5324881552676729162L;

    public static void setBattleField(Robot r) {
        BATTLEFIELD_WIDTH = r.getBattleFieldWidth();
        BATTLEFIELD_HEIGHT = r.getBattleFieldHeight();
    }

    public static Position getCenter() {
        return new Position(BATTLEFIELD_WIDTH / 2.0, BATTLEFIELD_HEIGHT / 2.0);
    }

    public Position(Robot r) {
        this.x = r.getX();
        this.y = r.getY();
    }

    public Position(Position p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Position() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Position(double x, double y) {
        super(x, y);
    }

    public Position(Bullet bullet) {
        super(bullet.getX(), bullet.getY());
    }

    public double getDirectionTo(Position position) {
        double diffX = position.x - this.x;
        double diffY = position.y - this.y;
        if (diffX > -0.001 && diffX < 0.001) {
            return diffY > 0.0 ? 0.0 : Math.PI;
        }
        double dir = Math.atan(diffY / diffX);
        if (diffX < 0.0) {
            dir += Math.PI;
        }
        dir -= 1.5707963267948966;
        return Utils.normalAbsoluteAngle((double)(dir *= -1.0));
    }

    public Position computeEscapePosition(Position bulletSource, Position bulletTarget, double bulletSpeed, double velocity, double heading, int direction, double maxVelocity) {
        Position r = new Position(this);
        double angle = r.getDirectionTo(bulletSource);
        double angle1 = Utils.normalAbsoluteAngle((double)(angle + 1.5707963267948966));
        double angle2 = Utils.normalAbsoluteAngle((double)(angle - 1.5707963267948966));
        angle = Math.abs(Utils.normalRelativeAngle((double)(heading - angle1))) < Math.abs(Utils.normalRelativeAngle((double)(heading - angle2))) ? angle1 : angle2;
        double bulletSpeedSQ = Math.pow(bulletSpeed, 2.0);
        double t = bulletSource.distance(bulletTarget) / bulletSpeed - 1.0;
        double tSQ = Math.pow(t, 2.0);
        double v = maxVelocity;
        double vSQ = Math.pow(v, 2.0);
        double u = 0.0;
        double d = 0.0;
        if (direction == 1) {
            u = (v - Math.abs(velocity)) / 1.0;
            d = (v - Math.abs(velocity)) / 2.0 * u;
        } else {
            u = Math.abs(velocity) / 2.0;
            d = -Math.abs(velocity) / 2.0 * u;
            double uu = v / 1.0;
            u += uu;
            d += v / 2.0 * uu;
        }
        double uSQ = Math.pow(u, 2.0);
        double a = bulletSpeedSQ - vSQ;
        double b = 2.0 * (t * bulletSpeedSQ - vSQ * t + vSQ * u - v * d);
        double c = -tSQ * vSQ + 2.0 * vSQ * t * u - uSQ * vSQ - 2.0 * t * v * d + 2.0 * u * v * d - d * d;
        double x = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        assert (x != Double.NaN);
        if (velocity >= 0.0) {
            r.modify(1L, (double)direction * ((t + x - u) * v + d), angle);
        } else {
            r.modify(1L, (double)(-1 * direction) * ((t + x - u) * v + d), angle);
        }
        r.adjustForWalls(this, 1, bulletSource, bulletSpeed, angle);
        return r;
    }

    public boolean adjustForWalls(Position prev, int bounce, Position bulletSource, double bulletSpeed, double cHeading) {
        int Walldistance = 18;
        double d = this.distance(prev);
        assert (!Double.isNaN(d));
        assert (d != 0.0);
        double origHeading = prev.getDirectionTo(this);
        assert (!Double.isNaN(origHeading));
        int maxReruns = 5;
        boolean corrected = false;
        while (true) {
            double t2;
            double t1;
            double r;
            double heading;
            double correction = heading = origHeading;
            int b = bounce;
            if (this.x < (double)Walldistance && cHeading > Math.PI) {
                correction = Math.acos((prev.x - (double)Walldistance) / d);
                if (this.y < prev.y) {
                    b *= -1;
                }
                correction = 4.71238898038469 + (double)b * correction;
                assert (!Double.isNaN(correction));
                corrected = true;
            } else if (this.x > BATTLEFIELD_WIDTH - (double)Walldistance && cHeading < Math.PI) {
                correction = Math.acos((BATTLEFIELD_WIDTH - (double)Walldistance - prev.x) / d);
                if (this.y > prev.y) {
                    b *= -1;
                }
                correction = 1.5707963267948966 + (double)b * correction;
                assert (!Double.isNaN(correction));
                corrected = true;
            } else if (this.y > BATTLEFIELD_HEIGHT - (double)Walldistance && (cHeading < 1.5707963267948966 || cHeading > 4.71238898038469)) {
                correction = Math.acos((BATTLEFIELD_HEIGHT - (double)Walldistance - prev.y) / d);
                if (this.x < prev.x) {
                    b *= -1;
                }
                correction = Utils.normalAbsoluteAngle((double)(Math.PI * 2 + (double)b * correction));
                assert (!Double.isNaN(correction));
                corrected = true;
            } else if (this.y < (double)Walldistance && cHeading > 1.5707963267948966 && cHeading < 4.71238898038469) {
                correction = Math.acos((prev.y - (double)Walldistance) / d);
                if (this.x > prev.x) {
                    b *= -1;
                }
                correction = Math.PI + (double)b * correction;
                assert (!Double.isNaN(correction));
                corrected = true;
            }
            if (!corrected || maxReruns <= 0) break;
            Log.log(5, "Adjust for walls: (d = " + d + ", origHeading = " + origHeading + ", prev = " + prev + ", new = " + this + ", bounce = " + bounce + ")");
            this.wasWallCorrected = true;
            assert (!Double.isNaN(correction));
            --maxReruns;
            Log.log(5, "correction = " + correction);
            double diff = correction - heading;
            Log.log(5, "Wall hit, new heading: " + (heading += diff));
            Position p = new Position(prev);
            p.modify(1L, d, heading);
            p.correctForWalls();
            this.x = p.x;
            this.y = p.y;
            if (bulletSource == null || !((r = (t1 = this.distance(bulletSource) / bulletSpeed) / (t2 = this.distance(prev) / 8.0)) < 0.9) && !(r > 1.1)) break;
            Log.log(4, "Wall correction updating, r = " + r);
            d -= (1.0 - r) * d / 4.0;
            Position pp = new Position(prev);
            pp.modify(1L, d, origHeading);
            this.x = pp.x;
            this.y = pp.y;
        }
        if (this.x == Double.NaN || this.y == Double.NaN) assert (false);
        return corrected;
    }

    public Position computeEscapePosition(double velocity, double heading, Position bulletSource, double bulletVelocity, int direction, double maxVelocity, int timeOffset) {
        double origVelocity = velocity;
        Position r = new Position(this);
        int i = 0;
        while ((double)i < bulletSource.distance(r) / bulletVelocity - 1.0 - (double)timeOffset) {
            double angle = r.getDirectionTo(bulletSource);
            double angle1 = Utils.normalAbsoluteAngle((double)(angle + 1.5707963267948966));
            double angle2 = Utils.normalAbsoluteAngle((double)(angle - 1.5707963267948966));
            angle = Math.abs(Utils.normalRelativeAngle((double)(heading - angle1))) < Math.abs(Utils.normalRelativeAngle((double)(heading - angle2))) ? angle1 : angle2;
            double mod = Utils.normalRelativeAngle((double)(angle - heading));
            double maxMod = Math.toRadians(10.0 - 0.75 * Math.abs(velocity));
            if (mod > 0.0 && mod > maxMod) {
                mod = maxMod;
            } else if (mod < 0.0 && mod < -maxMod) {
                mod = -maxMod;
            }
            heading = Utils.normalAbsoluteAngle((double)(heading + mod));
            velocity = direction == 1 ? (origVelocity >= 0.0 ? (velocity += 1.0) : (velocity -= 1.0)) : (origVelocity >= 0.0 ? (velocity > 0.0 ? (velocity -= 2.0) : (velocity -= 1.0)) : (velocity < 0.0 ? (velocity += 2.0) : (velocity += 1.0)));
            if (velocity > maxVelocity) {
                velocity = maxVelocity;
            } else if (velocity < -maxVelocity) {
                velocity = -maxVelocity;
            }
            if (velocity != 0.0) {
                Position prev = new Position(r);
                r.check();
                r.modify(1L, velocity, heading);
                r.adjustForWalls(prev, 1, null, 0.0, velocity < 0.0 ? Utils.normalAbsoluteAngle((double)(heading + Math.PI)) : heading);
                r.check();
            }
            Log.paintPoint(3, r, direction == 1 ? Color.RED : Color.BLACK);
            ++i;
        }
        return r;
    }

    public void modify(long TimeDelta, double Velocity, double Bearing) {
        this.x += (double)TimeDelta * Velocity * Math.sin(Bearing);
        this.y += (double)TimeDelta * Velocity * Math.cos(Bearing);
    }

    @Override
    public String toString() {
        return String.format("%.1f,%.1f", this.x, this.y);
    }

    public void drawCross(Graphics2D g, int size) {
        g.drawLine((int)this.x - size / 2, (int)this.y - size / 2, (int)this.x + size / 2, (int)this.y + size / 2);
        g.drawLine((int)this.x - size / 2, (int)this.y + size / 2, (int)this.x + size / 2, (int)this.y - size / 2);
    }

    public double projectAngle(long deltaTime, double maxSpeed, double currentSpeed, Opponent o, int changeDirection, boolean stop) {
        double t;
        double fullSpeedAngleMovement = Math.asin(maxSpeed / this.distance(o.getLastPosition()));
        double v = fullSpeedAngleMovement * Math.abs(currentSpeed) / 8.0;
        double angleMovement = 0.0;
        if (stop) {
            t = maxSpeed / 2.0;
            deltaTime = (long)((double)deltaTime - t);
            angleMovement += t * v / 2.0;
        }
        if (changeDirection == 0) {
            t = (maxSpeed - Math.abs(currentSpeed)) / 1.0;
            angleMovement += t * (fullSpeedAngleMovement - (fullSpeedAngleMovement - v) / 2.0);
            angleMovement += ((double)deltaTime - t) * fullSpeedAngleMovement;
        } else {
            t = Math.abs(currentSpeed) / 2.0;
            angleMovement += t * v / 2.0;
            double tt = maxSpeed / 1.0;
            angleMovement -= tt * fullSpeedAngleMovement / 2.0;
            angleMovement -= ((double)deltaTime - t - tt) * fullSpeedAngleMovement;
        }
        if (currentSpeed < 0.0) {
            angleMovement *= -1.0;
        }
        return angleMovement;
    }

    public Position getAverage(Position position) {
        return new Position((this.x + position.x) / 2.0, (this.y + position.y) / 2.0);
    }

    public boolean inCorner(int boundary) {
        if (this.x < (double)boundary && this.y < (double)boundary) {
            return true;
        }
        if (this.x < (double)boundary && this.y > BATTLEFIELD_HEIGHT - (double)boundary) {
            return true;
        }
        if (this.x > BATTLEFIELD_WIDTH - (double)boundary && this.y < (double)boundary) {
            return true;
        }
        return this.x > BATTLEFIELD_WIDTH - (double)boundary && this.y > BATTLEFIELD_HEIGHT - (double)boundary;
    }

    public void check() {
        assert (!Double.isNaN(this.x));
        assert (!Double.isNaN(this.y));
        assert (this.x >= 18.0 && this.y >= 18.0 && this.x <= BATTLEFIELD_WIDTH - 18.0 && this.y <= BATTLEFIELD_HEIGHT - 18.0);
    }

    public void correctForWalls() {
        double d = 18.0005;
        if (this.x < d) {
            this.x = d;
        }
        if (this.y < d) {
            this.y = d;
        }
        if (this.x > BATTLEFIELD_WIDTH - d) {
            this.x = BATTLEFIELD_WIDTH - d;
        }
        if (this.y > BATTLEFIELD_HEIGHT - d) {
            this.y = BATTLEFIELD_HEIGHT - d;
        }
    }

    protected static Position[] kNeighbors(Position[] seed, Position[] p, int offset, int k) {
        Position[] r = seed;
        int[] n = new int[k];
        int i = 0;
        while (i < k) {
            n[i] = 1;
            ++i;
        }
        int j = offset;
        while (j < p.length) {
            double dMin = 1.0E7;
            int i2 = 0;
            int a = 0;
            while (a < k) {
                double d = r[a].distance(p[j]);
                if (d < dMin) {
                    dMin = d;
                    i2 = a;
                }
                ++a;
            }
            r[i2].x = (r[i2].x * (double)n[i2] + p[j].x) / (double)(n[i2] + 1);
            r[i2].y = (r[i2].y * (double)n[i2] + p[j].y) / (double)(n[i2] + 1);
            int n2 = i2;
            n[n2] = n[n2] + 1;
            ++j;
        }
        int d = 0;
        int i3 = 1;
        while (i3 < k) {
            if (n[i3] > n[d]) {
                d = i3;
            }
            ++i3;
        }
        Position tmp = r[d];
        r[d] = r[0];
        r[0] = tmp;
        return r;
    }

    public static Position[] kNeighbors(Position[] p, int k) {
        Position[] seed = new Position[k];
        int i = 0;
        while (i < k) {
            seed[i] = new Position(p[i]);
            ++i;
        }
        Position[] r = Position.kNeighbors(seed, p, k, k);
        Position[] rr = Position.kNeighbors(r, p, 0, k);
        int i2 = 0;
        while (i2 < k) {
            Log.paintFilledCircle(3, rr[i2], 9, new Color(100, 100, 255, 100), 2);
            ++i2;
        }
        return rr;
    }

    public boolean isWallCorrected() {
        return this.wasWallCorrected;
    }

    public boolean isInBattlefield() {
        int Walldistance = 18;
        if (this.x > BATTLEFIELD_WIDTH - (double)Walldistance) {
            return false;
        }
        if (this.x < (double)Walldistance) {
            return false;
        }
        if (this.y > BATTLEFIELD_HEIGHT - (double)Walldistance) {
            return false;
        }
        return !(this.y < (double)Walldistance);
    }

    public double getWallDistance() {
        double h;
        double w = BATTLEFIELD_WIDTH - this.x;
        if (this.x < w) {
            w = this.x;
        }
        if (this.y < (h = BATTLEFIELD_HEIGHT - this.y)) {
            h = this.y;
        }
        return w < h ? w : h;
    }
}

